/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.UT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityClassContainer {
    public final Class<? extends TileEntity> mClass;
    public final MultiTileEntityBlock mBlock;
    public final TileEntity mCanonicalTileEntity;
    public final NBTTagCompound mParameters;
    public final byte mBlockMetaData;
    public final byte mStackSize;
    public final short mID;
    public final short mCreativeTabID;
    public final boolean mHidden;

    public MultiTileEntityClassContainer(int aID, int aCreativeTabID, Class<? extends TileEntity> aClass, int aBlockMetaData, int aStackSize, MultiTileEntityBlock aBlock, NBTTagCompound aParameters) {
        if (!IMultiTileEntity.class.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("MultiTileEntities must implement the Interface IMultiTileEntity!");
        }
        this.mBlockMetaData = (byte)aBlockMetaData;
        this.mStackSize = (byte)aStackSize;
        this.mParameters = aParameters == null ? UT.NBT.make() : aParameters;
        this.mHidden = this.mParameters.getBoolean("gt.hidden");
        this.mID = (short)aID;
        this.mCreativeTabID = (short)aCreativeTabID;
        this.mBlock = aBlock;
        this.mClass = aClass;
        if (this.mParameters.hasKey("gt.material") && !this.mParameters.hasKey("gt.color")) {
            this.mParameters.setInteger("gt.color", UT.Code.getRGBInt(OreDictMaterial.get((String)this.mParameters.getString((String)"gt.material")).fRGBaSolid));
        }
        try {
            this.mCanonicalTileEntity = aClass.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        if (this.mCanonicalTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)this.mCanonicalTileEntity).initFromNBT(this.mParameters, this.mID, (short)-1);
        }
    }
}

