/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover;

import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class CoverData {
    public short[] mIDs;
    public short[] mMetas;
    public short[] mVisuals;
    public short[] mValues;
    public boolean[] mVisualsToSync = new boolean[]{false, false, false, false, false, false};
    public boolean mStopped = false;
    public NBTTagCompound[] mNBTs;
    public ICover[] mBehaviours = new ICover[6];
    public ITileEntityCoverable mTileEntity;

    public CoverData(ITileEntityCoverable aTileEntity) {
        this.mIDs = new short[6];
        this.mMetas = new short[6];
        this.mVisuals = new short[6];
        this.mValues = new short[6];
        this.mNBTs = new NBTTagCompound[6];
        this.mTileEntity = aTileEntity;
    }

    public CoverData(short[] aIDs, short[] aMetas, short[] aVisuals, short[] aValues, NBTTagCompound[] aNBTs, boolean aStopped, ITileEntityCoverable aTileEntity) {
        this.mVisuals = aVisuals;
        this.mValues = aValues;
        this.mNBTs = aNBTs;
        for (int i = 0; i < this.mNBTs.length; ++i) {
            if (this.mNBTs[i] == null || !this.mNBTs[i].hasNoTags()) continue;
            this.mNBTs[i] = null;
        }
        this.setIDs(aIDs, aMetas);
        this.mStopped = aStopped;
        this.mTileEntity = aTileEntity;
        if (this.mTileEntity != null) {
            try {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (this.mBehaviours[tSide] == null) continue;
                    this.mBehaviours[tSide].onCoverLoaded(tSide, this);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
                this.mTileEntity.setError("Cover Loaded:" + e);
            }
        }
    }

    public CoverData(ITileEntityCoverable aTileEntity, NBTTagCompound aNBT) {
        this(new short[]{aNBT.getShort("a"), aNBT.getShort("b"), aNBT.getShort("c"), aNBT.getShort("d"), aNBT.getShort("e"), aNBT.getShort("f")}, new short[]{aNBT.getShort("g"), aNBT.getShort("h"), aNBT.getShort("i"), aNBT.getShort("j"), aNBT.getShort("k"), aNBT.getShort("l")}, new short[]{aNBT.getShort("m"), aNBT.getShort("n"), aNBT.getShort("o"), aNBT.getShort("p"), aNBT.getShort("q"), aNBT.getShort("r")}, new short[]{aNBT.getShort("0"), aNBT.getShort("1"), aNBT.getShort("2"), aNBT.getShort("3"), aNBT.getShort("4"), aNBT.getShort("5")}, new NBTTagCompound[]{aNBT.getCompoundTag("s"), aNBT.getCompoundTag("t"), aNBT.getCompoundTag("u"), aNBT.getCompoundTag("v"), aNBT.getCompoundTag("w"), aNBT.getCompoundTag("x")}, aNBT.getBoolean("y"), aTileEntity);
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(UT.NBT.make(), true);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT, boolean aIncludeVisuals) {
        byte i = 0;
        if (this.mIDs[i] != 0) {
            aNBT.setShort("a", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("g", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("0", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("s", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("m", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.setShort("b", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("h", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("1", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("t", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("n", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.setShort("c", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("i", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("2", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("u", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("o", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.setShort("d", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("j", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("3", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("v", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("p", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.setShort("e", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("k", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("4", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("w", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("q", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)(i + 1)] != 0) {
            aNBT.setShort("f", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.setShort("l", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.setShort("5", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].hasNoTags()) {
                aNBT.setTag("x", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.setShort("r", this.mVisuals[i]);
            }
        }
        if (this.mStopped) {
            aNBT.setBoolean("y", this.mStopped);
        }
        return aNBT;
    }

    public CoverData setIDs(short[] aIDs, short[] aMetas) {
        this.mIDs = aIDs;
        this.mMetas = aMetas;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            this.mBehaviours[tSide] = this.mIDs[tSide] == 0 ? null : CoverRegistry.get(this.mIDs[tSide], this.mMetas[tSide]);
        }
        return this;
    }

    public CoverData set(byte aSide, ItemStack aStack) {
        return aStack == null ? this.set(aSide, (short)0, (short)0, null) : this.set(aSide, ST.id(aStack), ST.meta_(aStack), aStack.getTagCompound());
    }

    public CoverData set(byte aSide, short aID, short aMeta, NBTTagCompound aNBT) {
        this.mIDs[aSide] = aID;
        this.mMetas[aSide] = aMeta;
        this.mBehaviours[aSide] = aID == 0 ? null : CoverRegistry.get(aID, aMeta);
        this.mNBTs[aSide] = (NBTTagCompound)(aNBT == null || aNBT.hasNoTags() ? null : aNBT.copy());
        return this;
    }

    public CoverData value(byte aSide, short aValue) {
        return this.value(aSide, aValue, false);
    }

    public CoverData value(byte aSide, short aValue, boolean aBlockUpdate) {
        if (this.mValues[aSide] != aValue) {
            this.mValues[aSide] = aValue;
            if (aBlockUpdate) {
                this.mTileEntity.sendBlockUpdateFromCover();
            }
        }
        return this;
    }

    public CoverData visual(byte aSide, short aVisual) {
        return this.visual(aSide, aVisual, false);
    }

    public CoverData visual(byte aSide, short aVisual, boolean aBlockUpdate) {
        if (this.mVisuals[aSide] != aVisual) {
            this.mVisuals[aSide] = aVisual;
            this.mVisualsToSync[aSide] = true;
            this.mTileEntity.updateCoverVisuals();
            if (aBlockUpdate) {
                this.mTileEntity.sendBlockUpdateFromCover();
            }
        }
        return this;
    }

    public boolean setStopped(boolean aStopped) {
        if (aStopped == this.mStopped) {
            return false;
        }
        this.mStopped = aStopped;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.mBehaviours[tSide] == null) continue;
            this.mBehaviours[tSide].onStoppedUpdate(tSide, this, this.mStopped);
        }
        return true;
    }

    public boolean onBlockUpdate() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.mBehaviours[tSide] == null) continue;
            this.mBehaviours[tSide].onBlockUpdate(tSide, this);
        }
        return true;
    }

    public ItemStack getCoverItem(byte aSide) {
        return this.mIDs[aSide] == 0 ? null : (this.mBehaviours[aSide] == null ? ST.make((long)this.mIDs[aSide], 1L, (long)this.mMetas[aSide], this.mNBTs[aSide] == null || this.mNBTs[aSide].hasNoTags() ? null : this.mNBTs[aSide]) : this.mBehaviours[aSide].getCoverItem(aSide, this));
    }

    public DelegatorTileEntity<ITileEntityCoverable> delegator(byte aSide) {
        return new DelegatorTileEntity<ITileEntityCoverable>(this.mTileEntity, aSide);
    }

    public boolean requiresSync() {
        return UT.Code.containsBoolean(true, this.mVisualsToSync);
    }

    public void resetSync() {
        for (int i = 0; i < this.mVisualsToSync.length; ++i) {
            this.mVisualsToSync[i] = false;
        }
    }

    public void tickPre(long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        try {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mBehaviours[tSide] == null) continue;
                this.mBehaviours[tSide].onTickPre(tSide, this, aTimer, aIsServerSide, aReceivedBlockUpdate, aReceivedInventoryUpdate);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            this.mTileEntity.setError("Cover Pre Tick - " + (aIsServerSide ? "Serverside: " : "Clientside: ") + e);
        }
    }

    public void tickPost(long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        try {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mBehaviours[tSide] == null) continue;
                this.mBehaviours[tSide].onTickPost(tSide, this, aTimer, aIsServerSide, aReceivedBlockUpdate, aReceivedInventoryUpdate);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            this.mTileEntity.setError("Cover Post Tick - " + (aIsServerSide ? "Serverside: " : "Clientside: ") + e);
        }
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.mTileEntity.getX() + aMinX), (double)((double)this.mTileEntity.getY() + aMinY), (double)((double)this.mTileEntity.getZ() + aMinZ), (double)((double)this.mTileEntity.getX() + aMaxX), (double)((double)this.mTileEntity.getY() + aMaxY), (double)((double)this.mTileEntity.getZ() + aMaxZ));
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.mTileEntity.getX() + aBox[0]), (double)((double)this.mTileEntity.getY() + aBox[1]), (double)((double)this.mTileEntity.getZ() + aBox[2]), (double)((double)this.mTileEntity.getX() + aBox[3]), (double)((double)this.mTileEntity.getY() + aBox[4]), (double)((double)this.mTileEntity.getZ() + aBox[5]));
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((float)this.mTileEntity.getX() + aBox[0]), (double)((float)this.mTileEntity.getY() + aBox[1]), (double)((float)this.mTileEntity.getZ() + aBox[2]), (double)((float)this.mTileEntity.getX() + aBox[3]), (double)((float)this.mTileEntity.getY() + aBox[4]), (double)((float)this.mTileEntity.getZ() + aBox[5]));
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.getBoundingBox((double)this.mTileEntity.getX(), (double)this.mTileEntity.getY(), (double)this.mTileEntity.getZ(), (double)(this.mTileEntity.getX() + 1), (double)(this.mTileEntity.getY() + 1), (double)(this.mTileEntity.getZ() + 1));
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        AxisAlignedBB tBox = this.box(aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, float[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        AxisAlignedBB tBox = this.box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aBox, AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        return aBox != null && aBox.intersectsWith(aAABB) && aList.add(aBox);
    }
}

