/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.util.ST;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public interface IItemRottable {
    public ItemStack getRotten(ItemStack var1);

    public ItemStack getRotten(ItemStack var1, World var2, int var3, int var4, int var5);

    public static class RottingUtil {
        public static ItemStack rotting(ItemStack aStack) {
            if (aStack.getItem() == Items.milk_bucket) {
                return IL.ENVM_Spoiled_Milk_Bucket.exists() ? IL.ENVM_Spoiled_Milk_Bucket.get(aStack.stackSize, new Object[0]) : ST.make(Items.bucket, (long)aStack.stackSize, 0L);
            }
            if (aStack.getItem() instanceof IItemRottable) {
                return ((IItemRottable)aStack.getItem()).getRotten(aStack);
            }
            if (aStack.getItem() instanceof IFluidContainerItem) {
                return RottingUtil.rotting(aStack, (IFluidContainerItem)aStack.getItem());
            }
            return aStack;
        }

        public static ItemStack rotting(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
            if (aStack.getItem() == Items.milk_bucket) {
                return IL.ENVM_Spoiled_Milk_Bucket.exists() ? IL.ENVM_Spoiled_Milk_Bucket.get(aStack.stackSize, new Object[0]) : ST.make(Items.bucket, (long)aStack.stackSize, 0L);
            }
            if (aStack.getItem() instanceof IItemRottable) {
                return ((IItemRottable)aStack.getItem()).getRotten(aStack, aWorld, aX, aY, aZ);
            }
            if (aStack.getItem() instanceof IFluidContainerItem) {
                return RottingUtil.rotting(aStack, (IFluidContainerItem)aStack.getItem());
            }
            return aStack;
        }

        public static ItemStack rotting(ItemStack aStack, IFluidContainerItem aItem) {
            FluidStack tFluid = aItem.getFluid(aStack);
            if (!(tFluid == null || FL.Milk_Spoiled.is(tFluid) || FL.Rotten_Drink.is(tFluid) || FL.Dirty_Water.is(tFluid) || FL.Swampwater.is(tFluid) || FL.Stagnant_Water.is(tFluid))) {
                if (CS.FluidsGT.WATER.contains(tFluid.getFluid().getName())) {
                    aItem.drain(aStack, Integer.MAX_VALUE, true);
                    aItem.fill(aStack, FL.Dirty_Water.make(tFluid.amount), true);
                } else if (CS.FluidsGT.MILK.contains(tFluid.getFluid().getName())) {
                    aItem.drain(aStack, Integer.MAX_VALUE, true);
                    aItem.fill(aStack, FL.Milk_Spoiled.make(tFluid.amount), true);
                } else if (CS.FluidsGT.FOOD.contains(tFluid.getFluid().getName())) {
                    aItem.drain(aStack, Integer.MAX_VALUE, true);
                    aItem.fill(aStack, FL.Rotten_Drink.make(tFluid.amount), true);
                }
            }
            return aStack;
        }
    }
}

