/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class Behavior_Bucket_Container
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Bucket_Container();

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MovingObjectPosition tPosition = WD.getMOP(aWorld, aPlayer, true);
        if (tPosition == null || tPosition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return aStack;
        }
        if (!aWorld.canMineBlock(aPlayer, tPosition.blockX, tPosition.blockY, tPosition.blockZ)) {
            return aStack;
        }
        Block tBlock = aWorld.getBlock(tPosition.blockX, tPosition.blockY, tPosition.blockZ);
        if (tBlock == Blocks.water || tBlock == Blocks.flowing_water) {
            if (aWorld.getBlockMetadata(tPosition.blockX, tPosition.blockY, tPosition.blockZ) == 0 && aItem.fill(aStack, FL.Water.make(1000L), false) == 1000) {
                aWorld.setBlockToAir(tPosition.blockX, tPosition.blockY, tPosition.blockZ);
                aItem.fill(aStack, FL.Water.make(1000L), true);
            }
            return aStack;
        }
        if (tBlock == Blocks.lava || tBlock == Blocks.flowing_lava) {
            if (aWorld.getBlockMetadata(tPosition.blockX, tPosition.blockY, tPosition.blockZ) == 0 && aItem.fill(aStack, FL.Lava.make(1000L), false) == 1000) {
                aWorld.setBlockToAir(tPosition.blockX, tPosition.blockY, tPosition.blockZ);
                aItem.fill(aStack, FL.Lava.make(1000L), true);
            }
            return aStack;
        }
        if (tBlock == CS.BlocksGT.River) {
            aItem.fill(aStack, FL.Water.make(1000L), true);
            return aStack;
        }
        if (tBlock == CS.BlocksGT.Ocean) {
            aItem.fill(aStack, FL.Ocean.make(1000L), true);
            return aStack;
        }
        if (tBlock == CS.BlocksGT.Swamp) {
            aItem.fill(aStack, FL.Dirty_Water.make(1000L), true);
            return aStack;
        }
        if (tBlock instanceof IFluidBlock) {
            FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tPosition.blockX, tPosition.blockY, tPosition.blockZ, false);
            if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                aItem.fill(aStack, tDrained, true);
                ((IFluidBlock)tBlock).drain(aWorld, tPosition.blockX, tPosition.blockY, tPosition.blockZ, true);
            }
            return aStack;
        }
        tPosition.blockX += CS.OFFX[tPosition.sideHit];
        tPosition.blockY += CS.OFFY[tPosition.sideHit];
        tPosition.blockZ += CS.OFFZ[tPosition.sideHit];
        tBlock = aWorld.getBlock(tPosition.blockX, tPosition.blockY, tPosition.blockZ);
        if (tBlock instanceof IFluidBlock) {
            FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tPosition.blockX, tPosition.blockY, tPosition.blockZ, false);
            if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                aItem.fill(aStack, tDrained, true);
                ((IFluidBlock)tBlock).drain(aWorld, tPosition.blockX, tPosition.blockY, tPosition.blockZ, true);
            }
            return aStack;
        }
        return aStack;
    }
}

