/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class Behavior_CureZombie
extends IBehavior.AbstractBehaviorDefault {
    public final int mAverageCureTime;
    public final boolean mNeedsWeakness;

    public Behavior_CureZombie(int aAverageCureTime, boolean aNeedsWeakness) {
        this.mAverageCureTime = aAverageCureTime;
        this.mNeedsWeakness = aNeedsWeakness;
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aEntity instanceof EntityZombie && ((EntityZombie)aEntity).isVillager() && (!this.mNeedsWeakness || ((EntityZombie)aEntity).isPotionActive(Potion.weakness))) {
            UT.Entities.consumeCurrentItem(aPlayer);
            if (!aEntity.worldObj.isRemote) {
                int tCureTime = CS.RNGSUS.nextInt(this.mAverageCureTime * 2) + 500;
                NBTTagCompound tNBT = UT.NBT.make();
                aEntity.writeToNBT(tNBT);
                tNBT.setInteger("ConversionTime", tCureTime);
                aEntity.readFromNBT(tNBT);
                aEntity.getDataWatcher().updateObject(14, (Object)1);
                ((EntityZombie)aEntity).removePotionEffect(Potion.weakness.id);
                ((EntityZombie)aEntity).addPotionEffect(new PotionEffect(Potion.damageBoost.id, tCureTime, Math.min(((EntityZombie)aEntity).worldObj.difficultySetting.getDifficultyId() - 1, 0)));
                aEntity.worldObj.setEntityState(aEntity, (byte)16);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get(this.mNeedsWeakness ? "gt.behaviour.cure.zombie.weak" : "gt.behaviour.cure.zombie.strong"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.cure.zombie.strong", "Can be used to cure strong Zombie Villagers");
        LH.add("gt.behaviour.cure.zombie.weak", "Can be used to cure weakened Zombie Villagers");
    }
}

