/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.GT_API;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.render.IIconContainer;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class TextureSet {
    public static final List<TextureSet> INSTANCES_ITEM = new ArrayListNoNulls<TextureSet>();
    public static final List<TextureSet> INSTANCES_BLOCK = new ArrayListNoNulls<TextureSet>();
    public static final List<String> FILENAMES_ITEM = new ArrayListNoNulls<String>();
    public static final List<String> FILENAMES_BLOCK = new ArrayListNoNulls<String>();
    public final List<IIconContainer> mList = new ArrayListNoNulls<IIconContainer>();
    private final boolean mIsItem;
    private final String mNameSet;
    public static final TextureSet[] SET_NONE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "NONE"), TextureSet.addTextureSet(MD.GT.mID, true, "NONE")};
    public static final TextureSet[] SET_DULL = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "DULL"), TextureSet.addTextureSet(MD.GT.mID, true, "DULL")};
    public static final TextureSet[] SET_RAD = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "RAD"), TextureSet.addTextureSet(MD.GT.mID, true, "RAD")};
    public static final TextureSet[] SET_HEX = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "HEX"), TextureSet.addTextureSet(MD.GT.mID, true, "HEX")};
    public static final TextureSet[] SET_RUBY = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "RUBY"), TextureSet.addTextureSet(MD.GT.mID, true, "RUBY")};
    public static final TextureSet[] SET_OPAL = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "OPAL"), TextureSet.addTextureSet(MD.GT.mID, true, "OPAL")};
    public static final TextureSet[] SET_LEAF = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "LEAF"), TextureSet.addTextureSet(MD.GT.mID, true, "LEAF")};
    public static final TextureSet[] SET_SAND = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "SAND"), TextureSet.addTextureSet(MD.GT.mID, true, "SAND")};
    public static final TextureSet[] SET_FINE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "FINE"), TextureSet.addTextureSet(MD.GT.mID, true, "FINE")};
    public static final TextureSet[] SET_FOOD = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "FOOD"), TextureSet.addTextureSet(MD.GT.mID, true, "FOOD")};
    public static final TextureSet[] SET_WOOD = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "WOOD"), TextureSet.addTextureSet(MD.GT.mID, true, "WOOD")};
    public static final TextureSet[] SET_CUBE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "CUBE"), TextureSet.addTextureSet(MD.GT.mID, true, "CUBE")};
    public static final TextureSet[] SET_FIERY = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "FIERY"), TextureSet.addTextureSet(MD.GT.mID, true, "FIERY")};
    public static final TextureSet[] SET_GAS = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "GAS"), TextureSet.addTextureSet(MD.GT.mID, true, "GAS")};
    public static final TextureSet[] SET_FLUID = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "FLUID"), TextureSet.addTextureSet(MD.GT.mID, true, "FLUID")};
    public static final TextureSet[] SET_PLASMA = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "PLASMA"), TextureSet.addTextureSet(MD.GT.mID, true, "PLASMA")};
    public static final TextureSet[] SET_ROUGH = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "ROUGH"), TextureSet.addTextureSet(MD.GT.mID, true, "ROUGH")};
    public static final TextureSet[] SET_STONE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "STONE"), TextureSet.addTextureSet(MD.GT.mID, true, "STONE")};
    public static final TextureSet[] SET_BRICK = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "BRICK"), TextureSet.addTextureSet(MD.GT.mID, true, "BRICK")};
    public static final TextureSet[] SET_SPACE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "SPACE"), TextureSet.addTextureSet(MD.GT.mID, true, "SPACE")};
    public static final TextureSet[] SET_PAPER = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "PAPER"), TextureSet.addTextureSet(MD.GT.mID, true, "PAPER")};
    public static final TextureSet[] SET_GLASS = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "GLASS"), TextureSet.addTextureSet(MD.GT.mID, true, "GLASS")};
    public static final TextureSet[] SET_FLINT = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "FLINT"), TextureSet.addTextureSet(MD.GT.mID, true, "FLINT")};
    public static final TextureSet[] SET_LAPIS = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "LAPIS"), TextureSet.addTextureSet(MD.GT.mID, true, "LAPIS")};
    public static final TextureSet[] SET_SHINY = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "SHINY"), TextureSet.addTextureSet(MD.GT.mID, true, "SHINY")};
    public static final TextureSet[] SET_RUBBER = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "RUBBER"), TextureSet.addTextureSet(MD.GT.mID, true, "RUBBER")};
    public static final TextureSet[] SET_SHARDS = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "SHARDS"), TextureSet.addTextureSet(MD.GT.mID, true, "SHARDS")};
    public static final TextureSet[] SET_POWDER = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "POWDER"), TextureSet.addTextureSet(MD.GT.mID, true, "POWDER")};
    public static final TextureSet[] SET_COPPER = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "COPPER"), TextureSet.addTextureSet(MD.GT.mID, true, "COPPER")};
    public static final TextureSet[] SET_QUARTZ = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "QUARTZ"), TextureSet.addTextureSet(MD.GT.mID, true, "QUARTZ")};
    public static final TextureSet[] SET_EMERALD = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "EMERALD"), TextureSet.addTextureSet(MD.GT.mID, true, "EMERALD")};
    public static final TextureSet[] SET_DIAMOND = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "DIAMOND"), TextureSet.addTextureSet(MD.GT.mID, true, "DIAMOND")};
    public static final TextureSet[] SET_LIGNITE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "LIGNITE"), TextureSet.addTextureSet(MD.GT.mID, true, "LIGNITE")};
    public static final TextureSet[] SET_REDSTONE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "REDSTONE"), TextureSet.addTextureSet(MD.GT.mID, true, "REDSTONE")};
    public static final TextureSet[] SET_MAGNETIC = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "MAGNETIC"), TextureSet.addTextureSet(MD.GT.mID, true, "MAGNETIC")};
    public static final TextureSet[] SET_METALLIC = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "METALLIC"), TextureSet.addTextureSet(MD.GT.mID, true, "METALLIC")};
    public static final TextureSet[] SET_PRISMARINE = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "PRISMARINE"), TextureSet.addTextureSet(MD.GT.mID, true, "PRISMARINE")};
    public static final TextureSet[] SET_CUBE_SHINY = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "CUBE_SHINY"), TextureSet.addTextureSet(MD.GT.mID, true, "CUBE_SHINY")};
    public static final TextureSet[] SET_NETHERSTAR = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "NETHERSTAR"), TextureSet.addTextureSet(MD.GT.mID, true, "NETHERSTAR")};
    public static final TextureSet[] SET_GEM_VERTICAL = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "GEM_VERTICAL"), TextureSet.addTextureSet(MD.GT.mID, true, "GEM_VERTICAL")};
    public static final TextureSet[] SET_GEM_HORIZONTAL = new TextureSet[]{TextureSet.addTextureSet(MD.GT.mID, false, "GEM_HORIZONTAL"), TextureSet.addTextureSet(MD.GT.mID, true, "GEM_HORIZONTAL")};

    private TextureSet(boolean aIsItem, String aNameSet) {
        this.mIsItem = aIsItem;
        this.mNameSet = aNameSet;
    }

    public static TextureSet addTextureSet(String aModID, boolean aIsItem, String aNameSet) {
        List<TextureSet> tTextureSetList = aIsItem ? INSTANCES_ITEM : INSTANCES_BLOCK;
        List<String> tFileNameList = aIsItem ? FILENAMES_ITEM : FILENAMES_BLOCK;
        for (TextureSet tSet : tTextureSetList) {
            if (!tSet.mNameSet.equals(aNameSet)) continue;
            return tSet;
        }
        TextureSet rSet = new TextureSet(aIsItem, aNameSet);
        tTextureSetList.add(rSet);
        int j = tFileNameList.size();
        for (int i = 0; i < j; ++i) {
            rSet.mList.add((IIconContainer)((Object)(aIsItem ? new TextureSetIconItem(aModID, aNameSet + "/" + tFileNameList.get(i)) : new TextureSetIconBlock(aModID, aNameSet + "/" + tFileNameList.get(i)))));
        }
        return rSet;
    }

    public static int addToAll(String aModID, boolean aIsItem, String aNameFile) {
        List<String> tFileNameList = aIsItem ? FILENAMES_ITEM : FILENAMES_BLOCK;
        int tIndex = tFileNameList.indexOf(aNameFile);
        if (tIndex >= 0) {
            return tIndex;
        }
        tFileNameList.add(aNameFile);
        for (TextureSet tSet : aIsItem ? INSTANCES_ITEM : INSTANCES_BLOCK) {
            tSet.mList.add((IIconContainer)((Object)(tSet.mIsItem ? new TextureSetIconItem(aModID, tSet.mNameSet + "/" + aNameFile) : new TextureSetIconBlock(aModID, tSet.mNameSet + "/" + aNameFile))));
        }
        return tFileNameList.size() - 1;
    }

    public static class TextureSetIconBlock
    implements IIconContainer,
    Runnable {
        private final String mMod;
        private final String mName;
        private IIcon mIconColored;
        private IIcon mIconOverlay;

        public TextureSetIconBlock(String aMod, String aName) {
            this.mName = aName;
            this.mMod = aMod;
            if (GT_API.sBlockIconload != null) {
                GT_API.sBlockIconload.add(this);
            }
        }

        @Override
        public IIcon getIcon(int aRenderPass) {
            return aRenderPass == 0 ? this.mIconColored : this.mIconOverlay;
        }

        @Override
        public short[] getIconColor(int aRenderPass) {
            return CS.UNCOLOURED;
        }

        @Override
        public int getIconPasses() {
            return 2;
        }

        @Override
        public ResourceLocation getTextureFile() {
            return TextureMap.locationBlocksTexture;
        }

        @Override
        public void registerIcons(IIconRegister aIconRegister) {
            this.mIconColored = aIconRegister.registerIcon(this.mMod + ":materialicons/" + this.mName);
            this.mIconOverlay = aIconRegister.registerIcon(this.mMod + ":materialicons/" + this.mName + "_OVERLAY");
        }

        public String toString() {
            return this.mMod + ":materialicons/" + this.mName;
        }

        @Override
        public boolean isUsingColorModulation(int aRenderPass) {
            return aRenderPass == 0;
        }

        @Override
        public void run() {
            this.registerIcons(GT_API.sBlockIcons);
        }
    }

    public static class TextureSetIconItem
    implements IIconContainer,
    Runnable {
        private final String mMod;
        private final String mName;
        private IIcon mIconColored;
        private IIcon mIconOverlay;

        public TextureSetIconItem(String aMod, String aName) {
            this.mName = aName;
            this.mMod = aMod.toLowerCase();
            if (GT_API.sItemIconload != null) {
                GT_API.sItemIconload.add(this);
            }
        }

        @Override
        public IIcon getIcon(int aRenderPass) {
            return aRenderPass == 0 ? this.mIconColored : this.mIconOverlay;
        }

        @Override
        public short[] getIconColor(int aRenderPass) {
            return CS.UNCOLOURED;
        }

        @Override
        public int getIconPasses() {
            return 2;
        }

        @Override
        public ResourceLocation getTextureFile() {
            return TextureMap.locationItemsTexture;
        }

        @Override
        public void registerIcons(IIconRegister aIconRegister) {
            this.mIconColored = aIconRegister.registerIcon(this.mMod + ":materialicons/" + this.mName);
            this.mIconOverlay = aIconRegister.registerIcon(this.mMod + ":materialicons/" + this.mName + "_OVERLAY");
        }

        public String toString() {
            return this.mMod + ":materialicons/" + this.mName;
        }

        @Override
        public boolean isUsingColorModulation(int aRenderPass) {
            return aRenderPass == 0;
        }

        @Override
        public void run() {
            this.registerIcons(GT_API.sItemIcons);
        }
    }
}

