/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase08Directional;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEntityBase09FacingSingle
extends TileEntityBase08Directional
implements IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_AddToolTips {
    public byte mFacing = this.getDefaultSide();

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.facing")) {
            this.mFacing = aNBT.getByte("gt.facing");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.setByte("gt.facing", this.mFacing);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.getFacingTool() != null) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.facing.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.facing.post"));
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (this.getFacingTool() != null && aTool.equals(this.getFacingTool())) {
            byte aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.getValidSides()[aTargetSide]) {
                byte oFacing = this.mFacing;
                this.mFacing = aTargetSide;
                this.updateClientData();
                this.causeBlockUpdate();
                this.onFacingChange(oFacing);
                return 10000L;
            }
        }
        return 0L;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mFacing = this.useSidePlacementRotation(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ) ? (this.useInversePlacementRotation(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ) ? (this.getValidSides()[CS.OPOS[aSide]] ? CS.OPOS[aSide] : this.getDefaultSide()) : (this.getValidSides()[aSide] ? aSide : this.getDefaultSide())) : (this.useInversePlacementRotation(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ) ? UT.Code.getOppositeSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides()) : UT.Code.getSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides()));
        this.onFacingChange((byte)6);
        this.checkCoverValidity();
        this.doEnetUpdate();
        return true;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mFacing & 7);
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mFacing = (byte)(aData & 7);
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    public short getFacing() {
        return this.mFacing;
    }

    public void setFacing(short aFacing) {
        this.setPrimaryFacing(UT.Code.side(aFacing));
    }

    public boolean wrenchCanSetFacing(EntityPlayer aPlayer, int aSide) {
        return "wrench".equals(this.getFacingTool()) && this.getValidSides()[aSide] && (aPlayer == null || aPlayer.getHeldItem() == null || !CS.ItemsGT.SPECIAL_CASE_TOOLS.contains(aPlayer.getHeldItem(), true));
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return aSide == this.mFacing;
    }

    public void setPrimaryFacing(byte aFacing) {
        if (this.isClientSide() || aFacing == this.mFacing) {
            return;
        }
        byte oFacing = this.mFacing;
        this.mFacing = aFacing;
        this.updateClientData();
        this.causeBlockUpdate();
        this.onFacingChange(oFacing);
        this.checkCoverValidity();
        this.doEnetUpdate();
        if (this.hasMultiBlockMachineRelevantData()) {
            ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
        }
    }

    public byte getDefaultSide() {
        return 1;
    }

    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    public void onFacingChange(byte aPreviousFacing) {
    }

    public boolean useSidePlacementRotation() {
        return false;
    }

    public boolean useSidePlacementRotation(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return this.useSidePlacementRotation();
    }

    public boolean useInversePlacementRotation() {
        return false;
    }

    public boolean useInversePlacementRotation(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return this.useInversePlacementRotation();
    }
}

