/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.tank;

import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityItemInternal;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.fluid.FluidTankGT;
import gregapi.item.multiitem.food.FoodStatFluid;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.crops.ICropTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import squeek.applecore.api.food.FoodValues;
import thaumcraft.common.tiles.TileCrucible;

public abstract class TileEntityBase08FluidContainer
extends TileEntityBase07Paintable
implements ITileEntityConnectedTank,
IMultiTileEntity.IMTE_GetMaxStackSize,
IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking,
IMultiTileEntity.IMTE_OnItemRightClick,
IMultiTileEntity.IMTE_OnItemUseFirst,
IMultiTileEntity.IMTE_AddToolTips,
IFluidContainerItem {
    public FluidTankGT mTank = new FluidTankGT(1000L);
    public boolean mLiquidProof = true;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public boolean mPlasmaProof = false;
    public boolean mMagicProof = false;
    public long mTemperatureMax = 0L;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.gasproof")) {
            this.mGasProof = aNBT.getBoolean("gt.gasproof");
        }
        if (aNBT.hasKey("gt.acidproof")) {
            this.mAcidProof = aNBT.getBoolean("gt.acidproof");
        }
        if (aNBT.hasKey("gt.magicproof")) {
            this.mMagicProof = aNBT.getBoolean("gt.magicproof");
        }
        if (aNBT.hasKey("gt.liquidproof")) {
            this.mLiquidProof = aNBT.getBoolean("gt.liquidproof");
        }
        if (aNBT.hasKey("gt.plasmaproof")) {
            this.mPlasmaProof = aNBT.getBoolean("gt.plasmaproof");
        }
        this.mTemperatureMax = aNBT.hasKey("gt.temperature") ? aNBT.getLong("gt.temperature") : this.mMaterial.mMeltingPoint - 50L;
        if (aNBT.hasKey("gt.tankcap")) {
            this.mTank.setCapacity(aNBT.getLong("gt.tankcap"));
        }
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        this.mTank.writeToNBT(aNBT, "gt.tank");
        if (this.isClientSide() && !this.mTank.isEmpty()) {
            aNBT.setTag("display", (NBTBase)UT.NBT.makeString(aNBT.getCompoundTag("display"), "Name", FL.name(this.mTank, true)));
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.mTank.contentcap());
        if (this.mTank.has(250L) && this.isDrinkable()) {
            FoodStatFluid.INSTANCE.addAdditionalToolTips(aStack.getItem(), aList, aStack, aF3_H);
            if (aStack.stackSize != 1) {
                aList.add(LH.Chat.RED + LH.get("gt.lang.requirement.unstacked"));
            }
        }
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.heat") + LH.Chat.WHITE + this.mTemperatureMax + LH.Chat.RED + " K");
        if (this.mLiquidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.liquid"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mPlasmaProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.plasma"));
        }
        if (this.mMagicProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.magic"));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.canFillWithRain() && CS.SERVER_TIME % 600L == 10L && this.worldObj.isRaining() && this.getRainOffset(0, 1, 0)) {
            Block tInFront;
            BiomeGenBase tBiome = this.getBiome();
            if (tBiome.rainfall > 0.0f && (double)tBiome.temperature >= 0.2 && !WD.liquid(tInFront = this.getBlockAtSide((byte)1)) && !tInFront.isSideSolid((IBlockAccess)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord, CS.FORGE_DIR_OPPOSITES[1]) && !tInFront.isSideSolid((IBlockAccess)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord, CS.FORGE_DIR[1])) {
                this.mTank.fill(FL.Water.make((long)Math.max(1.0f, tBiome.rainfall * 100.0f) * (long)(this.worldObj.isThundering() ? 2 : 1)), true);
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank, 1000L);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mTank.contentcap());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        ItemStack tStack = ST.container(ST.amount(1L, aStack), true);
        FluidStack tFluid = FL.getFluid(ST.amount(1L, aStack), true);
        if (aStack != null && this.isFluidAllowed(tFluid) && this.mTank.fillAll(tFluid)) {
            --aStack.stackSize;
            ST.give((Entity)aPlayer, tStack, true);
            return true;
        }
        if (aStack != null && (tStack = FL.fill(this.mTank, ST.amount(1L, aStack), true, true, true, true)) != null) {
            --aStack.stackSize;
            ST.give((Entity)aPlayer, tStack, true);
            return true;
        }
        if (this.isDrinkable() && this.canDrinkFromSide(aSide)) {
            aStack = this.toStack();
            if (aStack == null) {
                return true;
            }
            if (UT.Entities.isCreative(aPlayer) || aPlayer.getFoodStats().needFood() || FoodStatFluid.INSTANCE.alwaysEdible(aStack.getItem(), aStack, aPlayer)) {
                switch (FoodStatFluid.INSTANCE.getFoodAction(aStack.getItem(), aStack)) {
                    case eat: {
                        UT.Sounds.send("random.eat", this, false);
                        break;
                    }
                    default: {
                        UT.Sounds.send("random.drink", this, false);
                    }
                }
                this.mTank.remove(250L);
                aStack.getItem().onEaten(aStack, this.worldObj, aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean onlyPlaceableWhenSneaking() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.mTank.getFluid();
    }

    public int getCapacity(ItemStack aStack) {
        return this.mTank.getCapacity();
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        if (!this.isFluidAllowed(aFluid) || aStack.stackSize != 1) {
            return 0;
        }
        int tFilled = this.mTank.fill(aFluid, aDoFill);
        if (tFilled > 0 && aDoFill) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return tFilled;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        if (aStack.stackSize != 1) {
            return CS.NF;
        }
        FluidStack tDrained = this.mTank.drain(aMaxDrain, aDoDrain);
        if (tDrained != CS.NF && aDoDrain) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        }
        return tDrained;
    }

    @Override
    public boolean onItemUseFirst(MultiTileEntityItemInternal aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        FluidStack mFluid;
        if (aWorld.isRemote || aPlayer == null || !aPlayer.canPlayerEdit(aX, aY, aZ, (int)aSide, aStack) || aStack.stackSize != 1) {
            return false;
        }
        if (this.canWaterCrops() && FL.water(mFluid = aItem.getFluid(aStack))) {
            Block aBlock = aWorld.getBlock(aX, aY, aZ);
            int aMeta = aWorld.getBlockMetadata(aX, aY, aZ);
            if (aBlock instanceof BlockCauldron) {
                if (aMeta >= 3 || mFluid.amount < 334) {
                    return false;
                }
                if (mFluid.amount >= 1000 && aMeta <= 0) {
                    aItem.drain(aStack, 1000, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 3), 3L);
                } else if (mFluid.amount >= 667 && aMeta <= 1) {
                    aItem.drain(aStack, 667, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 2), 3L);
                } else if (aMeta <= 2) {
                    aItem.drain(aStack, 334, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 1), 3L);
                }
                UT.Sounds.send("liquid.water", this.worldObj, this.getCoords());
                return true;
            }
            if (IL.GrC_Paddy.exists() && mFluid.amount >= 10) {
                if (IL.GrC_Paddy.block() == aBlock) {
                    int tIncrement = Math.min(7 - aMeta, mFluid.amount / 10);
                    if (tIncrement > 0) {
                        aItem.drain(aStack, tIncrement * 10, true);
                        aWorld.setBlockMetadataWithNotify(aX, aY, aZ, aMeta + tIncrement, 3);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
                if (IL.GrC_Paddy.block() == aWorld.getBlock(aX, aY - 1, aZ)) {
                    int tMeta = aWorld.getBlockMetadata(aX, aY - 1, aZ);
                    int tIncrement = Math.min(7 - tMeta, mFluid.amount / 10);
                    if (tIncrement > 0) {
                        aItem.drain(aStack, tIncrement * 10, true);
                        aWorld.setBlockMetadataWithNotify(aX, aY - 1, aZ, tMeta + tIncrement, 3);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY - 1, aZ);
                    }
                    return true;
                }
            }
            TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, false);
            try {
                if (tTileEntity instanceof ICropTile) {
                    int tHydration = ((ICropTile)tTileEntity).getHydrationStorage();
                    int tDrained = Math.min((200 - tHydration) / 10, mFluid.amount);
                    if (tDrained > 0) {
                        aItem.drain(aStack, tDrained, true);
                        ((ICropTile)tTileEntity).setHydrationStorage(tHydration + tDrained * 10);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (tTileEntity instanceof TileCrucible) {
                    if (FL.water(mFluid) && FL.nonzero(aItem.drain(aStack, (int)FL.fill((IFluidHandler)tTileEntity, (byte)1, FL.Water.make(mFluid.amount), true), true))) {
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public ItemStack onItemRightClick(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MovingObjectPosition tTarget;
        if (this.canPickUpFluids() && aStack.stackSize == 1 && (tTarget = WD.getMOP(aWorld, aPlayer, true)) != null && tTarget.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && aWorld.canMineBlock(aPlayer, tTarget.blockX, tTarget.blockY, tTarget.blockZ)) {
            Block tBlock = aWorld.getBlock(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
            if (tBlock == Blocks.water || tBlock == Blocks.flowing_water) {
                if (aWorld.getBlockMetadata(tTarget.blockX, tTarget.blockY, tTarget.blockZ) == 0) {
                    if (WD.infiniteWater(aWorld, tTarget.blockX, tTarget.blockY, tTarget.blockZ)) {
                        aItem.fill(aStack, FL.Water.make(1000L), true);
                    } else if (aItem.fill(aStack, FL.Water.make(1000L), false) == 1000) {
                        aWorld.setBlockToAir(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
                        aItem.fill(aStack, FL.Water.make(1000L), true);
                    }
                }
                return aStack;
            }
            if (tBlock == Blocks.lava || tBlock == Blocks.flowing_lava) {
                if (aWorld.getBlockMetadata(tTarget.blockX, tTarget.blockY, tTarget.blockZ) == 0 && aItem.fill(aStack, FL.Lava.make(1000L), false) == 1000) {
                    aWorld.setBlockToAir(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
                    aItem.fill(aStack, FL.Lava.make(1000L), true);
                }
                return aStack;
            }
            if (tBlock == CS.BlocksGT.River || WD.waterstream(tBlock)) {
                aItem.fill(aStack, FL.Water.make(1000L), true);
                return aStack;
            }
            if (tBlock == CS.BlocksGT.Ocean) {
                aItem.fill(aStack, FL.Ocean.make(1000L), true);
                return aStack;
            }
            if (tBlock == CS.BlocksGT.Swamp) {
                aItem.fill(aStack, FL.Dirty_Water.make(1000L), true);
                return aStack;
            }
            if (tBlock instanceof IFluidBlock) {
                FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tTarget.blockX, tTarget.blockY, tTarget.blockZ, false);
                if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                    aItem.fill(aStack, tDrained, true);
                    ((IFluidBlock)tBlock).drain(aWorld, tTarget.blockX, tTarget.blockY, tTarget.blockZ, true);
                }
                return aStack;
            }
            tTarget.blockX += CS.OFFX[tTarget.sideHit];
            tTarget.blockY += CS.OFFY[tTarget.sideHit];
            tTarget.blockZ += CS.OFFZ[tTarget.sideHit];
            tBlock = aWorld.getBlock(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
            if (tBlock instanceof IFluidBlock) {
                FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tTarget.blockX, tTarget.blockY, tTarget.blockZ, false);
                if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                    aItem.fill(aStack, tDrained, true);
                    ((IFluidBlock)tBlock).drain(aWorld, tTarget.blockX, tTarget.blockY, tTarget.blockZ, true);
                }
                return aStack;
            }
        }
        if (this.isDrinkable() && aStack.stackSize == 1 && (UT.Entities.isCreative(aPlayer) || aPlayer.getFoodStats().needFood() || FoodStatFluid.INSTANCE.alwaysEdible(aStack.getItem(), aStack, aPlayer))) {
            aPlayer.setItemInUse(aStack, Math.max(FoodStatFluid.INSTANCE.getFoodLevel(aStack.getItem(), aStack, null) * 8, 32));
            return aStack;
        }
        return aStack;
    }

    public int getMaxItemUseDuration(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return this.isDrinkable() && aStack.stackSize == 1 ? Math.max(FoodStatFluid.INSTANCE.getFoodLevel(aStack.getItem(), aStack, null) * 8, 32) : 0;
    }

    public EnumAction getItemUseAction(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return this.isDrinkable() && aStack.stackSize == 1 ? FoodStatFluid.INSTANCE.getFoodAction(aStack.getItem(), aStack) : EnumAction.none;
    }

    public ItemStack onEaten(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (!this.isDrinkable() || aStack.stackSize != 1) {
            return aStack;
        }
        int tFoodLevel = FoodStatFluid.INSTANCE.getFoodLevel(aStack.getItem(), aStack, aPlayer);
        if (tFoodLevel > 0) {
            if (FoodStatFluid.INSTANCE.useAppleCoreFunctionality(aStack.getItem(), aStack, aPlayer)) {
                aPlayer.getFoodStats().func_151686_a((ItemFood)UT.Reflection.callConstructor("squeek.applecore.api.food.ItemFoodProxy", 0, null, true, aStack.getItem()), aStack);
            } else {
                aPlayer.getFoodStats().addStats(tFoodLevel, FoodStatFluid.INSTANCE.getSaturation(aStack.getItem(), aStack, aPlayer));
            }
        }
        if (!aWorld.isRemote && MD.ENVM.mLoaded) {
            try {
                float tTemperature = FoodStatFluid.INSTANCE.getTemperature(aStack.getItem(), aStack, aPlayer) - 273.0f;
                float tHydration = FoodStatFluid.INSTANCE.getHydration(aStack.getItem(), aStack, aPlayer);
                EnviroDataTracker tTracker = EM_StatusManager.lookupTracker((EntityLivingBase)aPlayer);
                if (tTracker != null && tTracker.bodyTemp >= 0.0f) {
                    tTracker.bodyTemp += (tTemperature - tTracker.bodyTemp) * FoodStatFluid.INSTANCE.getTemperatureEffect(aStack.getItem(), aStack, aPlayer);
                    if (tHydration > 0.0f) {
                        tTracker.hydrate(tHydration);
                    } else if (tHydration < 0.0f) {
                        tTracker.dehydrate(-tHydration);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        FoodStatFluid.INSTANCE.onEaten(aStack.getItem(), aStack, aPlayer, false, true);
        this.mTank.remove(250L);
        UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        return aStack;
    }

    public FoodValues getFoodValues(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        int tFoodLevel = FoodStatFluid.INSTANCE.getFoodLevel(aStack.getItem(), aStack, null);
        return tFoodLevel > 0 && this.isDrinkable() ? new FoodValues(tFoodLevel, FoodStatFluid.INSTANCE.getSaturation(aStack.getItem(), aStack, null)) : null;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        if (aFluid == CS.NF || !this.isFluidAllowed(aFluid) || this.mTank.isEmpty() && aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
            return 0;
        }
        return this.mTank.fill(aFluid, true);
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (this.mTank.contains(aFluid) && this.mTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) {
            return (int)this.mTank.remove(aFluid.amount);
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        return this.mTank.contains(aFluid) ? this.mTank.amount() : 0L;
    }

    public int tapFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return CS.SIDES_TOP[aSide] && this.isFluidAllowed(aFluid) ? this.mTank.fill(aFluid, aDoFill) : 0;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return CS.SIDES_TOP[aSide] && this.isFluidAllowed(aFluid) ? this.mTank.fill(aFluid, aDoFill) : 0;
    }

    public boolean isDrinkable() {
        return this instanceof IMultiTileEntity.IMTE_GetFoodValues && this.mTank.has(250L) && CS.DrinksGT.REGISTER.containsKey(this.mTank.name());
    }

    public boolean isFluidAllowed(FluidStack aFluid) {
        return !(aFluid == null || FL.powerconducting(aFluid) || !(FL.gas(aFluid) ? this.mGasProof : this.mLiquidProof) || !this.mAcidProof && FL.acid(aFluid) || !this.mPlasmaProof && FL.plasma(aFluid) || !this.mMagicProof && FL.magic(aFluid) || FL.temperature(aFluid) > this.mTemperatureMax);
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return this.mTank.has() ? (byte)1 : aDefault;
    }

    public boolean canWaterCrops() {
        return false;
    }

    public boolean canPickUpFluids() {
        return false;
    }

    public boolean canFillWithRain() {
        return false;
    }

    public boolean canDrinkFromSide(byte aSide) {
        return false;
    }
}

