/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.tools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommon;
import gregapi.gui.ContainerCommonDefault;
import gregapi.gui.Slot_Base;
import gregapi.gui.Slot_Holo;
import gregapi.gui.Slot_Normal;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityAdvancedCraftingTable
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityFunnelAccessible {
    public boolean mSyncGUI = false;
    public boolean mFlushMode = false;
    public boolean mBlocked16 = false;
    public boolean mBlocked36 = false;
    public boolean mFilter16 = false;
    public boolean mFilter36 = false;
    public boolean mDoSound = true;
    public boolean mUpdatedGrid = true;
    public String mGUITexture = CS.RES_PATH_GUI + "machines/AdvancedCraftingTable.png";
    public static final int[] SLOTS = new int[]{33};
    public static final int[] SLOTS_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    public static final int[] SLOTS_16 = new int[]{33, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final int[] SLOTS_16_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final int[] SLOTS_36 = new int[]{33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 63, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_36_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_ALL = new int[]{33, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 63, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_ALL_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_CONSUMPTION = new int[]{70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    public static final int[] SLOTS_INPUT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_STORAGE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    public static final int[] SLOTS_CRAFTING = new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29};
    public static final int[] SLOTS_TOOLS = new int[]{16, 17, 18, 19, 20};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/top"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/front"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/back"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mode.16.blocked")) {
            this.mBlocked16 = aNBT.getBoolean("gt.mode.16.blocked");
        }
        if (aNBT.hasKey("gt.mode.36.blocked")) {
            this.mBlocked36 = aNBT.getBoolean("gt.mode.36.blocked");
        }
        if (aNBT.hasKey("gt.mode.16.filter")) {
            this.mFilter16 = aNBT.getBoolean("gt.mode.16.filter");
        }
        if (aNBT.hasKey("gt.mode.36.filter")) {
            this.mFilter36 = aNBT.getBoolean("gt.mode.36.filter");
        }
        if (aNBT.hasKey("gt.flush")) {
            this.mFlushMode = aNBT.getBoolean("gt.flush");
        }
        if (CS.CODE_CLIENT && aNBT.hasKey("gt.gui")) {
            this.mGUITexture = aNBT.getString("gt.gui");
            if (!this.mGUITexture.endsWith(".png")) {
                this.mGUITexture = this.mGUITexture + ".png";
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.mode.16.blocked", this.mBlocked16);
        UT.NBT.setBoolean(aNBT, "gt.mode.36.blocked", this.mBlocked36);
        UT.NBT.setBoolean(aNBT, "gt.mode.16.filter", this.mFilter16);
        UT.NBT.setBoolean(aNBT, "gt.mode.36.filter", this.mFilter36);
        UT.NBT.setBoolean(aNBT, "gt.flush", this.mFlushMode);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.inputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mUpdatedGrid = true;
        if (aPlayer != null) {
            aPlayer.triggerAchievement((StatBase)AchievementList.openInventory);
            aPlayer.triggerAchievement((StatBase)AchievementList.mineWood);
            aPlayer.triggerAchievement((StatBase)AchievementList.buildWorkBench);
        }
        if (CS.SIDES_TOP[aSide]) {
            return !this.isServerSide() || this.openGUI(aPlayer, 0);
        }
        if (CS.ALONG_AXIS[aSide][this.mFacing]) {
            return !this.isServerSide() || this.openGUI(aPlayer, 1);
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mUpdatedGrid = true;
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("monkeywrench")) {
            if (CS.SIDES_TOP[aSide]) {
                boolean bl = this.mBlocked16 = !this.mBlocked16;
                if (aChatReturn != null) {
                    aChatReturn.add("4x4-Automation-Access: " + (this.mBlocked16 ? "OFF" : "ON"));
                }
            } else {
                boolean bl = this.mBlocked36 = !this.mBlocked36;
                if (aChatReturn != null) {
                    aChatReturn.add("9x4-Automation-Access: " + (this.mBlocked36 ? "OFF" : "ON"));
                }
            }
            return 10000L;
        }
        if (aTool.equals("screwdriver")) {
            if (CS.SIDES_TOP[aSide]) {
                boolean bl = this.mFilter16 = !this.mFilter16;
                if (aChatReturn != null) {
                    aChatReturn.add("4x4-Diversity-Filter: " + (this.mFilter16 ? "ON" : "OFF"));
                }
            } else {
                boolean bl = this.mFilter36 = !this.mFilter36;
                if (aChatReturn != null) {
                    aChatReturn.add("9x4-Diversity-Filter: " + (this.mFilter36 ? "ON" : "OFF"));
                }
            }
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        this.mDoSound = true;
        if (aIsServerSide) {
            if (this.mUpdatedGrid) {
                this.getCraftingOutput(false);
                this.mUpdatedGrid = false;
            }
            if (this.mInventoryChanged) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                }
            }
            this.refill();
            if (this.mFlushMode) {
                this.mFlushMode = false;
                for (int i : SLOTS_CRAFTING) {
                    if (!this.slotHas(i) || this.slotNull(i)) continue;
                    this.mFlushMode = true;
                    break;
                }
            }
        }
    }

    public void sortIntoTheInputSlots() {
        for (int i : SLOTS_CRAFTING) {
            if (!this.slotHas(i)) continue;
            this.slotNull(i);
            if (this.slotHas(i)) {
                for (int j : SLOTS_STORAGE) {
                    if (!ST.equal(this.slot(i), this.slot(j))) continue;
                    ST.move(this, i, j);
                }
            }
            if (!this.slotHas(i)) continue;
            for (int j : SLOTS_STORAGE) {
                if (this.slotHas(j)) continue;
                ST.move(this, i, j);
            }
        }
        this.mUpdatedGrid = true;
    }

    protected void refill() {
    }

    public boolean setBluePrint(ItemStack aStack) {
        if (aStack == null) {
            aStack = this.slot(30);
        }
        if (!IL.Paper_Blueprint_Empty.equal(aStack, false, true)) {
            return false;
        }
        ItemStack[] itemStackArray = new ItemStack[9];
        ItemStack itemStack = this.slotHas(21) ? (this.slot(21).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(21), (NBTTagCompound)null) : this.slot(21)) : (itemStackArray[0] = null);
        ItemStack itemStack2 = this.slotHas(22) ? (this.slot(22).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(22), (NBTTagCompound)null) : this.slot(22)) : (itemStackArray[1] = null);
        ItemStack itemStack3 = this.slotHas(23) ? (this.slot(23).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(23), (NBTTagCompound)null) : this.slot(23)) : (itemStackArray[2] = null);
        ItemStack itemStack4 = this.slotHas(24) ? (this.slot(24).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(24), (NBTTagCompound)null) : this.slot(24)) : (itemStackArray[3] = null);
        ItemStack itemStack5 = this.slotHas(25) ? (this.slot(25).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(25), (NBTTagCompound)null) : this.slot(25)) : (itemStackArray[4] = null);
        ItemStack itemStack6 = this.slotHas(26) ? (this.slot(26).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(26), (NBTTagCompound)null) : this.slot(26)) : (itemStackArray[5] = null);
        ItemStack itemStack7 = this.slotHas(27) ? (this.slot(27).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(27), (NBTTagCompound)null) : this.slot(27)) : (itemStackArray[6] = null);
        ItemStack itemStack8 = this.slotHas(28) ? (this.slot(28).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(28), (NBTTagCompound)null) : this.slot(28)) : (itemStackArray[7] = null);
        itemStackArray[8] = this.slotHas(29) ? (this.slot(29).getItem() instanceof IItemGTContainerTool ? ST.make(this.slot(29), (NBTTagCompound)null) : this.slot(29)) : null;
        UT.NBT.setBlueprintCrafting(aStack, itemStackArray);
        if (this.slotHas(31)) {
            aStack.setStackDisplayName(this.slot(31).getDisplayName());
        }
        ST.set(aStack, IL.Paper_Blueprint_Used.get(1L, new Object[0]), false, false);
        return true;
    }

    public ItemStack getCraftingOutput(boolean aAllowCache) {
        if (IL.Paper_Blueprint_Used.equal(this.slot(30), false, true)) {
            ItemStack[] tRecipe = UT.NBT.getBlueprintCrafting(this.slot(30));
            if (tRecipe != CS.ZL_IS) {
                for (int i = 0; i < tRecipe.length; ++i) {
                    if (this.slotHas(i + 21)) continue;
                    this.slot(i + 21, ST.amount(0L, tRecipe[i]));
                }
            }
        } else if (IL.Circuit_Selector.equal(this.slot(30), true, true)) {
            int tDestination = SLOTS_CRAFTING[3];
            for (int i : SLOTS_CRAFTING) {
                this.slotNull(i);
                if (i == SLOTS_CRAFTING[3]) continue;
                if (this.slotHas(i)) {
                    ST.move(this, i, tDestination);
                }
                if (this.slotHas(i)) {
                    for (int j : SLOTS_STORAGE) {
                        if (!ST.equal(this.slot(i), this.slot(j))) continue;
                        ST.move(this, i, j);
                    }
                }
                if (!this.slotHas(i)) continue;
                for (int j : SLOTS_STORAGE) {
                    if (this.slotHas(j)) continue;
                    ST.move(this, i, j);
                }
            }
            switch (ST.meta(this.slot(30))) {
                case 9: {
                    if (!this.slotHas(SLOTS_CRAFTING[8])) {
                        this.slot(SLOTS_CRAFTING[8], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[7])) {
                        this.slot(SLOTS_CRAFTING[7], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[6])) {
                        this.slot(SLOTS_CRAFTING[6], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[2])) {
                        this.slot(SLOTS_CRAFTING[2], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[0])) {
                        this.slot(SLOTS_CRAFTING[0], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 8: {
                    if (!this.slotHas(SLOTS_CRAFTING[8])) {
                        this.slot(SLOTS_CRAFTING[8], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[7])) {
                        this.slot(SLOTS_CRAFTING[7], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[6])) {
                        this.slot(SLOTS_CRAFTING[6], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[2])) {
                        this.slot(SLOTS_CRAFTING[2], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[0])) {
                        this.slot(SLOTS_CRAFTING[0], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 7: {
                    if (!this.slotHas(SLOTS_CRAFTING[7])) {
                        this.slot(SLOTS_CRAFTING[7], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[2])) {
                        this.slot(SLOTS_CRAFTING[2], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[0])) {
                        this.slot(SLOTS_CRAFTING[0], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 6: {
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[2])) {
                        this.slot(SLOTS_CRAFTING[2], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[0])) {
                        this.slot(SLOTS_CRAFTING[0], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 5: {
                    if (!this.slotHas(SLOTS_CRAFTING[7])) {
                        this.slot(SLOTS_CRAFTING[7], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 4: {
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[1])) {
                        this.slot(SLOTS_CRAFTING[1], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[0])) {
                        this.slot(SLOTS_CRAFTING[0], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                case 3: {
                    if (!this.slotHas(SLOTS_CRAFTING[5])) {
                        this.slot(SLOTS_CRAFTING[5], ST.amount(0L, this.slot(tDestination)));
                    }
                    if (!this.slotHas(SLOTS_CRAFTING[4])) {
                        this.slot(SLOTS_CRAFTING[4], ST.amount(0L, this.slot(tDestination)));
                    }
                    break;
                }
                default: {
                    if (this.slotHas(SLOTS_CRAFTING[6])) break;
                    this.slot(SLOTS_CRAFTING[6], ST.amount(0L, this.slot(tDestination)));
                }
            }
        }
        ItemStack rStack = CR.getany(this.worldObj, aAllowCache, this.slot(21), this.slot(22), this.slot(23), this.slot(24), this.slot(25), this.slot(26), this.slot(27), this.slot(28), this.slot(29));
        if (OM.materialcontains(rStack, TD.Properties.EXPLODES_IN_NONVANILLA_CRAFTING_GRID)) {
            this.explode(4.0);
        }
        return this.slot(31, rStack);
    }

    public boolean canDoCraftingOutput() {
        if (!this.slotHas(31)) {
            return false;
        }
        for (ItemStack tStack : this.recipeContent()) {
            if (tStack.stackSize <= this.getAmountOf(tStack)) continue;
            return false;
        }
        return true;
    }

    protected int getAmountOf(ItemStack aStack) {
        int tAmount = 0;
        for (int n : SLOTS_CRAFTING) {
            if (!ST.equalTools(aStack, this.slot(n), false) || (tAmount += this.slot((int)n).stackSize) < SLOTS_CRAFTING.length) continue;
            return tAmount;
        }
        for (int n : SLOTS_CONSUMPTION) {
            if (!ST.equalTools(aStack, this.slot(n), false) || (tAmount += this.slot((int)n).stackSize) < SLOTS_CRAFTING.length) continue;
            return tAmount;
        }
        for (byte by : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(by);
            if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory) || (tAmount = (int)((long)tAmount + ((ITileEntityConnectedInventory)tDelegator.mTileEntity).getAmountOfItemsInConnectedInventory(tDelegator.mSideOfTileEntity, aStack, SLOTS_CRAFTING.length - tAmount))) < SLOTS_CRAFTING.length) continue;
            return tAmount;
        }
        return tAmount;
    }

    protected ArrayList<ItemStack> recipeContent() {
        ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
        for (int i : SLOTS_CRAFTING) {
            if (!this.slotHas(i)) continue;
            boolean temp = false;
            for (int j = 0; j < tList.size(); ++j) {
                if (!ST.equalTools(this.slot(i), tList.get(j), false)) continue;
                ++tList.get((int)j).stackSize;
                temp = true;
                break;
            }
            if (temp) continue;
            tList.add(ST.amount(1L, this.slot(i)));
        }
        return tList;
    }

    public ItemStack consumeMaterials(EntityPlayer aPlayer, ItemStack aHoldStack, boolean aSubsequentClick) {
        if (!this.slotHas(31)) {
            return aHoldStack;
        }
        if (aHoldStack != null) {
            if (!ST.equal(aHoldStack, this.slot(31))) {
                if (!aSubsequentClick && this.mDoSound) {
                    UT.Sounds.play("mob.villager.idle", 50, 1.0f, 1.0f, this.getCoords());
                    this.mDoSound = false;
                }
                return aHoldStack;
            }
            if (aHoldStack.stackSize + this.slot((int)31).stackSize > aHoldStack.getMaxStackSize()) {
                return aHoldStack;
            }
            for (int i : SLOTS_CRAFTING) {
                if (!OM.is("gt:autocrafterinfinite", this.slot(i))) continue;
                if (!aSubsequentClick && this.mDoSound) {
                    UT.Sounds.play("mob.villager.idle", 50, 1.0f, 1.0f, this.getCoords());
                    this.mDoSound = false;
                }
                return aHoldStack;
            }
        }
        MultiItemTool.LAST_TOOL_COORDS_BEFORE_DAMAGE = this.getCoords();
        try {
            FMLCommonHandler.instance().firePlayerCraftingEvent(aPlayer, ST.copy(this.slot(31)), (IInventory)new InventoryCrafting(null, 3, 3));
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        ItemStack[] tRecipeStacks = new ItemStack[]{ST.amount(1L, this.slot(21)), ST.amount(1L, this.slot(22)), ST.amount(1L, this.slot(23)), ST.amount(1L, this.slot(24)), ST.amount(1L, this.slot(25)), ST.amount(1L, this.slot(26)), ST.amount(1L, this.slot(27)), ST.amount(1L, this.slot(28)), ST.amount(1L, this.slot(29))};
        block3: for (int j = 0; j < tRecipeStacks.length; ++j) {
            if (!ST.valid(tRecipeStacks[j])) continue;
            boolean tNeeds = true;
            CS.TOOL_SOUNDS = !aSubsequentClick && this.mDoSound && CS.TOOL_SOUNDS_SETTING;
            ItemStack tContainer = ST.container(tRecipeStacks[j], false);
            CS.TOOL_SOUNDS = false;
            if (ST.equal(tRecipeStacks[j], tContainer, false)) continue;
            if (this.isServerSide()) {
                block4: for (byte tSide : CS.ALL_SIDES_VALID) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory) || ((ITileEntityConnectedInventory)tDelegator.mTileEntity).removeStackFromConnectedInventory(tDelegator.mSideOfTileEntity, ST.amount(1L, tRecipeStacks[j]), true) < 1) continue;
                    tNeeds = false;
                    if (tContainer != null) {
                        for (byte tSide2 : CS.ALL_SIDES_VALID) {
                            tDelegator = this.getAdjacentTileEntity(tSide2);
                            if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory)) continue;
                            int tRemoved = ((ITileEntityConnectedInventory)tDelegator.mTileEntity).addStackToConnectedInventory(tDelegator.mSideOfTileEntity, ST.copy(tContainer), true);
                            tContainer.stackSize -= tRemoved;
                            if (tContainer.stackSize >= 1) continue;
                            tContainer = null;
                            break;
                        }
                    }
                    if (tContainer == null) break;
                    for (int i : SLOTS_INPUT) {
                        if (!this.slotHas(i)) {
                            this.slot(i, tContainer);
                            break block4;
                        }
                        if (!ST.equal(tContainer, this.slot(i)) || tContainer.stackSize + this.slot((int)i).stackSize > this.slot(i).getMaxStackSize()) continue;
                        this.slot((int)i).stackSize += tContainer.stackSize;
                        break block4;
                    }
                    break;
                }
            }
            if (tNeeds && ST.equalTools(tRecipeStacks[j], this.slot(SLOTS_CRAFTING[j]), false) && this.slot((int)MultiTileEntityAdvancedCraftingTable.SLOTS_CRAFTING[j]).stackSize > 1 && this.consumeSlot(SLOTS_CRAFTING[j])) continue;
            if (tNeeds) {
                for (int i : SLOTS_CRAFTING) {
                    if (!ST.equalTools(tRecipeStacks[j], this.slot(i), false) || this.slot((int)i).stackSize <= 1 || !this.consumeSlot(i)) continue;
                    tNeeds = false;
                    break;
                }
            }
            if (tNeeds) {
                for (int i : SLOTS_CONSUMPTION) {
                    if (!ST.equalTools(tRecipeStacks[j], this.slot(i), false) || this.slot((int)i).stackSize <= 0 || !this.consumeSlot(i)) continue;
                    tNeeds = false;
                    break;
                }
            }
            if (!tNeeds) continue;
            for (int i : SLOTS_CRAFTING) {
                if (!ST.equalTools(tRecipeStacks[j], this.slot(i), false) || this.slot((int)i).stackSize <= 0 || !this.consumeSlot(i)) continue;
                tNeeds = false;
                this.mUpdatedGrid = true;
                continue block3;
            }
        }
        if (aHoldStack == null) {
            aHoldStack = ST.copy(this.slot(31));
        } else {
            aHoldStack.stackSize += this.slot((int)31).stackSize;
        }
        aHoldStack.onCrafting(this.worldObj, aPlayer, this.slot((int)31).stackSize);
        ST.check((Entity)aPlayer, aHoldStack);
        this.refill();
        MultiItemTool.LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
        CS.TOOL_SOUNDS = CS.TOOL_SOUNDS_SETTING;
        this.updateInventory();
        this.mSyncGUI = true;
        return aHoldStack;
    }

    public boolean consumeSlot(int aSlot) {
        ItemStack tContainer = ST.container(this.slot(aSlot), false);
        if (tContainer != null && tContainer.stackSize < 1) {
            tContainer = null;
        }
        if (this.isServerSide() && tContainer != null) {
            DelegatorTileEntity<TileEntity> tDelegator;
            FluidStack tFluidContained = FL.getFluid(this.slot(aSlot), true);
            if (tFluidContained != null && ST.equal(this.slot(aSlot), FL.fill(tFluidContained, tContainer, false, true, false, true), false)) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedTank) || ((ITileEntityConnectedTank)tDelegator.mTileEntity).removeFluidFromConnectedTank(tDelegator.mSideOfTileEntity, tFluidContained, true) < tFluidContained.amount) continue;
                    return true;
                }
            }
            byte[] byArray = CS.ALL_SIDES_VALID;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte tSide;
                tSide = byArray[i];
                tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory)) continue;
                tContainer.stackSize -= ((ITileEntityConnectedInventory)tDelegator.mTileEntity).addStackToConnectedInventory(tDelegator.mSideOfTileEntity, ST.copy(tContainer), true);
                if (tContainer.stackSize >= 1) continue;
                tContainer = null;
                break;
            }
        }
        if (tContainer == null || tContainer.isItemStackDamageable() && tContainer.getItemDamage() >= tContainer.getMaxDamage()) {
            this.decrStackSize(aSlot, 1);
            return true;
        }
        if (this.slot((int)aSlot).stackSize == 1) {
            this.slot(aSlot, tContainer);
            return true;
        }
        this.decrStackSize(aSlot, 1);
        for (int i : SLOTS_INPUT) {
            if (!this.slotHas(i)) {
                this.slot(i, tContainer);
                return true;
            }
            if (!ST.equal(tContainer, this.slot(i)) || tContainer.stackSize + this.slot((int)i).stackSize > this.slot(i).getMaxStackSize()) continue;
            this.slot((int)i).stackSize += tContainer.stackSize;
            return true;
        }
        return true;
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        if (aSlot > 20 && aSlot <= 30 && !ST.equal(aStack, this.slot(aSlot), false)) {
            this.mUpdatedGrid = true;
        }
        super.setInventorySlotContents(aSlot, aStack);
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        if (aSlot > 20 && aSlot <= 30 && !ST.equal(aStack, this.slot(aSlot), false)) {
            this.mUpdatedGrid = true;
        }
        super.setInventorySlotContentsGUI(aSlot, aStack);
    }

    @Override
    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        if (aSlot > 20 && aSlot <= 30 && aDecrement > 0) {
            this.mUpdatedGrid = true;
        }
        return super.decrStackSize(aSlot, aDecrement);
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        if (aSlot > 20 && aSlot <= 30 && aDecrement > 0) {
            this.mUpdatedGrid = true;
        }
        return super.decrStackSizeGUI(aSlot, aDecrement);
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return this.mBlocked16 ? (this.mBlocked36 ? (this.mFlushMode ? SLOTS_FLUSHING : SLOTS) : (this.mFlushMode ? SLOTS_36_FLUSHING : SLOTS_36)) : (this.mBlocked36 ? (this.mFlushMode ? SLOTS_16_FLUSHING : SLOTS_16) : (this.mFlushMode ? SLOTS_ALL_FLUSHING : SLOTS_ALL));
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return aInventorySlot < 31 || aInventorySlot > 32;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[71];
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return aSlot == 30 ? 1 : 64;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] && !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isItemValidForSlotGUI(int aSlot, ItemStack aStack) {
        return aSlot != 30 || ST.invalid(aStack) || IL.Paper_Blueprint_Empty.equal(aStack, false, true) || IL.Paper_Blueprint_Used.equal(aStack, false, true) || IL.Circuit_Selector.equal(aStack, true, true) && UT.Code.inside(2L, 9L, ST.meta(aStack));
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot < 16) {
            if (this.mFilter16) {
                for (int i = 0; i < 16; ++i) {
                    if (!ST.equalTools(aStack, this.slot(i), false)) continue;
                    return aSlot == i;
                }
            }
            return true;
        }
        if (aSlot >= 35 && aSlot < 71) {
            if (this.mFilter36) {
                for (int i = 35; i < 71; ++i) {
                    if (!ST.equalTools(aStack, this.slot(i), false)) continue;
                    return aSlot == i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 33 || this.mFlushMode && aSlot > 20 && aSlot < 30;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        return aFluid != null && this.fill(aDirection, FL.make(aFluid, Integer.MAX_VALUE), false) > 0;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        for (int i : SLOTS_TOOLS) {
            FluidStack tFluid;
            ItemStack tOutput = FL.fill(aFluid, this.slot(i), false, true, false, true);
            if (tOutput == null || (tFluid = FL.getFluid(tOutput, true)) == null) continue;
            if (this.slot((int)i).stackSize == 1) {
                if (aDoFill) {
                    this.slot(i, tOutput);
                    this.updateInventory();
                    this.mSyncGUI = true;
                }
                return tFluid.amount * tOutput.stackSize;
            }
            for (int j : SLOTS_TOOLS) {
                if (this.slotHas(j) && (!ST.equal(tOutput, this.slot(j)) || this.slot((int)j).stackSize + tOutput.stackSize > tOutput.getMaxStackSize())) continue;
                if (aDoFill) {
                    this.decrStackSize(i, 1);
                    if (this.slotHas(j)) {
                        ++this.slot((int)j).stackSize;
                    } else {
                        this.slot(j, tOutput);
                    }
                    this.updateInventory();
                    this.mSyncGUI = true;
                }
                return tFluid.amount * tOutput.stackSize;
            }
        }
        return 0;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return this.fill(CS.FORGE_DIR[aSide], aFluid, aDoFill);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        return CS.L1_FLUIDTANKINFO_DUMMY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new ContainerClientDefault(new ContainerCommonDefault(aPlayer.inventory, this, aGUIID, 35, 36)) : new MultiTileEntityGUIClientAdvancedCraftingTable(aPlayer.inventory, this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new ContainerCommonDefault(aPlayer.inventory, this, aGUIID, 35, 36) : new MultiTileEntityGUICommonAdvancedCraftingTable(aPlayer.inventory, this, aGUIID);
    }

    @Override
    public boolean needsToSyncEverything() {
        if (this.mSyncGUI) {
            this.mSyncGUI = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean interceptClick(int aGUIID, Slot_Base aSlot, int aSlotIndex, int aInvSlot, EntityPlayer aPlayer, boolean aShiftclick, boolean aRightclick, int aMouse, int aShift) {
        if (aGUIID != 0) {
            return false;
        }
        this.slotNull(aInvSlot);
        if (aInvSlot == 30 && !aRightclick && aShiftclick && this.setBluePrint(null)) {
            return true;
        }
        return aInvSlot == 31 || aInvSlot == 32;
    }

    @Override
    public ItemStack slotClick(int aGUIID, Slot_Base aSlot, int aSlotIndex, int aInvSlot, EntityPlayer aPlayer, boolean aShiftclick, boolean aRightclick, int aMouse, int aShift) {
        if (aInvSlot == 31) {
            ItemStack tCraftedStack = this.getCraftingOutput(true);
            if (tCraftedStack != null) {
                if (aShiftclick) {
                    if (aRightclick) {
                        for (int i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
                            if (aPlayer.inventory.mainInventory[i] != null && (!ST.equal(tCraftedStack, aPlayer.inventory.mainInventory[i]) || tCraftedStack.stackSize + aPlayer.inventory.mainInventory[i].stackSize > aPlayer.inventory.mainInventory[i].getMaxStackSize())) continue;
                            for (int j = 0; j < tCraftedStack.getMaxStackSize() / tCraftedStack.stackSize && this.canDoCraftingOutput(); ++j) {
                                ItemStack tStack = this.getCraftingOutput(true);
                                if (!ST.equal(tStack, tCraftedStack) || tStack.stackSize != tCraftedStack.stackSize) {
                                    return aPlayer.inventory.getItemStack();
                                }
                                aPlayer.inventory.mainInventory[i] = this.consumeMaterials(aPlayer, aPlayer.inventory.mainInventory[i], i != 0 || j != 0);
                            }
                        }
                        return aPlayer.inventory.getItemStack();
                    }
                    for (int i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
                        if (aPlayer.inventory.mainInventory[i] != null && (!ST.equal(tCraftedStack, aPlayer.inventory.mainInventory[i]) || tCraftedStack.stackSize + aPlayer.inventory.mainInventory[i].stackSize > aPlayer.inventory.mainInventory[i].getMaxStackSize())) continue;
                        boolean temp = false;
                        for (int j = 0; j < tCraftedStack.getMaxStackSize() / tCraftedStack.stackSize && this.canDoCraftingOutput(); ++j) {
                            ItemStack tStack = this.getCraftingOutput(true);
                            if (!ST.equal(tStack, tCraftedStack) || tStack.stackSize != tCraftedStack.stackSize) {
                                return aPlayer.inventory.getItemStack();
                            }
                            aPlayer.inventory.mainInventory[i] = this.consumeMaterials(aPlayer, aPlayer.inventory.mainInventory[i], i != 0 || j != 0);
                            temp = true;
                        }
                        if (!temp) continue;
                        return aPlayer.inventory.getItemStack();
                    }
                    return aPlayer.inventory.getItemStack();
                }
                if (aRightclick) {
                    for (int i = 0; i < tCraftedStack.getMaxStackSize() / tCraftedStack.stackSize && this.canDoCraftingOutput(); ++i) {
                        ItemStack tStack = this.getCraftingOutput(true);
                        if (!ST.equal(tStack, tCraftedStack) || tStack.stackSize != tCraftedStack.stackSize) {
                            return aPlayer.inventory.getItemStack();
                        }
                        aPlayer.inventory.setItemStack(this.consumeMaterials(aPlayer, aPlayer.inventory.getItemStack(), i != 0));
                    }
                    return aPlayer.inventory.getItemStack();
                }
                if (this.canDoCraftingOutput()) {
                    aPlayer.inventory.setItemStack(this.consumeMaterials(aPlayer, aPlayer.inventory.getItemStack(), false));
                }
                return aPlayer.inventory.getItemStack();
            }
            return null;
        }
        if (aInvSlot == 32) {
            if (aSlotIndex == 34) {
                this.mFlushMode = true;
            }
            if (aSlotIndex == 35) {
                this.sortIntoTheInputSlots();
            }
            return null;
        }
        return null;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        byte aIndex = aSide < 2 ? aSide : (aSide == this.mFacing ? (byte)2 : (aSide == CS.OPOS[this.mFacing] ? (byte)3 : 4));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.crafting.advanced";
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientAdvancedCraftingTable
    extends ContainerClient {
        public MultiTileEntityGUIClientAdvancedCraftingTable(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity, int aGUIID) {
            super(new MultiTileEntityGUICommonAdvancedCraftingTable(aInventoryPlayer, aTileEntity, aGUIID), aTileEntity.mGUITexture);
        }
    }

    public class MultiTileEntityGUICommonAdvancedCraftingTable
    extends ContainerCommon {
        public MultiTileEntityGUICommonAdvancedCraftingTable(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity, int aGUIID) {
            super(aInventoryPlayer, aTileEntity, aGUIID);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 30, 135, 28).setTooltip("gt.advcrafting.insert.blueprint", LH.Chat.WHITE));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 0, 7, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 1, 25, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 2, 43, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 3, 61, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 4, 7, 26));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 5, 25, 26));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 6, 43, 26));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 7, 61, 26));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 8, 7, 44));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 9, 25, 44));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 10, 43, 44));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 11, 61, 44));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 12, 7, 62));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 13, 25, 62));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 14, 43, 62));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 15, 61, 62));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 16, 80, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 17, 98, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 18, 116, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 19, 134, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 20, 152, 8));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 21, 80, 28));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 22, 98, 28));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 23, 116, 28));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 24, 80, 46));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 25, 98, 46));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 26, 116, 46));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 27, 80, 64));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 28, 98, 64));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 29, 116, 64));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 33, 153, 28).setTooltip("gt.advcrafting.drop.slot", LH.Chat.WHITE));
            this.addSlotToContainer(new Slot_Normal(this.mTileEntity, 34, 153, 64).setTooltip("gt.advcrafting.neutral.slot", LH.Chat.WHITE));
            this.addSlotToContainer(new Slot_Holo(this.mTileEntity, 31, 135, 64, false, false, 1));
            this.addSlotToContainer(new Slot_Holo(this.mTileEntity, 32, 153, 46, false, false, 1).setTooltip("gt.advcrafting.automation.access", LH.Chat.WHITE));
            this.addSlotToContainer(new Slot_Holo(this.mTileEntity, 32, 135, 46, false, false, 1).setTooltip("gt.advcrafting.put.to.storage", LH.Chat.WHITE));
            return super.addSlots(aInventoryPlayer);
        }

        @Override
        public int getSlotCount() {
            return 33;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 22;
        }
    }
}

