/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.config.Config;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldgenOresLarge
extends WorldgenObject {
    public static ArrayList<WorldgenOresLarge> sList = new ArrayListNoNulls<WorldgenOresLarge>();
    public final int mWeight;
    public final int mDistance;
    public final short mMinY;
    public final short mMaxY;
    public final short mDensity;
    public final short mSize;
    public final OreDictMaterial mTop;
    public final OreDictMaterial mBottom;
    public final OreDictMaterial mBetween;
    public final OreDictMaterial mSpread;
    public final boolean mIndicatorRocks;

    @SafeVarargs
    public WorldgenOresLarge(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, OreDictMaterial aTop, OreDictMaterial aBottom, OreDictMaterial aBetween, OreDictMaterial aSpread, List<WorldgenObject> ... aLists) {
        this(aName, aDefault, true, aMinY, aMaxY, aWeight, aDensity, aSize, aTop, aBottom, aBetween, aSpread, aLists);
    }

    @SafeVarargs
    public WorldgenOresLarge(String aName, boolean aDefault, boolean aIndicatorRocks, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, OreDictMaterial aTop, OreDictMaterial aBottom, OreDictMaterial aBetween, OreDictMaterial aSpread, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mMinY = (short)Math.max(0, this.getConfigFile().get((Object)this.mCategory, "MinHeight", (long)aMinY));
        this.mMaxY = (short)Math.max(this.mMinY + 5, this.getConfigFile().get((Object)this.mCategory, "MaxHeight", (long)aMaxY));
        this.mWeight = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "RandomWeight", (long)aWeight));
        this.mDensity = (short)Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Density", (long)aDensity));
        this.mDistance = Math.max(0, this.getConfigFile().get((Object)this.mCategory, "DistanceFromSpawn", 0L));
        this.mSize = (short)Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Size", (long)aSize));
        this.mIndicatorRocks = this.getConfigFile().get((Object)this.mCategory, "IndicatorRocks", aIndicatorRocks);
        this.mTop = this.getConfigFile().get((Object)this.mCategory, "OreTop", aTop);
        this.mBottom = this.getConfigFile().get((Object)this.mCategory, "OreBottom", aBottom);
        this.mBetween = this.getConfigFile().get((Object)this.mCategory, "OreBetween", aBetween);
        this.mSpread = this.getConfigFile().get((Object)this.mCategory, "OreSpread", aSpread);
        if (this.mEnabled) {
            if (this.mTop.mID > 0) {
                OreDictManager.INSTANCE.triggerVisibility("ore" + this.mTop.mNameInternal);
            }
            if (this.mBottom.mID > 0) {
                OreDictManager.INSTANCE.triggerVisibility("ore" + this.mBottom.mNameInternal);
            }
            if (this.mBetween.mID > 0) {
                OreDictManager.INSTANCE.triggerVisibility("ore" + this.mBetween.mNameInternal);
            }
            if (this.mSpread.mID > 0) {
                OreDictManager.INSTANCE.triggerVisibility("ore" + this.mSpread.mNameInternal);
            }
        }
        if (this.mTop.mID <= 0) {
            CS.ERR.println("The OreTop Material is not valid for Ores: " + this.mTop);
        }
        if (this.mBottom.mID <= 0) {
            CS.ERR.println("The OreBottom Material is not valid for Ores: " + this.mBottom);
        }
        if (this.mBetween.mID <= 0) {
            CS.ERR.println("The OreBetween Material is not valid for Ores: " + this.mBetween);
        }
        if (this.mSpread.mID <= 0) {
            CS.ERR.println("The OreSpread Material is not valid for Ores: " + this.mSpread);
        }
        if (this.mTop.mID <= 0 && this.mBottom.mID <= 0 && this.mBetween.mID <= 0 && this.mSpread.mID <= 0) {
            this.mInvalid = true;
        }
    }

    public boolean generate(World aWorld, Chunk aChunk, int aMinX, int aMinZ, int aMaxX, int aMaxZ, int aOriginChunkX, int aOriginChunkZ, Random aRandom) {
        MultiTileEntityRegistry tRegistry;
        if (CS.GENERATING_SPECIAL) {
            return false;
        }
        if (this.mDistance > 0 && Math.abs(aMinX) <= this.mDistance && Math.abs(aMinZ) <= this.mDistance) {
            return false;
        }
        int tMinY = this.mMinY + WD.random(aWorld, (long)aOriginChunkX, (long)aOriginChunkZ).nextInt(this.mMaxY - this.mMinY - 5);
        if (this.mIndicatorRocks && (!CS.GENERATE_STREETS || aWorld.provider.dimensionId != 0 || Math.abs(aMinX) >= 64 && Math.abs(aMaxX) >= 64 && Math.abs(aMinZ) >= 64 && Math.abs(aMaxZ) >= 64) && (tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity")) != null) {
            int j = 1 + aRandom.nextInt(3);
            block0: for (int i = 0; i < j; ++i) {
                Block tContact;
                int tX = aMinX + aRandom.nextInt(16);
                int tZ = aMinZ + aRandom.nextInt(16);
                for (int tY = Math.min(aWorld.getHeight(), tMinY + 25); tY >= tMinY - 10 && tY > 0 && !(tContact = aChunk.getBlock(tX & 0xF, tY, tZ & 0xF)).getMaterial().isLiquid(); --tY) {
                    if (!tContact.isOpaqueCube()) continue;
                    if (tContact.getMaterial() != Material.grass && tContact.getMaterial() != Material.ground && tContact.getMaterial() != Material.sand && tContact.getMaterial() != Material.rock || !WD.easyRep(aWorld, tX, tY + 1, tZ)) continue block0;
                    tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, aRandom.nextInt(3) != 0 ? ST.save("gt.value", OP.rockGt.mat(UT.Code.select(this.mTop, this.mTop, this.mBottom, this.mBetween, this.mSpread), 1L)) : UT.NBT.make(), false, true);
                    continue block0;
                }
            }
        }
        int cX = aOriginChunkX - aRandom.nextInt(this.mSize);
        int eX = aOriginChunkX + 16 + aRandom.nextInt(this.mSize);
        for (int tX = Math.max(aMinX, cX); tX <= Math.min(aMaxX, eX); ++tX) {
            int cZ = aOriginChunkZ - aRandom.nextInt(this.mSize);
            int eZ = aOriginChunkZ + 16 + aRandom.nextInt(this.mSize);
            for (int tZ = Math.max(aMinZ, cZ); tZ <= Math.min(aMaxZ, eZ); ++tZ) {
                int i;
                if (this.mBottom.mID > 0) {
                    for (i = tMinY - 1; i < tMinY + 2; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        WD.setOre(aWorld, tX, i, tZ, this.mBottom.mID);
                    }
                }
                if (this.mTop.mID > 0) {
                    for (i = tMinY + 3; i < tMinY + 6; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        WD.setOre(aWorld, tX, i, tZ, this.mTop.mID);
                    }
                }
                if (this.mBetween.mID > 0 && (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) == 0 || aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) == 0)) {
                    WD.setOre(aWorld, tX, tMinY + 2 + aRandom.nextInt(2), tZ, this.mBetween.mID);
                }
                if (this.mSpread.mID <= 0 || aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                WD.setOre(aWorld, tX, tMinY - 1 + aRandom.nextInt(7), tZ, this.mSpread.mID);
            }
        }
        return true;
    }

    @Override
    public Config getConfigFile() {
        return CS.ConfigsGT.WORLDGEN_GT5;
    }
}

