/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.transformers.minecraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Replacements {
    public static void EntityZombie_onKillEntity(Object aZombie, Object aVictim) {
        if (aVictim instanceof EntityVillager) {
            EntityVillager aVillager = (EntityVillager)aVictim;
            World aWorld = aVillager.worldObj;
            EntityZombie tZombieVillager = new EntityZombie(aWorld);
            tZombieVillager.copyLocationAndAnglesFrom((Entity)aVillager);
            tZombieVillager.onSpawnWithEgg((IEntityLivingData)null);
            tZombieVillager.setCanPickUpLoot(false);
            tZombieVillager.setVillager(true);
            tZombieVillager.func_110163_bv();
            tZombieVillager.setChild(aVillager.isChild());
            tZombieVillager.setCustomNameTag(aVillager.getCustomNameTag());
            aVillager.setCustomNameTag("");
            aWorld.spawnEntityInWorld((Entity)tZombieVillager);
            aWorld.playAuxSFXAtEntity(null, 1016, (int)tZombieVillager.posX, (int)tZombieVillager.posY, (int)tZombieVillager.posZ, 0);
            aWorld.removeEntity((Entity)aVillager);
        }
    }

    public static void BlockStaticLiquid_updateTick(BlockStaticLiquid self, World world, int x, int y, int z, Random rand) {
        if (self.getMaterial() == Material.lava) {
            int i1;
            int l = rand.nextInt(3);
            for (i1 = 0; i1 < l; ++i1) {
                Block block = world.getBlock(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1);
                if (block.getMaterial() == Material.air) {
                    if (!Replacements.BlockStaticLiquid_isFlammable(world, x - 1, y, z, ForgeDirection.EAST) && !Replacements.BlockStaticLiquid_isFlammable(world, x + 1, y, z, ForgeDirection.WEST) && !Replacements.BlockStaticLiquid_isFlammable(world, x, y, z - 1, ForgeDirection.SOUTH) && !Replacements.BlockStaticLiquid_isFlammable(world, x, y, z + 1, ForgeDirection.NORTH) && !Replacements.BlockStaticLiquid_isFlammable(world, x, y - 1, z, ForgeDirection.UP) && !Replacements.BlockStaticLiquid_isFlammable(world, x, y + 1, z, ForgeDirection.DOWN)) continue;
                    world.setBlock(x, y, z, (Block)Blocks.fire);
                    return;
                }
                if (!block.getMaterial().blocksMovement()) continue;
                return;
            }
            if (l == 0) {
                i1 = x;
                int k1 = z;
                for (int j1 = 0; j1 < 3; ++j1) {
                    x = i1 + rand.nextInt(3) - 1;
                    if (!world.isAirBlock(x, y + 1, z = k1 + rand.nextInt(3) - 1) || !Replacements.BlockStaticLiquid_isFlammable(world, x, y, z, ForgeDirection.UP)) continue;
                    world.setBlock(x, y + 1, z, (Block)Blocks.fire);
                }
            }
        }
    }

    public static boolean BlockStaticLiquid_isFlammable(World world, int x, int y, int z, ForgeDirection dir) {
        return world.getBlock(x, y, z).isFlammable((IBlockAccess)world, x, y, z, dir);
    }

    public static boolean BlockStaticLiquid_isFlammable(World world, int x, int y, int z) {
        return world.getBlock(x, y, z).isFlammable((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN);
    }

    public static boolean EntityAICreeperSwell_shouldExecute(EntityCreeper swellingCreeper) {
        EntityLivingBase target = swellingCreeper.getAttackTarget();
        if (swellingCreeper.getCreeperState() > 0) {
            return true;
        }
        if (target == null) {
            return false;
        }
        double distSq = swellingCreeper.getDistanceSqToEntity((Entity)target);
        if (distSq >= 9.0) {
            return false;
        }
        double facing = Vec3.createVectorHelper((double)target.posX, (double)target.posY, (double)target.posZ).subtract(Vec3.createVectorHelper((double)swellingCreeper.posX, (double)swellingCreeper.posY, (double)swellingCreeper.posZ)).normalize().dotProduct(target.getLookVec());
        return facing >= -0.0;
    }
}

