/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.block.IBlock;
import gregapi.block.IBlockOnHeadInside;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.item.IItemGT;
import gregapi.lang.LanguageHandler;
import gregapi.render.RendererBlockFluid;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class BlockWaterlike
extends BlockFluidClassic
implements IBlock,
IItemGT,
IBlockOnHeadInside {
    public static int WATER_UPDATE_FLAGS = 0;
    public final Fluid mFluid;
    public List<int[]> mEffects = new ArrayListNoNulls<int[]>();

    public BlockWaterlike(String aName, Fluid aFluid, boolean aFlowsOut, boolean aHide) {
        super(aFluid, Material.water);
        this.mFluid = aFluid;
        this.quantaPerBlock = aFlowsOut ? 8 : 3;
        this.quantaPerBlockFloat = this.quantaPerBlock;
        this.setResistance(30.0f);
        this.setBlockName(aName);
        this.setLightOpacity(3);
        ST.register((Block)this, aName, ItemBlock.class);
        LH.add(this.getUnlocalizedName(), this.getLocalizedName());
        LanguageHandler.set(this.getLocalizedName(), this.getLocalizedName());
        this.setFluidStack(FL.make(aFluid, 1000L));
        if (aHide) {
            ST.hide((Block)this);
        }
    }

    public FluidStack drain(World aWorld, int aX, int aY, int aZ, boolean aDoDrain) {
        if (aDoDrain) {
            aWorld.setBlock(aX, aY, aZ, CS.NB, 0, 2);
        }
        return FL.make(this.getFluid(), 1000L);
    }

    public boolean canDrain(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) == 0;
    }

    public void updateFlow(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        int tFlowMeta;
        int quantaRemaining = this.quantaPerBlock - WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (aWorld.getBlock(aX, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.getBlock(aX - 1, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.getBlock(aX + 1, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.getBlock(aX, aY - this.densityDir, aZ - 1) instanceof BlockWaterlike || aWorld.getBlock(aX, aY - this.densityDir, aZ + 1) instanceof BlockWaterlike) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX - 1, aY, aZ, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX + 1, aY, aZ, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX, aY, aZ - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX, aY, aZ + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    aWorld.setBlockToAir(aX, aY, aZ);
                } else {
                    aWorld.setBlockMetadataWithNotify(aX, aY, aZ, this.quantaPerBlock - expQuanta, 3);
                    aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, this.tickRate);
                    aWorld.notifyBlocksOfNeighborChange(aX, aY, aZ, (Block)this);
                }
            }
        }
        if (this.canDisplace((IBlockAccess)aWorld, aX, aY + this.densityDir, aZ)) {
            if (this.displaceIfPossible(aWorld, aX, aY + this.densityDir, aZ)) {
                aWorld.setBlock(aX, aY + this.densityDir, aZ, (Block)this, 1, WATER_UPDATE_FLAGS | 1);
            }
            return;
        }
        int n = tFlowMeta = aWorld.getBlock(aX, aY - this.densityDir, aZ) instanceof BlockWaterlike ? 1 : this.quantaPerBlock - quantaRemaining + 1;
        if (tFlowMeta >= this.quantaPerBlock) {
            return;
        }
        if (aWorld.blockExists(aX, aY, aZ - 1) && this.displaceIfPossible(aWorld, aX, aY, aZ - 1)) {
            aWorld.setBlock(aX, aY, aZ - 1, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX, aY, aZ + 1) && this.displaceIfPossible(aWorld, aX, aY, aZ + 1)) {
            aWorld.setBlock(aX, aY, aZ + 1, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX - 1, aY, aZ) && this.displaceIfPossible(aWorld, aX - 1, aY, aZ)) {
            aWorld.setBlock(aX - 1, aY, aZ, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX + 1, aY, aZ) && this.displaceIfPossible(aWorld, aX + 1, aY, aZ)) {
            aWorld.setBlock(aX + 1, aY, aZ, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
    }

    public Vec3 getFlowVector(IBlockAccess aWorld, int aX, int aY, int aZ) {
        Vec3 rVector = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        int tDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, aX, aY, aZ);
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
            int tX = aX + CS.OFFX[tSide];
            int tZ = aZ + CS.OFFZ[tSide];
            int tOtherDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, tX, aY, tZ);
            if (tOtherDecay >= this.quantaPerBlock) {
                if (aWorld.getBlock(tX, aY, tZ).getMaterial().blocksMovement() || (tOtherDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, tX, aY - 1, tZ)) < 0) continue;
                int tPower = tOtherDecay - (tDecay - this.quantaPerBlock);
                rVector = rVector.addVector((double)((tX - aX) * tPower), 0.0, (double)((tZ - aZ) * tPower));
                continue;
            }
            if (tOtherDecay < 0) continue;
            int power = tOtherDecay - tDecay;
            rVector = rVector.addVector((double)((tX - aX) * power), 0.0, (double)((tZ - aZ) * power));
        }
        if (aWorld.getBlock(aX, aY + 1, aZ) instanceof BlockWaterlike && (this.isBlockSolid(aWorld, aX, aY, aZ - 1, 2) || this.isBlockSolid(aWorld, aX, aY, aZ + 1, 3) || this.isBlockSolid(aWorld, aX - 1, aY, aZ, 4) || this.isBlockSolid(aWorld, aX + 1, aY, aZ, 5) || this.isBlockSolid(aWorld, aX, aY + 1, aZ - 1, 2) || this.isBlockSolid(aWorld, aX, aY + 1, aZ + 1, 3) || this.isBlockSolid(aWorld, aX - 1, aY + 1, aZ, 4) || this.isBlockSolid(aWorld, aX + 1, aY + 1, aZ, 5))) {
            rVector = rVector.normalize().addVector(0.0, -6.0, 0.0);
        }
        return rVector.normalize();
    }

    public int getQuantaValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return 0;
        }
        if (aBlock == this) {
            return this.quantaPerBlock - aWorld.getBlockMetadata(aX, aY, aZ);
        }
        if (aBlock instanceof BlockWaterlike) {
            return 8 - aWorld.getBlockMetadata(aX, aY, aZ);
        }
        if (aBlock == Blocks.water || aBlock == Blocks.flowing_water) {
            return 8 - aWorld.getBlockMetadata(aX, aY, aZ);
        }
        return -1;
    }

    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return true;
        }
        if (aBlock.getMaterial() == Material.water || WD.visOpq(aBlock)) {
            return false;
        }
        if (aBlock.isAir(aWorld, aX, aY, aZ)) {
            return true;
        }
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof ITileEntitySurface) {
            return !((ITileEntitySurface)tTileEntity).isSurfaceOpaque(CS.OPOS[aSide]);
        }
        return true;
    }

    public boolean isSourceBlock(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ) instanceof BlockWaterlike && aWorld.getBlockMetadata(aX, aY, aZ) == 0;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    public final String getUnlocalizedName() {
        return FL.name(this.mFluid, false);
    }

    public String getLocalizedName() {
        return FL.name(this.mFluid, true);
    }

    public void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public int getRenderType() {
        return RendererBlockFluid.RENDER_ID;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public int getLightOpacity() {
        return 3;
    }

    public IIcon getIcon(int aSide, int aMeta) {
        return Blocks.water.getIcon(aSide, aMeta);
    }

    public int getRenderColor(int aMeta) {
        return 0xFFFFFF;
    }

    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return 0xFFFFFF;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return 0;
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return 0;
    }

    public boolean canDisplace(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !aWorld.getBlock(aX, aY, aZ).getMaterial().isLiquid() && super.canDisplace(aWorld, aX, aY, aZ);
    }

    public boolean displaceIfPossible(World aWorld, int aX, int aY, int aZ) {
        return !aWorld.getBlock(aX, aY, aZ).getMaterial().isLiquid() && super.displaceIfPossible(aWorld, aX, aY, aZ);
    }

    public boolean canCollideCheck(int aMeta, boolean aFullHit) {
        return aFullHit && aMeta == 0;
    }

    public boolean getBlocksMovement(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !this.mEffects.isEmpty();
    }

    public boolean isNormalCube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean getTickRandomly() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    public BlockWaterlike addEffect(int aEffectID, int aEffectDuration, int aEffectLevel) {
        this.mEffects.add(new int[]{aEffectID, aEffectDuration, aEffectLevel});
        return this;
    }

    @Override
    public void onHeadInside(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.isRemote && !this.mEffects.isEmpty() && (FL.gas(this.mFluid) ? !UT.Entities.isImmuneToBreathingGases(aEntity) : !UT.Entities.isWearingFullChemHazmat(aEntity))) {
            for (int[] tEffects : this.mEffects) {
                UT.Entities.applyPotion((Entity)aEntity, tEffects[0], tEffects[1], tEffects[2], false);
            }
            if (this.getMaterial() != Material.water && CS.SERVER_TIME % 20L == 0L) {
                aEntity.attackEntityFrom(DamageSource.drown, 2.0f);
            }
        }
    }
}

