/*
 * Decompiled with CFR 0.152.
 */
package gregtech.entities.projectiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import gregapi.data.CS;
import gregapi.item.IItemProjectile;
import gregapi.oredict.OreDictItemData;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EntityArrow_Material
extends IItemProjectile.EntityProjectile {
    private int mHitBlockX = -1;
    private int mHitBlockY = -1;
    private int mHitBlockZ = -1;
    private Block mHitBlock = CS.NB;
    private int mHitBlockMeta = 0;
    private boolean inGround = false;
    private int mTicksAlive = 0;
    private int ticksInAir = 0;
    private int mKnockback = 0;
    private ItemStack mArrow = null;

    public EntityArrow_Material(World aWorld) {
        super(aWorld);
    }

    public EntityArrow_Material(World aWorld, double aX, double aY, double aZ) {
        super(aWorld, aX, aY, aZ);
    }

    public EntityArrow_Material(World aWorld, EntityLivingBase aEntity, float aSpeed) {
        super(aWorld, aEntity, aSpeed);
    }

    public EntityArrow_Material(EntityArrow aArrow, ItemStack aStack) {
        super(aArrow.worldObj);
        this.shootingEntity = aArrow.shootingEntity;
        NBTTagCompound tNBT = UT.NBT.make();
        aArrow.writeToNBT(tNBT);
        this.readFromNBT(tNBT);
        this.setProjectileStack(aStack);
    }

    public void onUpdate() {
        Block tBlock;
        this.onEntityUpdate();
        if (this.mArrow == null && !this.worldObj.isRemote) {
            this.setDead();
            return;
        }
        Entity tShootingEntity = this.shootingEntity;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
        if (this.mTicksAlive++ == 3000) {
            this.setDead();
        }
        if ((tBlock = this.worldObj.getBlock(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ)).getMaterial() != Material.air) {
            tBlock.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            AxisAlignedBB axisalignedbb = tBlock.getCollisionBoundingBoxFromPool(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int j = this.worldObj.getBlockMetadata(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (tBlock != this.mHitBlock || j != this.mHitBlockMeta) {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.mTicksAlive = 0;
                this.ticksInAir = 0;
            }
        } else {
            int i;
            ++this.ticksInAir;
            Vec3 vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition tVector = this.worldObj.func_147447_a(vec31, vec3, false, true, false);
            vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (tVector != null) {
                vec3 = Vec3.createVectorHelper((double)tVector.hitVec.xCoord, (double)tVector.hitVec.yCoord, (double)tVector.hitVec.zCoord);
            }
            Entity tHitEntity = null;
            List tAllPotentiallyHitEntities = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double tSmallestDistance = Double.MAX_VALUE;
            for (i = 0; i < tAllPotentiallyHitEntities.size(); ++i) {
                double tDistance;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)tAllPotentiallyHitEntities.get(i);
                if (!entity1.canBeCollidedWith() || entity1 == tShootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.boundingBox.expand(0.3, 0.3, 0.3)).calculateIntercept(vec31, vec3)) == null || !((tDistance = vec31.distanceTo(movingobjectposition1.hitVec)) < tSmallestDistance)) continue;
                tHitEntity = entity1;
                tSmallestDistance = tDistance;
            }
            if (tHitEntity != null) {
                tVector = new MovingObjectPosition(tHitEntity);
            }
            if (tVector != null && tHitEntity != null && tHitEntity instanceof EntityPlayer && (((EntityPlayer)tHitEntity).capabilities.disableDamage || tShootingEntity instanceof EntityPlayer && !((EntityPlayer)tShootingEntity).canAttackPlayer((EntityPlayer)tHitEntity))) {
                tVector = null;
            }
            if (tVector != null) {
                if (tHitEntity != null) {
                    int[] tDamages;
                    OreDictItemData tData = OM.anydata(this.mArrow);
                    if (tShootingEntity instanceof EntityPlayer) {
                        MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)tShootingEntity, tHitEntity));
                    }
                    float tMagicDamage = tHitEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.mArrow, (EnumCreatureAttribute)((EntityLivingBase)tHitEntity).getCreatureAttribute()) : 0.0f;
                    float tDamage = UT.Code.roundUp((double)MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ)) * (this.getDamage() + (double)Math.max(0, tData != null && tData.validMaterial() ? tData.mMaterial.mMaterial.mToolQuality - 1 : 0)));
                    if (this.getIsCritical()) {
                        tDamage += (float)this.rand.nextInt((int)((double)tDamage / 2.0 + 2.0));
                    }
                    int tImplosion = UT.NBT.getEnchantmentLevelImplosion(this.mArrow);
                    int tFireDamage = (this.isBurning() ? 5 : 0) + 4 * UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, this.mArrow);
                    int tKnockback = this.mKnockback + UT.NBT.getEnchantmentLevel(Enchantment.knockback, this.mArrow);
                    int tHitTimer = -1;
                    if (tImplosion > 0 && UT.Entities.isExplosiveCreature(tHitEntity) && !EntityCreeper.class.isInstance(tHitEntity)) {
                        tMagicDamage += 1.5f * (float)tImplosion;
                    }
                    if ((tDamages = this.onHitEntity(tHitEntity, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow == null ? ST.make(Items.arrow, 1L, 0L) : this.mArrow, (int)(tDamage * 2.0f), (int)(tMagicDamage * 2.0f), tKnockback, tFireDamage, tHitTimer)) != null) {
                        tDamage = (float)tDamages[0] / 2.0f;
                        tMagicDamage = (float)tDamages[1] / 2.0f;
                        tKnockback = tDamages[2];
                        tFireDamage = tDamages[3];
                        tHitTimer = tDamages[4];
                        if (tFireDamage > 0 && !(tHitEntity instanceof EntityEnderman)) {
                            tHitEntity.setFire(tFireDamage);
                        }
                        if (!(tHitEntity instanceof EntityPlayer) && UT.NBT.getEnchantmentLevel(Enchantment.looting, this.mArrow) > 0) {
                            FakePlayer tPlayer = null;
                            if (this.worldObj instanceof WorldServer) {
                                tPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.worldObj), (GameProfile)new GameProfile(new UUID(0L, 0L), tShootingEntity instanceof EntityLivingBase ? ((EntityLivingBase)tShootingEntity).getCommandSenderName() : "Arrow"));
                            }
                            if (tPlayer != null) {
                                tPlayer.inventory.currentItem = 0;
                                tPlayer.inventory.setInventorySlotContents(0, this.getArrowItem());
                                if (WD.dimTF(this.worldObj)) {
                                    tPlayer.capabilities.isCreativeMode = true;
                                }
                                tShootingEntity = tPlayer;
                                tPlayer.setDead();
                            }
                        }
                        DamageSource tDamageSource = DamageSource.causeArrowDamage((EntityArrow)this, (Entity)(tShootingEntity == null ? this : tShootingEntity));
                        if (tDamage + tMagicDamage > 0.0f && tHitEntity.attackEntityFrom(tDamageSource, (tDamage + tMagicDamage) * (float)CS.TFC_DAMAGE_MULTIPLIER)) {
                            if (tHitEntity instanceof EntityLivingBase) {
                                float tKnockbackDivider;
                                if (tHitTimer >= 0) {
                                    tHitEntity.hurtResistantTime = tHitTimer;
                                }
                                if (tHitEntity instanceof EntityCreeper && UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, this.mArrow) > 0 && tImplosion <= 0) {
                                    ((EntityCreeper)tHitEntity).func_146079_cb();
                                }
                                EntityLivingBase tHitLivingEntity = (EntityLivingBase)tHitEntity;
                                if (!this.worldObj.isRemote) {
                                    tHitLivingEntity.setArrowCountInEntity(tHitLivingEntity.getArrowCountInEntity() + 1);
                                }
                                if (tKnockback > 0 && (tKnockbackDivider = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
                                    tHitLivingEntity.addVelocity(this.motionX * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider, 0.1, this.motionZ * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider);
                                }
                                UT.Enchantments.applyBullshitA(tHitLivingEntity, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow);
                                UT.Enchantments.applyBullshitB(tShootingEntity instanceof EntityLivingBase ? (EntityLivingBase)tShootingEntity : null, (Entity)tHitLivingEntity, this.mArrow);
                                if (tShootingEntity != null && tHitLivingEntity != tShootingEntity && tHitLivingEntity instanceof EntityPlayer && tShootingEntity instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)tShootingEntity).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
                                }
                            }
                            if (tShootingEntity instanceof EntityPlayer && tMagicDamage > 0.0f) {
                                ((EntityPlayer)tShootingEntity).onEnchantmentCritical(tHitEntity);
                            }
                            if (!(tHitEntity instanceof EntityEnderman) || ((EntityEnderman)tHitEntity).getActivePotionEffect(Potion.weakness) != null) {
                                if (tFireDamage > 0) {
                                    tHitEntity.setFire(tFireDamage);
                                }
                                this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                                this.setDead();
                            }
                        } else {
                            this.motionX *= (double)-0.1f;
                            this.motionY *= (double)-0.1f;
                            this.motionZ *= (double)-0.1f;
                            this.rotationYaw += 180.0f;
                            this.prevRotationYaw += 180.0f;
                            this.ticksInAir = 0;
                        }
                    }
                } else {
                    this.mHitBlockX = tVector.blockX;
                    this.mHitBlockY = tVector.blockY;
                    this.mHitBlockZ = tVector.blockZ;
                    this.mHitBlock = this.worldObj.getBlock(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.mHitBlockMeta = this.worldObj.getBlockMetadata(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.motionX = (float)(tVector.hitVec.xCoord - this.posX);
                    this.motionY = (float)(tVector.hitVec.yCoord - this.posY);
                    this.motionZ = (float)(tVector.hitVec.zCoord - this.posZ);
                    float f2 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    this.posX -= this.motionX / (double)f2 * (double)0.05f;
                    this.posY -= this.motionY / (double)f2 * (double)0.05f;
                    this.posZ -= this.motionZ / (double)f2 * (double)0.05f;
                    this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.setIsCritical(false);
                    if (this.mHitBlock.getMaterial() != Material.air) {
                        this.mHitBlock.onEntityCollidedWithBlock(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, (Entity)this);
                    }
                    if (!this.worldObj.isRemote && UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, this.mArrow) > 2) {
                        WD.burn(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, true, false);
                    }
                    if (this.breaksOnImpact()) {
                        this.setDead();
                    }
                }
            }
            if (this.getIsCritical()) {
                for (i = 0; i < 4; ++i) {
                    this.worldObj.spawnParticle("crit", this.posX + this.motionX * (double)i / 4.0, this.posY + this.motionY * (double)i / 4.0, this.posZ + this.motionZ * (double)i / 4.0, -this.motionX, -this.motionY + 0.2, -this.motionZ);
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float tFrictionMultiplier = 0.99f;
            if (this.isInWater()) {
                for (int l = 0; l < 4; ++l) {
                    this.worldObj.spawnParticle("bubble", this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25, this.motionX, this.motionY, this.motionZ);
                }
                tFrictionMultiplier = 0.8f;
            }
            if (this.isWet()) {
                this.extinguish();
            }
            this.motionX *= (double)tFrictionMultiplier;
            this.motionY *= (double)tFrictionMultiplier;
            this.motionZ *= (double)tFrictionMultiplier;
            this.motionY -= (double)0.05f;
            this.setPosition(this.posX, this.posY, this.posZ);
            this.func_145775_I();
        }
    }

    public void writeEntityToNBT(NBTTagCompound aNBT) {
        super.writeEntityToNBT(aNBT);
        aNBT.setShort("xTile", (short)this.mHitBlockX);
        aNBT.setShort("yTile", (short)this.mHitBlockY);
        aNBT.setShort("zTile", (short)this.mHitBlockZ);
        aNBT.setShort("life", (short)this.mTicksAlive);
        aNBT.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.mHitBlock));
        aNBT.setByte("inData", (byte)this.mHitBlockMeta);
        aNBT.setByte("shake", (byte)this.arrowShake);
        aNBT.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        aNBT.setByte("pickup", (byte)this.canBePickedUp);
        aNBT.setDouble("damage", this.getDamage());
        aNBT.setTag("mArrow", (NBTBase)ST.save(this.mArrow));
    }

    public void readEntityFromNBT(NBTTagCompound aNBT) {
        super.readEntityFromNBT(aNBT);
        this.mHitBlockX = aNBT.getShort("xTile");
        this.mHitBlockY = aNBT.getShort("yTile");
        this.mHitBlockZ = aNBT.getShort("zTile");
        this.mTicksAlive = aNBT.getShort("life");
        this.mHitBlock = Block.getBlockById((int)(aNBT.getByte("inTile") & 0xFF));
        this.mHitBlockMeta = aNBT.getByte("inData") & 0xFF;
        this.arrowShake = aNBT.getByte("shake") & 0xFF;
        this.inGround = aNBT.getByte("inGround") == 1;
        this.setDamage(aNBT.getDouble("damage"));
        this.canBePickedUp = aNBT.getByte("pickup");
        this.mArrow = ST.load(aNBT, "mArrow");
    }

    public void onCollideWithPlayer(EntityPlayer aPlayer) {
        if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0 && this.canBePickedUp == 1 && aPlayer.inventory.addItemStackToInventory(this.getArrowItem())) {
            this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            aPlayer.onItemPickup((Entity)this, 1);
            this.setDead();
        }
    }

    public int[] onHitEntity(Entity aHitEntity, Entity aShootingEntity, ItemStack aArrow, int aRegularDamage, int aMagicDamage, int aKnockback, int aFireDamage, int aHitTimer) {
        return new int[]{aRegularDamage, aMagicDamage, aKnockback, aFireDamage, aHitTimer};
    }

    @Override
    public void setProjectileStack(ItemStack aStack) {
        this.mArrow = ST.update(ST.amount(1L, aStack), (Entity)this);
    }

    public ItemStack getArrowItem() {
        return ST.copy(this.mArrow);
    }

    public boolean breaksOnImpact() {
        return false;
    }

    public void setKnockbackStrength(int aKnockback) {
        this.mKnockback = aKnockback;
    }
}

