/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import com.mojang.authlib.GameProfile;
import gregapi.block.misc.BlockBaseBars;
import gregapi.block.misc.BlockBaseSpike;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.enchants.Enchantment_EnderDamage;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.misc.MultiTileEntityGregOLantern;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import twilightforest.entity.boss.EntityTFLich;

public class Behavior_Gun
extends IBehavior.AbstractBehaviorDefault {
    public static Behavior_Gun BULLETS_SMALL = new Behavior_Gun(TD.Projectiles.BULLET_SMALL, 1.0f, 10000L, 16L);
    public static Behavior_Gun BULLETS_MEDIUM = new Behavior_Gun(TD.Projectiles.BULLET_MEDIUM, 2.0f, 17500L, 8L);
    public static Behavior_Gun BULLETS_LARGE = new Behavior_Gun(TD.Projectiles.BULLET_LARGE, 3.0f, 25000L, 4L);
    public final TagData mBulletType;
    public final long mPower;
    public final float mMagic;
    public final byte mAmmoPerMag;

    public Behavior_Gun(TagData aBulletType, float aMagic, long aPower, long aAmmoPerMag) {
        this.mBulletType = aBulletType;
        this.mMagic = aMagic;
        this.mPower = aPower;
        this.mAmmoPerMag = UT.Code.bindStack(aAmmoPerMag);
    }

    public boolean shoot(ItemStack aGun, ItemStack aBullet, EntityPlayer aPlayer) {
        ChunkCoordinates oCoord;
        aGun = ST.update(aGun, (Entity)aPlayer);
        aBullet = ST.update(aBullet, (Entity)aPlayer);
        Vec3 tDir = aPlayer.getLookVec();
        Vec3 tPos = Vec3.createVectorHelper((double)aPlayer.posX, (double)(aPlayer.posY + (double)aPlayer.getEyeHeight()), (double)aPlayer.posZ);
        Vec3 tAim = tPos.addVector(tDir.xCoord * 200.0, tDir.yCoord * 200.0, tDir.zCoord * 200.0);
        List<ChunkCoordinates> aCoords = WD.line(tPos, tAim);
        ChunkCoordinates aCoord = oCoord = aCoords.get(0);
        ChunkCoordinates nCoord = oCoord;
        Block oBlock = CS.NB;
        Block aBlock = oBlock = WD.block((IBlockAccess)aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ);
        byte oMeta = 0;
        byte aMeta = oMeta = WD.meta((IBlockAccess)aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ);
        boolean tWater = WD.liquid(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ);
        int tFireAspect = UT.NBT.getEnchantmentLevel(Enchantment.flame, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, aBullet);
        List tEntities = aPlayer.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)aPlayer, AxisAlignedBB.getBoundingBox((double)(Math.min(tPos.xCoord, tAim.xCoord) - 2.0), (double)(Math.min(tPos.yCoord, tAim.yCoord) - 2.0), (double)(Math.min(tPos.zCoord, tAim.zCoord) - 2.0), (double)(Math.max(tPos.xCoord, tAim.xCoord) + 2.0), (double)(Math.max(tPos.yCoord, tAim.yCoord) + 2.0), (double)(Math.max(tPos.zCoord, tAim.zCoord) + 2.0)));
        ArrayListNoNulls<Entity> tTargets = new ArrayListNoNulls<Entity>();
        for (Object tEntity : tEntities) {
            AxisAlignedBB tBox;
            if (!(tEntity instanceof Entity) || (tBox = ((Entity)tEntity).boundingBox) == null) continue;
            if (tEntity instanceof EntityEnderCrystal) {
                tBox = tBox.getOffsetBoundingBox(0.0, 1.3, 0.0);
            }
            if (tBox.calculateIntercept(tPos, tAim) == null) continue;
            tTargets.add((Entity)tEntity);
        }
        long tPower = this.mPower + 2000L * (long)UT.NBT.getEnchantmentLevel(Enchantment.power, aGun);
        int ii = aCoords.size() - 1;
        for (int i = 1; i < ii; ++i) {
            AxisAlignedBB tBox;
            if (tPower <= 0L) {
                if (tFireAspect > 2) {
                    WD.burn(aPlayer.worldObj, oCoord, true, true);
                }
                return true;
            }
            oCoord = aCoords.get(i - 1);
            aCoord = aCoords.get(i);
            nCoord = aCoords.get(i + 1);
            oBlock = aBlock;
            oMeta = aMeta;
            aBlock = WD.block((IBlockAccess)aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ);
            aMeta = WD.meta((IBlockAccess)aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ);
            for (int j = 0; j < tTargets.size(); ++j) {
                if (!(((Entity)tTargets.get(j)).getDistanceSq((double)aCoord.posX + 0.5, (double)aCoord.posY + 0.5, (double)aCoord.posZ + 0.5) < ((Entity)tTargets.get(j)).getDistanceSq((double)nCoord.posX + 0.5, (double)nCoord.posY + 0.5, (double)nCoord.posZ + 0.5)) || !this.hit(aGun, aBullet, aPlayer, (Entity)tTargets.remove(j--), tPower, tDir) || (tPower -= 10000L) > 0L) continue;
                return true;
            }
            if (WD.liquid(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ)) {
                if (tWater) continue;
                tWater = true;
                UT.Sounds.send("game.neutral.swim", aPlayer.worldObj, aCoord);
                if (tPower > 10000L) {
                    tPower = 0L;
                    continue;
                }
                tPower /= 2L;
                continue;
            }
            tWater = false;
            if (aBlock instanceof BlockPumpkin || WD.te(aPlayer.worldObj, aCoord, true) instanceof MultiTileEntityGregOLantern) {
                if (CS.RNGSUS.nextInt(3) == 0) {
                    ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Blocks.pumpkin, 1L, 0L));
                } else {
                    ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.pumpkin_seeds, (long)(1 + CS.RNGSUS.nextInt(3)), 0L));
                }
                WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.worldObj, aCoord, false);
                }
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.melon_block) {
                ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.melon, (long)(1 + CS.RNGSUS.nextInt(6)), 0L));
                ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.melon_seeds, (long)(1 + CS.RNGSUS.nextInt(3)), 0L));
                WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.worldObj, aCoord, false);
                }
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.cactus) {
                ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Blocks.cactus, 1L, 0L));
                WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.worldObj, aCoord, false);
                }
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.cocoa) {
                ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, IL.Dye_Cocoa.get(1L, new Object[0]));
                WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.worldObj, aCoord, false);
                }
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 2000L;
                continue;
            }
            if (aBlock == Blocks.wool || aBlock.getMaterial() == Material.carpet) {
                if (tFireAspect > 1) {
                    WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                    WD.fire(aPlayer.worldObj, aCoord, false);
                }
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 4000L;
                continue;
            }
            if (aBlock.getMaterial() == Material.glass || aBlock == Blocks.ice || aBlock == Blocks.redstone_lamp || aBlock == Blocks.lit_redstone_lamp) {
                OreDictItemData tData = OM.anydata(ST.make(aBlock, 1L, (long)aMeta));
                for (OreDictMaterialStack tMaterial : tData.getAllMaterialStacks()) {
                    long tAmount = tMaterial.mAmount / OP.scrapGt.mAmount;
                    while (tAmount-- > 0L) {
                        ST.drop(aPlayer.worldObj, (double)aCoord.posX + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.posY + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.posZ + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, OP.scrapGt.mat(tMaterial.mMaterial, 1L));
                    }
                }
                WD.set(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, CS.NB, 0L, 3L);
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower -= 2000L;
                continue;
            }
            if (aBlock instanceof BlockFence || aBlock instanceof BlockFenceGate || aBlock == Blocks.web || aBlock == Blocks.mob_spawner || aBlock instanceof BlockPane || aBlock instanceof BlockRail || aBlock instanceof BlockTorch || aBlock instanceof BlockBaseBars || aBlock instanceof BlockBaseSpike || aBlock.getMaterial() == Material.cactus || aBlock.getMaterial() == Material.fire || aBlock.getMaterial() == Material.air || aBlock.getMaterial() == Material.cloth || aBlock.getMaterial() == Material.leaves || aBlock.getMaterial() == Material.plants || aBlock.getMaterial() == Material.vine) {
                tPower -= 200L;
                continue;
            }
            if (aBlock instanceof BlockStairs || WD.opq(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ, true, false)) {
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower = 0L;
                continue;
            }
            if ((aBlock.canCollideCheck((int)aMeta, false) || aBlock.canCollideCheck((int)aMeta, true)) && (tBox = aBlock.getCollisionBoundingBoxFromPool(aPlayer.worldObj, aCoord.posX, aCoord.posY, aCoord.posZ)) != null && tBox.calculateIntercept(tPos, tAim) != null) {
                UT.Sounds.send(aBlock.stepSound.getBreakSound(), aPlayer.worldObj, aCoord);
                tPower = 0L;
                continue;
            }
            tPower -= 200L;
        }
        return false;
    }

    public boolean hit(ItemStack aGun, ItemStack aBullet, EntityPlayer aPlayer, Entity aTarget, long aPower, Vec3 aDir) {
        try {
            if (aTarget.isEntityInvulnerable()) {
                return false;
            }
            if (aTarget instanceof EntityPlayer && (((EntityPlayer)aTarget).capabilities.disableDamage || !aPlayer.canAttackPlayer((EntityPlayer)aTarget))) {
                return false;
            }
            if (aTarget instanceof EntityEnderman && ((EntityEnderman)aTarget).getActivePotionEffect(Potion.weakness) == null && UT.NBT.getEnchantmentLevel((Enchantment)Enchantment_EnderDamage.INSTANCE, aBullet) <= 0) {
                for (int i = 0; i < 64; ++i) {
                    if (!((EntityEnderman)aTarget).teleportRandomly()) continue;
                    return false;
                }
            }
            if (!(aTarget instanceof EntityLivingBase || aTarget instanceof EntityDragonPart || aTarget instanceof EntityEnderCrystal)) {
                return false;
            }
            OreDictItemData tData = OM.anydata(aBullet);
            OreDictMaterial tGunMat = MultiItemTool.getPrimaryMaterial(aGun, MT.Steel);
            float tMassFactor = tData != null && tData.nonemptyMaterial() ? (float)tData.mMaterial.weight() / 50.0f : 1.0f;
            float tSpeedFactor = Math.min(2.0f, (float)aPower / 5000.0f);
            float tMagicDamage = aTarget instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)aBullet, (EnumCreatureAttribute)((EntityLivingBase)aTarget).getCreatureAttribute()) : (aTarget instanceof EntityDragonPart ? (float)UT.NBT.getEnchantmentLevel((Enchantment)Enchantment_EnderDamage.INSTANCE, aBullet) : 0.0f);
            float tDamage = tSpeedFactor * Math.max(0.0f, (float)tGunMat.mToolQuality * 0.5f + tMassFactor);
            int tImplosion = UT.NBT.getEnchantmentLevelImplosion(aBullet);
            int tFireDamage = 4 * (UT.NBT.getEnchantmentLevel(Enchantment.flame, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.fireAspect, aBullet));
            int tKnockback = UT.NBT.getEnchantmentLevel(Enchantment.punch, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.knockback, aBullet);
            if (tImplosion > 0 && UT.Entities.isExplosiveCreature(aTarget)) {
                tMagicDamage += 1.5f * (float)tImplosion;
            }
            if (tFireDamage > 0) {
                aTarget.setFire(tFireDamage);
            }
            EntityPlayer tPlayer = aPlayer;
            if (aTarget instanceof EntityPlayer) {
                tDamage /= 2.0f;
                tMagicDamage /= 2.0f;
            } else {
                tMagicDamage *= this.mMagic;
                if (aPlayer.worldObj instanceof WorldServer && UT.NBT.getEnchantmentLevel(Enchantment.looting, aBullet) > 0) {
                    tPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)aPlayer.worldObj), (GameProfile)new GameProfile(new UUID(0L, 0L), aPlayer.getCommandSenderName()));
                    tPlayer.inventory.currentItem = 0;
                    tPlayer.inventory.setInventorySlotContents(0, aBullet);
                    tPlayer.setPositionAndRotation(aPlayer.posX, aPlayer.posY, aPlayer.posZ, aPlayer.rotationYaw, aPlayer.rotationPitch);
                    if (WD.dimTF(aPlayer.worldObj)) {
                        tPlayer.capabilities.isCreativeMode = true;
                    }
                    tPlayer.setDead();
                }
            }
            DamageSource tDamageSource = DamageSources.getCombatDamage("player", (EntityLivingBase)tPlayer, DamageSources.getDeathMessage((EntityLivingBase)aPlayer, aTarget, tData != null && tData.validMaterial() ? "[VICTIM] got killed by [KILLER] shooting a Bullet made of " + tData.mMaterial.mMaterial.getLocal() : "[VICTIM] got shot by [KILLER]"), false).setProjectile();
            if (aPower > 25000L) {
                tDamageSource.setDamageBypassesArmor();
            }
            if (MD.TF.mLoaded && aTarget instanceof EntityTFLich && UT.NBT.getEnchantmentLevel(Enchantment.smite, aBullet) > 0) {
                tDamageSource.setDamageBypassesArmor();
            }
            if (aTarget.attackEntityFrom(tDamageSource, (tDamage + tMagicDamage) * (float)CS.TFC_DAMAGE_MULTIPLIER)) {
                int n = aTarget.hurtResistantTime = aTarget instanceof EntityLivingBase ? ((EntityLivingBase)aTarget).maxHurtResistantTime : 20;
                if (aTarget instanceof EntityCreeper && tFireDamage > 0 && tImplosion <= 0) {
                    ((EntityCreeper)aTarget).func_146079_cb();
                }
                if (tKnockback > 0) {
                    aTarget.addVelocity(aDir.xCoord * (double)tKnockback * (double)aPower / 50000.0, 0.05, aDir.zCoord * (double)tKnockback * (double)aPower / 50000.0);
                }
                if (aTarget instanceof EntityLivingBase) {
                    UT.Enchantments.applyBullshitA((EntityLivingBase)aTarget, (Entity)aPlayer, aBullet);
                }
                UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aTarget, aBullet);
                if (aTarget instanceof EntityPlayer && aPlayer instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)aPlayer).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
                }
                if (tMagicDamage > 0.0f) {
                    aPlayer.onEnchantmentCritical(aTarget);
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            UT.Entities.sendchat((Object)aPlayer, "See gregtech.log for details: " + e.toString());
            aTarget.setDead();
            return true;
        }
        return aTarget.hurtResistantTime <= 0;
    }

    @Override
    public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        this.onItemRightClick(aItem, aStack, aPlayer.worldObj, aPlayer);
        return true;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.isRemote) {
            return false;
        }
        this.onItemRightClick(aItem, aStack, aPlayer.worldObj, aPlayer);
        return true;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aGun, World aWorld, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return aGun;
        }
        NBTTagCompound aNBT = UT.NBT.getOrCreate(aGun);
        ItemStack aBullet = ST.load(aNBT, "gt.ammo");
        if (aPlayer.isSneaking()) {
            if (ST.invalid(aBullet) || aBullet.stackSize <= 0) {
                this.reloadGun(aGun, aPlayer, false);
                return aGun;
            }
            ST.give((Entity)aPlayer, aBullet);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", CS.NI);
            return aGun;
        }
        if (ST.invalid(aBullet) || aBullet.stackSize <= 0) {
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", CS.NI);
            return aGun;
        }
        this.shoot(aGun, ST.amount(1L, aBullet), aPlayer);
        UT.Sounds.send("fireworks.blast_far", 128.0f, (Entity)aPlayer);
        if (!UT.Entities.hasInfiniteItems(aPlayer) && CS.RNGSUS.nextInt(1 + UT.NBT.getEnchantmentLevel(Enchantment.infinity, aGun)) == 0) {
            OreDictItemData tData = OM.anydata(aBullet);
            --aBullet.stackSize;
            ST.save(aNBT, "gt.ammo", aBullet.stackSize > 0 ? aBullet : CS.NI);
            for (OreDictMaterialStack tMat : tData.mByProducts) {
                if (tMat.mAmount < OP.scrapGt.mAmount || tMat.mMaterial.containsAny(TD.Properties.EXPLOSIVE, TD.Properties.FLAMMABLE)) continue;
                ST.give((Entity)aPlayer, OP.scrapGt.mat(tMat.mMaterial, tMat.mAmount / OP.scrapGt.mAmount));
            }
        }
        ((MultiItemTool)aItem).doDamage(aGun, 100L, (EntityLivingBase)aPlayer, false);
        return aGun;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.Chat.CYAN + LH.get("gt.weapon.sneak.rightclick.reload"));
        ItemStack aBullet = ST.load(UT.NBT.getNBT(aStack), "gt.ammo");
        if (ST.valid(aBullet)) {
            aList.add(LH.Chat.YELLOW + aBullet.getDisplayName() + LH.Chat._WHITE + aBullet.stackSize);
        }
        return aList;
    }

    public boolean isProjectile(ItemStack aStack) {
        return ST.item(aStack) instanceof IItemProjectile && ((IItemProjectile)ST.item(aStack)).hasProjectile(this.mBulletType, aStack);
    }

    public boolean reloadGun(ItemStack aGun, EntityPlayer aPlayer, boolean aOnlyCheckHeld) {
        int i;
        NBTTagCompound aNBT = UT.NBT.getOrCreate(aGun);
        ItemStack aBullet = ST.load(aNBT, "gt.ammo");
        if (ST.valid(aBullet) && aBullet.stackSize > 0) {
            return false;
        }
        if (this.isProjectile(aPlayer.inventory.mainInventory[aPlayer.inventory.currentItem])) {
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.inventory.mainInventory[aPlayer.inventory.currentItem].stackSize);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.inventory.mainInventory[aPlayer.inventory.currentItem]));
            aPlayer.inventory.decrStackSize(aPlayer.inventory.currentItem, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        if (aOnlyCheckHeld) {
            return false;
        }
        for (i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
            if (aPlayer.inventory.mainInventory[i] != aGun) continue;
            if (i >= 27 || !this.isProjectile(aPlayer.inventory.mainInventory[i + 27])) break;
            if (i < 18 && this.isProjectile(aPlayer.inventory.mainInventory[i + 18])) {
                if (i < 9 && this.isProjectile(aPlayer.inventory.mainInventory[i + 9])) {
                    int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.inventory.mainInventory[i + 9].stackSize);
                    UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
                    ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.inventory.mainInventory[i + 9]));
                    aPlayer.inventory.decrStackSize(i + 9, tConsumed);
                    ST.update((Entity)aPlayer);
                    return true;
                }
                int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.inventory.mainInventory[i + 18].stackSize);
                UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
                ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.inventory.mainInventory[i + 18]));
                aPlayer.inventory.decrStackSize(i + 18, tConsumed);
                ST.update((Entity)aPlayer);
                return true;
            }
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.inventory.mainInventory[i + 27].stackSize);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.inventory.mainInventory[i + 27]));
            aPlayer.inventory.decrStackSize(i + 27, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        for (i = aPlayer.inventory.mainInventory.length - 1; i >= 0; --i) {
            if (!this.isProjectile(aPlayer.inventory.mainInventory[i])) continue;
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.inventory.mainInventory[i].stackSize);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.inventory.mainInventory[i]));
            aPlayer.inventory.decrStackSize(i, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        return false;
    }
}

