/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityRemoteActivateable;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class Behavior_Remote
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Remote();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ChunkCoordinates tCoords;
        if (aWorld.isRemote || aPlayer == null || !aPlayer.isSneaking() || !aPlayer.canPlayerEdit(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound aNBT = UT.NBT.getNBT(aStack);
        ArrayListNoNulls<ChunkCoordinates> tList = Behavior_Remote.getCoords(aNBT, aWorld.provider.dimensionId);
        if (tList.contains(tCoords = new ChunkCoordinates(aX, aY, aZ))) {
            UT.Entities.sendchat((Object)aPlayer, "Coordinates removed!");
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
            tList.remove(tCoords);
        } else if (tList.size() >= 64) {
            UT.Entities.sendchat((Object)aPlayer, "Cant hold more than 64 Coordinates per Dimension!");
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
        } else {
            TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
            if (tTileEntity instanceof ITileEntityRemoteActivateable) {
                UT.Entities.sendchat((Object)aPlayer, "Coordinates added!");
                UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
                tList.add(tCoords);
            } else {
                UT.Entities.sendchat((Object)aPlayer, "This cannot be added!");
                UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
            }
        }
        Behavior_Remote.setCoords(aNBT, aWorld.provider.dimensionId, tList);
        UT.NBT.set(aStack, aNBT);
        return true;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aWorld.isRemote || aPlayer.isSneaking() || !aStack.hasTagCompound()) {
            return aStack;
        }
        ArrayListNoNulls<ChunkCoordinates> tToBeKept = new ArrayListNoNulls<ChunkCoordinates>();
        for (ChunkCoordinates tCoords : Behavior_Remote.getCoords(aStack.getTagCompound(), aWorld.provider.dimensionId)) {
            if (Math.abs((double)tCoords.posX - aPlayer.posX) <= 128.0 && Math.abs((double)tCoords.posY - aPlayer.posY) <= 128.0 && Math.abs((double)tCoords.posZ - aPlayer.posZ) <= 128.0) {
                TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
                if (!(tTileEntity instanceof ITileEntityRemoteActivateable) || !((ITileEntityRemoteActivateable)tTileEntity).remoteActivate()) continue;
                tToBeKept.add(tCoords);
                continue;
            }
            tToBeKept.add(tCoords);
        }
        Behavior_Remote.setCoords(aStack.getTagCompound(), aWorld.provider.dimensionId, tToBeKept);
        UT.Sounds.send("random.click", (Entity)aPlayer);
        return aStack;
    }

    public static boolean addCoords(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        NBTTagCompound aNBT = UT.NBT.getNBT(aStack);
        ArrayListNoNulls<ChunkCoordinates> tList = Behavior_Remote.getCoords(aNBT, aWorld.provider.dimensionId);
        if (tList.size() >= 64) {
            return false;
        }
        ChunkCoordinates tCoords = new ChunkCoordinates(aX, aY, aZ);
        if (tList.contains(tCoords)) {
            return true;
        }
        TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
        if (tTileEntity instanceof ITileEntityRemoteActivateable) {
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
            tList.add(tCoords);
            Behavior_Remote.setCoords(aNBT, aWorld.provider.dimensionId, tList);
            UT.NBT.set(aStack, aNBT);
            return true;
        }
        UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
        return false;
    }

    public static ArrayListNoNulls<ChunkCoordinates> getCoords(NBTTagCompound aNBT, int aDimension) {
        ArrayListNoNulls<ChunkCoordinates> rList = new ArrayListNoNulls<ChunkCoordinates>();
        if (aNBT == null) {
            return rList;
        }
        NBTTagCompound tNBT = aNBT.getCompoundTag("gt.remote.dim." + aDimension);
        if (tNBT.hasNoTags()) {
            return rList;
        }
        int i = -1;
        while (tNBT.hasKey("c" + ++i)) {
            rList.add(new ChunkCoordinates(tNBT.getInteger("x" + i), tNBT.getInteger("y" + i), tNBT.getInteger("z" + i)));
        }
        return rList;
    }

    public static void setCoords(NBTTagCompound aNBT, int aDimension, ArrayListNoNulls<ChunkCoordinates> aList) {
        if (aList.isEmpty()) {
            aNBT.removeTag("gt.remote.dim." + aDimension);
        } else {
            NBTTagCompound tNBT = UT.NBT.make();
            int j = aList.size();
            for (int i = 0; i < j; ++i) {
                ChunkCoordinates tCoords = (ChunkCoordinates)aList.get(i);
                UT.NBT.setBoolean(tNBT, "c" + i, true);
                UT.NBT.setNumber(tNBT, "x" + i, tCoords.posX);
                UT.NBT.setNumber(tNBT, "y" + i, tCoords.posY);
                UT.NBT.setNumber(tNBT, "z" + i, tCoords.posZ);
            }
            aNBT.setTag("gt.remote.dim." + aDimension, (NBTBase)tNBT);
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.remote"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.remote", "Activates up to 64 Blocks within a Range of 128m");
    }
}

