/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class Behavior_Spray_Extinguisher
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;

    public Behavior_Spray_Extinguisher(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long tExtinguished;
        if (aWorld.isRemote || aStack.stackSize != 1 || !aPlayer.canPlayerEdit(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        long tUses = tNBT.getLong("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.getItem());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && (tExtinguished = this.extinguish(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack, aHitX, aHitY, aHitZ)) > 0L) {
            UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 2.0f, aWorld, aX, aY, aZ);
            UT.Sounds.send("random.fizz", 1.0f, 1.5f, aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tExtinguished;
            }
            rOutput = true;
        }
        tNBT.removeTag("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        UT.NBT.set(aStack, tNBT);
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.stackSize;
            } else {
                aStack.func_150996_a(this.mEmpty.getItem());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        return rOutput;
    }

    public long extinguish(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer == null || CS.SIDES_INVALID[aSide] || aPlayer instanceof FakePlayer || !WD.obstructed(aWorld, aX, aY, aZ, aSide)) {
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("extinguisher", aUses * 1000L, 1L, (Entity)aPlayer, tChatReturn, (IInventory)(aPlayer == null ? null : aPlayer.inventory), aPlayer != null && aPlayer.isSneaking(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
            UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
            if (tDamage > 0L) {
                return Math.min(10L, tDamage / 1000L);
            }
        }
        if (aUses < 10L) {
            return 0L;
        }
        long rUses = 0L;
        aX += CS.OFFX[aSide];
        aY += CS.OFFY[aSide];
        aZ += CS.OFFZ[aSide];
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (rUses + 10L > aUses) {
                        return rUses;
                    }
                    if (aWorld.getBlock(aX + i, aY + j, aZ + k) != Blocks.fire || !aWorld.setBlock(aX + i, aY + j, aZ + k, CS.NB, 0, 3)) continue;
                    rUses += 10L;
                }
            }
        }
        for (Object tEntity : aWorld.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)(aX - 2), (double)(aY - 2), (double)(aZ - 2), (double)(aX + 3), (double)(aY + 3), (double)(aZ + 3)))) {
            if (rUses + 10L > aUses) {
                return rUses;
            }
            if (tEntity.getClass() == EntityBlaze.class) {
                ((EntityBlaze)tEntity).attackEntityFrom(DamageSources.getCombatDamage("player", (EntityLivingBase)aPlayer, null, false), 10.0f);
                rUses += 10L;
                continue;
            }
            if (!((Entity)tEntity).isBurning()) continue;
            ((Entity)tEntity).extinguish();
            rUses += 10L;
        }
        return rUses;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.extinguisher.tooltip"));
        NBTTagCompound tNBT = aStack.getTagCompound();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.getLong("gt.remaining"));
        aList.add(LH.get("gt.behaviour.extinguisher.uses") + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.extinguisher.tooltip", "Extinguishes Fire");
        LH.add("gt.behaviour.extinguisher.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

