/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.generators;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityMagicFieldAbsorber
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff {
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected boolean mCheck = true;
    protected long mOutput = 64L;
    protected TagData mEnergyTypeEmitted = TD.Energy.TU;
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;
    public static IIconContainer[] sOverlaysActive;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.stopped")) {
            this.mStopped = aNBT.getBoolean("gt.stopped");
        }
        if (aNBT.hasKey("gt.active")) {
            this.mActive = aNBT.getBoolean("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.magicenergyabsorber"));
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + this.mOutput + LH.Chat.RAINBOW + " ?U" + LH.Chat.WHITE + "/t");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && !this.mStopped) {
            if (this.mCheck || this.mBlockUpdated || aTimer % 600L == 5L) {
                boolean tActive = this.mActive;
                this.mCheck = false;
                this.mActive = false;
                this.mOutput = 64L;
                Block tBlock = this.getBlockAtSide((byte)1);
                if (tBlock == Blocks.dragon_egg) {
                    this.mActive = true;
                    this.mOutput = 64L;
                    this.mEnergyTypeEmitted = TD.Energy.QU;
                } else if (tBlock == Blocks.skull) {
                    this.mActive = true;
                    this.mOutput = 1L;
                    this.mEnergyTypeEmitted = TD.Energy.TU;
                } else if (IL.TF_Trophy.equal(tBlock)) {
                    switch (tBlock.getDamageValue(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord)) {
                        case 1: {
                            this.mActive = true;
                            this.mOutput = 64L;
                            this.mEnergyTypeEmitted = TD.Energy.KU;
                            break;
                        }
                        case 2: {
                            this.mActive = true;
                            this.mOutput = 64L;
                            this.mEnergyTypeEmitted = TD.Energy.QU;
                            break;
                        }
                        default: {
                            this.mActive = true;
                            this.mOutput = 64L;
                            this.mEnergyTypeEmitted = TD.Energy.HU;
                            break;
                        }
                        case 3: {
                            this.mActive = true;
                            this.mOutput = 64L;
                            this.mEnergyTypeEmitted = TD.Energy.LU;
                            break;
                        }
                        case 4: {
                            this.mActive = true;
                            this.mOutput = 64L;
                            this.mEnergyTypeEmitted = TD.Energy.CU;
                        }
                    }
                }
                if (tActive != this.mActive) {
                    this.updateClientData();
                }
            }
            if (this.mActive) {
                if (this.mEnergyTypeEmitted == TD.Energy.KU) {
                    ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, aTimer % 128L < 64L ? -this.mOutput : this.mOutput, 1L, this);
                } else if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyTypeEmitted)) {
                    ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, this.mOutput, this);
                } else {
                    ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mOutput, 1L, this);
                }
            }
        }
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActive = (aData & 1) != 0;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mActive ? 1 : 0);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.ALL_GT;
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActive;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        if (this.mStopped && aOnOff) {
            this.mCheck = true;
        }
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM_HORIZONTAL;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = CS.SIDES_TOP[aSide] ? 4 : (aSide == this.mFacing ? (CS.SIDES_HORIZONTAL[aSide] ? 0 : 2) : (CS.SIDES_HORIZONTAL[aSide] ? 1 : 3));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get((this.mActive ? sOverlaysActive : sOverlays)[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.magicenergyabsorber";
    }

    static {
        LH.add("gt.tooltip.magicenergyabsorber", "Generates Power from Magical Trophies on top of it.");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/colored/side_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/colored/side"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/colored/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/colored/top")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay/side_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay/top")};
        sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay_active/side_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay_active/side"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay_active/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/magicenergyabsorber/overlay_active/top")};
    }
}

