/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.tools.MultiTileEntityAnvil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MultiTileEntityQueueHopper
extends TileEntityBase09FacingSingle
implements ITileEntityAdjacentInventoryUpdatable {
    public boolean mLock = false;
    public byte mMode = (byte)64;
    public byte mCheck = (byte)3;
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mMode = aNBT.getByte("gt.mode");
        if (this.mMode <= 0) {
            this.mMode = (byte)64;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 64) {
            aNBT.setByte("gt.mode", this.mMode);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mMode != 64) {
            aNBT.setByte("gt.mode", this.mMode);
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.hopper.tooltip.1") + this.invsize());
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.hopper.tooltip.2") + this.mMode);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
        if (this.isServerSide() && CS.SIDES_BOTTOM_HORIZONTAL[this.mFacing]) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityConnector && CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && ((ITileEntityConnector)tDelegator.mTileEntity).allowInteraction((Entity)aPlayer) && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), TD.Connectors.ALL_ITEM_TRANSPORT)) {
                ((ITileEntityConnector)tDelegator.mTileEntity).connect(tDelegator.mSideOfTileEntity, true);
            }
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("screwdriver")) {
            if (aPlayer != null && aPlayer.isSneaking()) {
                this.mMode = (byte)(this.mMode - 1);
                if (this.mMode < 1) {
                    this.mMode = (byte)64;
                }
            } else {
                this.mMode = (byte)(this.mMode + 1);
                if (this.mMode > 64) {
                    this.mMode = 1;
                }
            }
            if (aChatReturn != null) {
                aChatReturn.add("Max Stacksize: " + this.mMode);
            }
            return 200L;
        }
        if (aTool.equals("softhammer")) {
            this.mMode = (byte)64;
            if (aChatReturn != null) {
                aChatReturn.add("Max Stacksize: " + this.mMode);
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Max Stacksize: " + this.mMode);
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onWalkOver2(EntityLivingBase aEntity) {
        if (this.isServerSide() && (aEntity.getClass() == EntitySnowman.class || "EntityNewSnowGolem".equalsIgnoreCase(UT.Reflection.getLowercaseClass(aEntity)))) {
            this.addStackToSlot(this.invsize() - 1, ST.make(Items.snowball, 1L, 0L));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            int tMovedItems = 0;
            if (this.mCheck > 0) {
                this.mCheck = (byte)(this.mCheck - 1);
            } else if ((this.mCheck == 0 || this.mInventoryChanged || this.mBlockUpdated || CS.SYNC_SECOND) && !this.hasRedstoneIncomingFromNonRail()) {
                int i;
                List tList;
                DelegatorTileEntity<TileEntity> tDelegator;
                if (!CS.SIDES_TOP[this.mFacing] && !this.invempty()) {
                    tDelegator = this.getAdjacentTileEntity(this.mFacing);
                    if (tDelegator.getBlock() instanceof BlockRailBase && (tList = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, tDelegator.box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), IEntitySelector.selectInventories)) != null && !tList.isEmpty()) {
                        tDelegator = new DelegatorTileEntity<IInventory>((IInventory)tList.get(0), tDelegator);
                    }
                    while (tMovedItems < this.mMode) {
                        this.mLock = true;
                        int tMoved = ST.move(this.delegator(this.mFacing), tDelegator, null, false, false, false, true, this.mMode, 1, this.mMode - tMovedItems, 1);
                        this.mLock = false;
                        if (tMoved <= 0) break;
                        tMovedItems += tMoved;
                    }
                }
                if ((tDelegator = this.getAdjacentTileEntity((byte)1)).getBlock() instanceof BlockRailBase && (tList = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, tDelegator.box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), IEntitySelector.selectInventories)) != null && !tList.isEmpty()) {
                    tDelegator = new DelegatorTileEntity<IInventory>((IInventory)tList.get(0), tDelegator);
                }
                if (tDelegator.mTileEntity != null && !(tDelegator.mTileEntity instanceof MultiTileEntityAnvil)) {
                    tMovedItems += ST.move(tDelegator, this.delegator((byte)1));
                } else if (!WD.visOpq(tDelegator.getWorld(), tDelegator.getX(), tDelegator.getY(), tDelegator.getZ(), false, true) && !this.slotHas(i = this.invsize() - 1)) {
                    this.slot(i, WD.suck(tDelegator));
                    if (this.slotHas(i)) {
                        tMovedItems += this.slot((int)i).stackSize;
                        this.updateInventory();
                    }
                }
                this.mCheck = tMovedItems > 0 ? (byte)3 : (byte)-1;
            }
            if (this.mInventoryChanged) {
                int oMovedItems = -1;
                while (oMovedItems != tMovedItems) {
                    oMovedItems = tMovedItems;
                    int j = this.invsize();
                    for (int i = 1; i < j; ++i) {
                        tMovedItems += ST.move(this, i - 1, i);
                    }
                }
            }
            if (tMovedItems > 0) {
                for (byte tSide : CS.ALL_SIDES_BUT_TOP) {
                    if (tSide == this.mFacing) continue;
                    DelegatorTileEntity<TileEntity> tDelegatorUpdate = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegatorUpdate.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegatorUpdate.mTileEntity).adjacentInventoryUpdated(tDelegatorUpdate.mSideOfTileEntity, this);
                }
            }
        }
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_N[0] : CS.PX_N[8];
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_N[2] : CS.PX_N[8];
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return new int[]{0, this.invsize() - 1};
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == this.invsize() - 1 && (this.mLock || aSide != this.mFacing);
    }

    @Override
    public int getInventoryStackLimit() {
        return this.mMode;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return this.mMode;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if ((CS.SIDES_TOP[aSide] || aSide == this.mFacing) && this.mCheck < 0) {
            this.mCheck = 0;
        }
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return CS.SIDES_TOP[this.mFacing] ? 2 : 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[10], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[4], CS.PX_P[4], CS.PX_P[4], CS.PX_N[4], CS.PX_N[6], CS.PX_N[4]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 0: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[12], CS.PX_N[6]);
                        return true;
                    }
                    case 2: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[4], CS.PX_P[0], CS.PX_N[6], CS.PX_N[8], CS.PX_N[12]);
                        return true;
                    }
                    case 3: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[4], CS.PX_P[12], CS.PX_N[6], CS.PX_N[8], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[4], CS.PX_P[6], CS.PX_N[12], CS.PX_N[8], CS.PX_N[6]);
                        return true;
                    }
                    case 5: {
                        this.box(aBlock, CS.PX_P[12], CS.PX_P[4], CS.PX_P[6], CS.PX_N[0], CS.PX_N[8], CS.PX_N[6]);
                        return true;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return (aRenderPass == 1 ? !CS.SIDES_TOP[aSide] : aShouldSideBeRendered[aSide] || aRenderPass == 0 && CS.SIDES_BOTTOM[aSide] || aRenderPass == 2 && aSide != this.mFacing) ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.queuehopper";
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.inventory, (ITileEntityInventoryGUI)this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.inventory, this, aGUIID);
    }

    static {
        LH.add("gt.multitileentity.hopper.tooltip.1", "Slot Count: ");
        LH.add("gt.multitileentity.hopper.tooltip.2", "Slot Size: ");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/colored/top"), new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/automation/queuehopper/overlay/side")};
    }
}

