/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.GT6_Main;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MultiTileEntityCertificate
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_OnRegistration,
IMultiTileEntity.IMTE_OnDespawn,
IMultiTileEntity.IMTE_GetLifeSpan,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_OnServerLoad,
IMultiTileEntity.IMTE_OnServerSave,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public static final ArrayListNoNulls<String> ALREADY_RECEIVED = new ArrayListNoNulls();
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityCertificate INSTANCE;
    public boolean mSilver = false;
    public boolean mGold = false;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSilver;
    public static IIconContainer sTextureGold;

    @Override
    public void onServerSave(File aSaveLocation) {
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "certificates.support.dat");
        if (!aTargetFile.exists()) {
            try {
                aTargetFile.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        NBTTagCompound aNBT = UT.NBT.make();
        for (int i = 0; i < ALREADY_RECEIVED.size(); ++i) {
            aNBT.setString("" + i, (String)ALREADY_RECEIVED.get(i));
        }
        try {
            CompressedStreamTools.write((NBTTagCompound)aNBT, (File)aTargetFile);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    @Override
    public void onServerLoad(File aSaveLocation) {
        ALREADY_RECEIVED.clear();
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "certificates.support.dat");
        if (aTargetFile.exists()) {
            NBTTagCompound aNBT = null;
            try {
                aNBT = CompressedStreamTools.read((File)aTargetFile);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (aNBT != null) {
                for (int i = 0; i < Integer.MAX_VALUE && aNBT.hasKey("" + i); ++i) {
                    ALREADY_RECEIVED.add(aNBT.getString("" + i));
                }
            }
        }
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    public static ItemStack getCertificate(int aAmount, String aName) {
        NBTTagCompound tNBT = UT.NBT.make();
        if (UT.Code.stringValid(aName)) {
            tNBT.setTag("display", (NBTBase)UT.NBT.makeString(tNBT.getCompoundTag("display"), "Name", aName));
        }
        return MTE_REGISTRY.getItem(INSTANCE.getMultiTileEntityID(), aAmount, tNBT);
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        String tName = this.getCustomName();
        if (UT.Code.stringValid(tName)) {
            ALREADY_RECEIVED.add(tName);
            ALREADY_RECEIVED.add(tName.toLowerCase());
            this.mGold = GT6_Main.gt_proxy.mSupporterListGold.contains(tName.toLowerCase());
            this.mSilver = GT6_Main.gt_proxy.mSupporterListSilver.contains(tName.toLowerCase());
        }
    }

    @Override
    public void setCustomName(String aName) {
        super.setCustomName(aName);
        if (UT.Code.stringValid(aName)) {
            this.mGold = GT6_Main.gt_proxy.mSupporterListGold.contains(aName.toLowerCase());
            this.mSilver = GT6_Main.gt_proxy.mSupporterListSilver.contains(aName.toLowerCase());
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.certificate"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            if (CS.D1) {
                for (ItemStack tStack : aPlayer.inventory.mainInventory) {
                    if (!ST.valid(tStack)) continue;
                    CS.DEB.println("ST.make(\"" + ST.regName(tStack) + "\"      , 1, " + ST.meta_(tStack) + ");                            // " + ST.namesAndSizes(tStack));
                }
            }
            if (this.mGold) {
                UT.Entities.sendchat((Object)aPlayer, "This Certificate is owned by" + LH.Chat._YELLOW + this.getCustomName());
                return true;
            }
            if (this.mSilver) {
                UT.Entities.sendchat((Object)aPlayer, "This Certificate is owned by" + LH.Chat._CYAN + this.getCustomName());
                return true;
            }
            UT.Entities.sendchat((Object)aPlayer, "This Certificate is invalid!");
            return true;
        }
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PX_P[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PX_P[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PX_N[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PX_N[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PX_N[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aSide == CS.OPOS[this.mFacing]) {
            return aShouldSideBeRendered[aSide] ? BlockTextureDefault.get(sTextureBack) : null;
        }
        return BlockTextureDefault.get(this.mGold ? sTextureGold : (this.mSilver ? sTextureSilver : sTextureBack));
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PX_P[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PX_P[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PX_N[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PX_N[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PX_N[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PX_P[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PX_P[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PX_N[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PX_N[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PX_N[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PX_P[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PX_P[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PX_N[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PX_N[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PX_N[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PX_P[15] : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PX_P[15] : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? CS.PX_N[1] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public int getPaint() {
        return 0xFFFFFF;
    }

    @Override
    public boolean canRecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean canDecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean recolorItem(ItemStack aStack, int aRGB) {
        return false;
    }

    @Override
    public boolean decolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
    }

    @Override
    public int getLifeSpan(World aWorld, ItemStack aStack) {
        return 1728000;
    }

    @Override
    public int onDespawn(EntityItem aEntity, ItemStack aStack) {
        return 1728000;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mGold ? 2 : (this.mSilver ? 1 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        if (aData == 2) {
            this.mGold = true;
        }
        if (aData == 1) {
            this.mSilver = true;
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.certificate";
    }

    static {
        LH.add("gt.tooltip.certificate", "Certified Support of GregTech");
        sTextureBack = new Textures.BlockIcons.CustomIcon("certificate/BACK");
        sTextureSilver = new Textures.BlockIcons.CustomIcon("certificate/SILVER");
        sTextureGold = new Textures.BlockIcons.CustomIcon("certificate/GOLD");
    }
}

