/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase11MultiBlockConverter;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class MultiTileEntityLargeDynamo
extends TileEntityBase11MultiBlockConverter
implements ITileEntitySwitchableOnOff {
    public short mDynamoWalls = (short)18022;
    public ITileEntityUnloadable mEmitter = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.design")) {
            this.mDynamoWalls = aNBT.getShort("gt.design");
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tMinX = this.xCoord - (4 == this.mFacing ? 0 : (5 == this.mFacing ? 3 : 1));
        int tMinY = this.yCoord - (0 == this.mFacing ? 0 : (1 == this.mFacing ? 3 : 1));
        int tMinZ = this.zCoord - (2 == this.mFacing ? 0 : (3 == this.mFacing ? 3 : 1));
        int tMaxX = this.xCoord + (5 == this.mFacing ? 0 : (4 == this.mFacing ? 3 : 1));
        int tMaxY = this.yCoord + (1 == this.mFacing ? 0 : (0 == this.mFacing ? 3 : 1));
        int tMaxZ = this.zCoord + (3 == this.mFacing ? 0 : (2 == this.mFacing ? 3 : 1));
        int tOutX = this.getOffsetXN(this.mFacing, 3);
        int tOutY = this.getOffsetYN(this.mFacing, 3);
        int tOutZ = this.getOffsetZN(this.mFacing, 3);
        if (this.worldObj.blockExists(tMinX, tMinY, tMinZ) && this.worldObj.blockExists(tMaxX, tMaxY, tMaxZ)) {
            this.mEmitter = null;
            boolean tSuccess = true;
            for (int tX = tMinX; tX <= tMaxX; ++tX) {
                for (int tY = tMinY; tY <= tMaxY; ++tY) {
                    for (int tZ = tMinZ; tZ <= tMaxZ; ++tZ) {
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ, (CS.SIDES_AXIS_X[this.mFacing] ? tX != tMinX && tX != tMaxX : (CS.SIDES_AXIS_Z[this.mFacing] ? tZ != tMinZ && tZ != tMaxZ : tY != tMinY && tY != tMaxY)) ? 18040 : this.mDynamoWalls, this.getMultiTileEntityRegistryID(), tX == tOutX && tY == tOutY && tZ == tOutZ ? 2 : 0, tX == tOutX && tY == tOutY && tZ == tOutZ ? -2 : -1, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        return aX >= this.xCoord - (4 == this.mFacing ? 0 : (5 == this.mFacing ? 3 : 1)) && aY >= this.yCoord - (0 == this.mFacing ? 0 : (1 == this.mFacing ? 3 : 1)) && aZ >= this.zCoord - (2 == this.mFacing ? 0 : (3 == this.mFacing ? 3 : 1)) && aX <= this.xCoord + (5 == this.mFacing ? 0 : (4 == this.mFacing ? 3 : 1)) && aY <= this.yCoord + (1 == this.mFacing ? 0 : (0 == this.mFacing ? 3 : 1)) && aZ <= this.zCoord + (3 == this.mFacing ? 0 : (2 == this.mFacing ? 3 : 1));
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.dynamo.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.dynamo.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.dynamo.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public TileEntity getEmittingTileEntity() {
        if (this.mEmitter == null || this.mEmitter.isDead()) {
            this.mEmitter = null;
            TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(CS.OPOS[this.mFacing], 3);
            if (tTileEntity instanceof ITileEntityUnloadable) {
                this.mEmitter = (ITileEntityUnloadable)tTileEntity;
            }
        }
        return this.mEmitter == null ? this : (TileEntity)this.mEmitter;
    }

    @Override
    public byte getEmittingSide() {
        return CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.dynamo";
    }

    static {
        LH.add("gt.tooltip.multiblock.dynamo.1", "Two 3x3s with 2m inbetween made of the Block you crafted this of");
        LH.add("gt.tooltip.multiblock.dynamo.2", "a 3x3x2 of 18 Large Copper Coils inbetween");
        LH.add("gt.tooltip.multiblock.dynamo.3", "Main centered on one of the 3x3s facing outwards");
    }
}

