/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.redstone;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityRemoteActivateable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityButtonAdvanced
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
ITileEntityRemoteActivateable,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public boolean mActive = false;
    public boolean oActive = false;
    public boolean mInverted = false;
    public boolean mGlowInverted = false;
    public boolean mLampMode = false;
    public boolean mDoUnclickSound = false;
    public byte mStrength = (byte)15;
    public byte mType = 0;
    public byte mIndex = 0;
    public long mLength = 0L;
    public long mMaxLength = 20L;
    public static final IIconContainer[][][] sTextures = new IIconContainer[][][]{new IIconContainer[1][8], new IIconContainer[10][8], new IIconContainer[26][8], new IIconContainer[11][8], new IIconContainer[8][8], new IIconContainer[16][8], new IIconContainer[22][8]};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mInverted = aNBT.getBoolean("gt.mode");
        this.mLampMode = aNBT.getBoolean("gt.mode.lamp");
        this.mGlowInverted = aNBT.getBoolean("gt.visual");
        this.mActive = aNBT.getBoolean("gt.active");
        if (aNBT.hasKey("gt.progress")) {
            this.mLength = aNBT.getLong("gt.progress");
        }
        if (aNBT.hasKey("gt.maxprogress")) {
            this.mMaxLength = aNBT.getLong("gt.maxprogress");
        }
        if (aNBT.hasKey("gt.redstone")) {
            this.mStrength = aNBT.getByte("gt.redstone");
        }
        if (aNBT.hasKey("gt.texture.0")) {
            this.mType = aNBT.getByte("gt.texture.0");
        }
        if (aNBT.hasKey("gt.texture.1")) {
            this.mIndex = aNBT.getByte("gt.texture.1");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mInverted);
        UT.NBT.setBoolean(aNBT, "gt.mode.lamp", this.mLampMode);
        UT.NBT.setBoolean(aNBT, "gt.visual", this.mGlowInverted);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setNumber(aNBT, "gt.progress", this.mLength);
        if (this.mMaxLength != 20L) {
            aNBT.setLong("gt.maxprogress", this.mMaxLength);
        }
        if (this.mStrength != 15) {
            aNBT.setByte("gt.redstone", this.mStrength);
        }
        if (this.mType != 0) {
            aNBT.setByte("gt.texture.0", this.mType);
        }
        if (this.mIndex != 0) {
            aNBT.setByte("gt.texture.1", this.mIndex);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mInverted);
        UT.NBT.setBoolean(aNBT, "gt.mode.lamp", this.mLampMode);
        UT.NBT.setBoolean(aNBT, "gt.visual", this.mGlowInverted);
        if (this.mMaxLength != 20L) {
            aNBT.setLong("gt.maxprogress", this.mMaxLength);
        }
        if (this.mStrength != 15) {
            aNBT.setByte("gt.redstone", this.mStrength);
        }
        if (this.mType != 0) {
            aNBT.setByte("gt.texture.0", this.mType);
        }
        if (this.mIndex != 0) {
            aNBT.setByte("gt.texture.1", this.mIndex);
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.cutter.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.chisel.to.switch.design"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.tool.hint.use.sneak"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("chisel")) {
            if (aSneaking) {
                this.mType = (byte)((this.mType + 1) % sTextures.length);
                this.mIndex = 0;
            } else {
                this.mIndex = (byte)((this.mIndex + 1) % sTextures[this.mType].length);
            }
            this.updateClientData();
            return 100L;
        }
        if (aTool.equals("screwdriver")) {
            this.mMaxLength = aSneaking ? (this.mMaxLength += 20L) : ++this.mMaxLength;
            if (aChatReturn != null) {
                aChatReturn.add("Signal Length = " + Math.abs(this.mMaxLength));
            }
            return 100L;
        }
        if (aTool.equals("cutter")) {
            if (aSneaking) {
                this.mStrength = (byte)(this.mStrength - 1);
                if (this.mStrength <= 0) {
                    this.mStrength = (byte)15;
                }
            } else {
                this.mStrength = (byte)(this.mStrength % 15);
                this.mStrength = (byte)(this.mStrength + 1);
            }
            if (aChatReturn != null) {
                aChatReturn.add("Signal Strength = " + this.mStrength);
            }
            this.causeBlockUpdate();
            return 100L;
        }
        if (aTool.equals("softhammer")) {
            if (aSneaking) {
                boolean bl = this.mGlowInverted = !this.mGlowInverted;
                if (aChatReturn != null) {
                    aChatReturn.add(this.mGlowInverted ? "Glows when unpressed!" : "Glows when pressed!");
                }
                this.updateClientData();
                return 1000L;
            }
            this.mInverted = !this.mInverted;
            boolean bl = this.mActive = !this.mActive;
            if (aChatReturn != null) {
                aChatReturn.add(this.mInverted ? "Emits when unpressed!" : "Emits when pressed!");
            }
            this.updateClientData();
            this.causeBlockUpdate();
            return 1000L;
        }
        if (aTool.equals("monkeywrench")) {
            if (this.mLampMode) {
                this.mLampMode = false;
            } else if (this.mMaxLength > 0L) {
                if (aSneaking) {
                    this.mLampMode = true;
                }
                this.mMaxLength = 0L;
            } else {
                this.mMaxLength = aSneaking ? 20L : 1L;
            }
            if (aChatReturn != null) {
                aChatReturn.add(this.mLampMode ? "Lamp Mode" : (this.mMaxLength > 0L ? "Button Mode" : "Switch Mode"));
            }
            return 1000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Signal Strength = " + this.mStrength);
                if (this.mMaxLength > 0L) {
                    aChatReturn.add("Signal Length = " + Math.abs(this.mMaxLength));
                }
                aChatReturn.add(this.mLampMode ? "Lamp Mode" : (this.mMaxLength > 0L ? "Button Mode" : "Switch Mode"));
                aChatReturn.add(this.mInverted ? "Emits when unpressed!" : "Emits when pressed!");
                aChatReturn.add(this.mGlowInverted ? "Glows when unpressed!" : "Glows when pressed!");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && !this.mLampMode) {
            if (this.mMaxLength > 0L) {
                this.mLength = this.mMaxLength;
                this.mActive = !this.mInverted;
            } else {
                this.mActive = !this.mActive;
            }
            this.causeBlockUpdate();
            UT.Sounds.send("random.click", 1.0f, this.mActive ? 1.5f : 1.3f, this, false);
            this.mDoUnclickSound = true;
        }
        return !this.mLampMode;
    }

    @Override
    public boolean remoteActivate() {
        if (this.isServerSide() && !this.mLampMode) {
            if (this.mMaxLength > 0L) {
                this.mLength = this.mMaxLength;
                this.mActive = !this.mInverted;
            } else {
                this.mActive = !this.mActive;
            }
            this.causeBlockUpdate();
            this.mDoUnclickSound = false;
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mLampMode) {
                if (this.mBlockUpdated) {
                    this.mActive = this.hasRedstoneIncoming();
                }
            } else if (this.mActive != this.mInverted && this.mMaxLength > 0L && --this.mLength < 0L) {
                this.mActive = this.mInverted;
                this.causeBlockUpdate();
                if (this.mDoUnclickSound) {
                    UT.Sounds.send("random.click", 1.0f, this.mActive ? 1.5f : 1.3f, this, false);
                }
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mActive != this.oActive;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oActive = this.mActive;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return this.mActive && !this.mLampMode ? this.mStrength : (byte)0;
    }

    @Override
    public byte isProvidingStrongPower2(byte aSide) {
        return aSide == this.mFacing && this.mActive && !this.mLampMode ? this.mStrength : (byte)0;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData(), this.getDirectionData(), this.mType, this.mIndex) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setVisualData(aData[3]);
        this.setDirectionData(aData[4]);
        this.mType = aData[5];
        this.mIndex = aData[6];
        if (this.mType < 0 || this.mIndex < 0 || this.mType >= sTextures.length || this.mIndex >= sTextures[this.mType].length) {
            this.mIndex = 0;
            this.mType = 0;
        }
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? 14 : (5 == this.mFacing ? 0 : 4)], CS.PX_P[0 == this.mFacing ? 14 : (1 == this.mFacing ? 0 : 4)], CS.PX_P[2 == this.mFacing ? 14 : (3 == this.mFacing ? 0 : 4)], CS.PX_N[5 == this.mFacing ? 14 : (4 == this.mFacing ? 0 : 4)], CS.PX_N[1 == this.mFacing ? 14 : (0 == this.mFacing ? 0 : 4)], CS.PX_N[3 == this.mFacing ? 14 : (2 == this.mFacing ? 0 : 4)]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide] && aSide == CS.OPOS[this.mFacing]) {
            return null;
        }
        byte tOffset = (byte)(this.mActive == this.mGlowInverted ? 0 : 4);
        return BlockTextureMulti.get(BlockTextureDefault.get(sTextures[this.mType][this.mIndex][tOffset + 0], this.mRGBa), BlockTextureDefault.get(sTextures[this.mType][this.mIndex][tOffset + 1]), BlockTextureDefault.get(sTextures[this.mType][this.mIndex][tOffset + 2], this.mRGBa, false, true, true, false), BlockTextureDefault.get(sTextures[this.mType][this.mIndex][tOffset + 3], CS.UNCOLOURED, false, true, true, false));
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? 14 : (5 == this.mFacing ? 0 : 4)], CS.PX_P[0 == this.mFacing ? 14 : (1 == this.mFacing ? 0 : 4)], CS.PX_P[2 == this.mFacing ? 14 : (3 == this.mFacing ? 0 : 4)], CS.PX_N[5 == this.mFacing ? 14 : (4 == this.mFacing ? 0 : 4)], CS.PX_N[1 == this.mFacing ? 14 : (0 == this.mFacing ? 0 : 4)], CS.PX_N[3 == this.mFacing ? 14 : (2 == this.mFacing ? 0 : 4)]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? 14 : (5 == this.mFacing ? 0 : 4)], CS.PX_P[0 == this.mFacing ? 14 : (1 == this.mFacing ? 0 : 4)], CS.PX_P[2 == this.mFacing ? 14 : (3 == this.mFacing ? 0 : 4)], CS.PX_N[5 == this.mFacing ? 14 : (4 == this.mFacing ? 0 : 4)], CS.PX_N[1 == this.mFacing ? 14 : (0 == this.mFacing ? 0 : 4)], CS.PX_N[3 == this.mFacing ? 14 : (2 == this.mFacing ? 0 : 4)]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PX_P[14] : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PX_P[14] : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? CS.PX_N[1] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public byte getVisualData() {
        return (byte)((this.mActive ? 1 : 0) | (this.mInverted ? 2 : 0) | (this.mGlowInverted ? 4 : 0) | (this.mLampMode ? 8 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActive = (aData & 1) != 0;
        this.mInverted = (aData & 2) != 0;
        this.mGlowInverted = (aData & 4) != 0;
        this.mLampMode = (aData & 8) != 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.button.advanced";
    }

    static {
        for (int i = 0; i < sTextures.length; ++i) {
            for (int j = 0; j < sTextures[i].length; ++j) {
                MultiTileEntityButtonAdvanced.sTextures[i][j][0] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/colored_off");
                MultiTileEntityButtonAdvanced.sTextures[i][j][1] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/overlay_off");
                MultiTileEntityButtonAdvanced.sTextures[i][j][2] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/glowing_off");
                MultiTileEntityButtonAdvanced.sTextures[i][j][3] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/glowverlay_off");
                MultiTileEntityButtonAdvanced.sTextures[i][j][4] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/colored_on");
                MultiTileEntityButtonAdvanced.sTextures[i][j][5] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/overlay_on");
                MultiTileEntityButtonAdvanced.sTextures[i][j][6] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/glowing_on");
                MultiTileEntityButtonAdvanced.sTextures[i][j][7] = new Textures.BlockIcons.CustomIcon("machines/redstone/buttons/advanced/" + i + "/" + j + "/glowverlay_on");
            }
        }
    }
}

