/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tanks;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.tank.TileEntityBase09FluidContainerSmall;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityBarometerGasCylinder
extends TileEntityBase09FluidContainerSmall {
    public long mCapacity = 8000L;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/colored/sides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/colored/bottom");
    public static IIconContainer sTextureBarometer = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/colored/barometer");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/overlay/sides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/overlay/bottom");
    public static IIconContainer sOverlayBarometer = new Textures.BlockIcons.CustomIcon("machines/tanks/barometer_gas_cylinder/overlay/barometer");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mCapacity = this.mTank.capacity();
        if (aNBT.hasKey("gt.mode")) {
            this.mTank.setCapacity(aNBT.getLong("gt.mode"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        if (this.mCapacity != this.mTank.capacity()) {
            UT.NBT.setNumber(aNBT, "gt.mode", this.mTank.capacity());
        }
        super.writeToNBT2(aNBT);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mCapacity != this.mTank.capacity()) {
            UT.NBT.setNumber(aNBT, "gt.mode", this.mTank.capacity());
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.nogui.rightclick.tank.limit"));
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer.getCurrentEquippedItem() == null && CS.SIDES_HORIZONTAL[aSide]) {
            if (this.isClientSide()) {
                return true;
            }
            if (aHitY > CS.PX_P[8]) {
                if (aHitY > CS.PX_P[12]) {
                    if (aHitY > CS.PX_P[14]) {
                        this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 50 : 500)));
                    } else {
                        this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 10 : 100)));
                    }
                } else if (aHitY > CS.PX_P[10]) {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 5 : 50)));
                } else {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 1 : 10)));
                }
            } else if (aHitY > CS.PX_P[4]) {
                if (aHitY > CS.PX_P[6]) {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 1 : 10)));
                } else {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 5 : 50)));
                }
            } else if (aHitY > CS.PX_P[2]) {
                this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 10 : 100)));
            } else {
                this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 50 : 500)));
            }
            UT.Entities.sendchat((Object)aPlayer, "Limit: " + this.mTank.capacity() + "L");
            return true;
        }
        return super.onBlockActivated3(aPlayer, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 5;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[4], CS.PX_P[0], CS.PX_P[5], CS.PX_N[4], CS.PX_P[8], CS.PX_N[5]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[4], CS.PX_N[5], CS.PX_P[8], CS.PX_N[4]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[8], CS.PX_P[5], CS.PX_N[5], CS.PX_P[9], CS.PX_N[5]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[7], CS.PX_P[9], CS.PX_P[7], CS.PX_N[7], CS.PX_P[16], CS.PX_N[7]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[10], CS.PX_P[6], CS.PX_N[6], CS.PX_P[14], CS.PX_N[6]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass > 2 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBarometer, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayBarometer)) : (CS.SIDES_HORIZONTAL[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides)) : (CS.SIDES_TOP[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayTop)) : (aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayBottom)) : null)));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[0], CS.PX_N[4]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[0], CS.PX_N[4]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[0], CS.PX_N[4]);
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.0f : CS.PX_P[4];
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.barometer.gas.cylinder";
    }
}

