/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenSticks
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenSticks(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        if (WD.dimBTL(aWorld) || WD.dimAETHER(aWorld)) {
            return this.mAmount * 2;
        }
        int tCount = 0;
        for (String tName : aBiomeNames) {
            if (CS.BIOMES_WOODS.contains(tName) || CS.BIOMES_SWAMP.contains(tName)) {
                return this.mAmount * 3;
            }
            if (tCount < 2 && (CS.BIOMES_RIVER.contains(tName) || CS.BIOMES_PLAINS.contains(tName) || CS.BIOMES_SAVANNA.contains(tName) || "Wasteland Forest".equalsIgnoreCase(tName))) {
                tCount = 2;
                continue;
            }
            if (tCount >= 1 || !CS.BIOMES_TAIGA.contains(tName) && !CS.BIOMES_MESA.contains(tName) && !CS.BIOMES_WASTELANDS.contains(tName)) continue;
            tCount = 1;
        }
        return this.mAmount * tCount;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        if (aContact.getMaterial() != Material.grass && aContact.getMaterial() != Material.ground) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        if (WD.easyRep(aWorld, aX, aY + 1, aZ)) {
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY + 1, aZ, (byte)6, (short)32756, null, false, true);
        }
        return false;
    }
}

