/**
 * Copyright (c) 2023 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregapi.data;

import gregapi.oredict.OreDictMaterial;
import gregapi.render.TextureSet;

import static gregapi.data.TD.Atomic.*;
import static gregapi.data.TD.ItemGenerator.*;
import static gregapi.data.TD.Processing.*;
import static gregapi.data.TD.Properties.MAGICAL;
import static gregapi.render.TextureSet.*;

/**
 * @author Gregorius Techneticies
 * 
 * List of all Anti-Materials. The Short Name is for ease of overview and stands for "AntiMatter".
 * 
 * Note: I wrote those shortcuts not only because of overview Reasons. I have hit the 65536 Limit of the static initialiser multiple times now.
 */
public class AM {
	/** Making the Table a little bit more overseeable */
	static OreDictMaterial create       (int aID, String aNameOreDict) {return OreDictMaterial.createMaterial(aID, aNameOreDict, aNameOreDict).put(ANTIMATTER, MD.GAPI).aspects(TC.PERDITIO, 1).visDefault();}
	static OreDictMaterial element      (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return create      (aID, aNameOreDict).setStats(aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter).setTextures(aSets).setRGBa(aR, aG, aB, aA).put(ELEMENT);}
	static OreDictMaterial metal        (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return element     (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(METAL);}
	static OreDictMaterial metalloid    (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return element     (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(METALLOID);}
	static OreDictMaterial nonmetal     (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return element     (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(NONMETAL);}
	static OreDictMaterial diatomic     (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return nonmetal    (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(DIATOMIC_NONMETAL);}
	static OreDictMaterial polyatomic   (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return nonmetal    (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(POLYATOMIC_NONMETAL);}
	static OreDictMaterial noblegas     (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return nonmetal    (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(NOBLE_GAS);}
	static OreDictMaterial alkali       (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(ALKALI_METAL);}
	static OreDictMaterial alkaline     (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(ALKALINE_EARTH_METAL);}
	static OreDictMaterial lanthanide   (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(LANTHANIDE);}
	static OreDictMaterial actinide     (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(ACTINIDE);}
	static OreDictMaterial transmetal   (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(TRANSITION_METAL);}
	static OreDictMaterial posttrans    (int aID, String aNameOreDict, long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter, TextureSet[] aSets, long aR, long aG, long aB, long aA)   {return metal       (aID, aNameOreDict, aProtonsAndElectrons, aNeutrons, aMeltingPoint, aBoilingPoint, aGramPerCubicCentimeter, aSets, aR, aG, aB, aA).put(POST_TRANSITION_METAL);}
	
	/** Some subatomic Anti-Particles, this might be useful if Projectile Materials have to be determined and you shoot a Laser (Photons in that case) or something Radioactive. */
	public static final OreDictMaterial
	y       , Photon                =   y       = create( 4001, "Anti-Photon"   ).setStatsElement(0,0,0,0,0).heat(0,0,0).setRGBa(  0,   0,   0,   0).setTextures(SET_NONE).put(PARTICLE),
	v       , Neutrino              =   v       = create( 4002, "Anti-Neutrino" ).setStatsElement(0,0,0,0,0).heat(0,0,0).setRGBa( 75,  75,  75,   0).setTextures(SET_NONE).put(PARTICLE),
	n       , Neutron               =   n       = create( 4003, "Anti-Neutron"  ).setStatsElement(0,0,1,0,0).heat(0,0,0).setRGBa(128, 128, 128,   0).setTextures(SET_NONE).put(PARTICLE),
	p       , Proton                =   p       = create( 4004, "Anti-Proton"   ).setStatsElement(1,0,0,0,0).heat(0,0,0).setRGBa(  0,   0, 255,   0).setTextures(SET_NONE).put(PARTICLE),
	e       , Positron              =   e       = create( 4005, "Positron"      ).setStatsElement(0,1,0,0,0).heat(0,0,0).setRGBa(255,   0,   0,   0).setTextures(SET_NONE).put(PARTICLE), Electron = e.addIdenticalNames("AntiElectron");
	
	/**
	 * All the Anti-Elements and a few of their Isotopes.
	 * 
	 * in setStatsEnergetic I guessed some of the Values, because they were not listed in Wikipedia at that time.
	 * Those guessed Values are postfixed with an empty Space.
	 */
	public static final OreDictMaterial
	H       , Hydrogen              =   H       = diatomic      ( 4010, "Anti-Hydrogen"         ,   1,   0,    14,    20,  0.00008988, SET_DULL             ,   0,   0, 255,  15).put(  CONTAINERS_GAS              , UUM                                               ).aspects(  TC.AQUA, 1                                                          ),
	D       , Deuterium             =   D       = diatomic      ( 4011, "Anti-Deuterium"        ,   1,   1,    14,    20,  0.00008988, SET_SHINY            , 255, 255,   0,  15).put(  CONTAINERS_GAS                                                                  ).aspects(  TC.AQUA, 2                                                          ), H_2=D,
	T       , Tritium               =   T       = diatomic      ( 4012, "Anti-Tritium"          ,   1,   2,    14,    20,  0.00008988, SET_SHINY            , 255,   0,   0,  15).put(  CONTAINERS_GAS                                                                  ).aspects(  TC.AQUA, 3                                                          ), H_3=T,
	He      , Helium                =   He      = noblegas      ( 4020, "Anti-Helium"           ,   2,   2,     1,     4,  0.0001785 , SET_SHINY            , 255, 255, 120,  15).put(  CONTAINERS_GAS              , FUSION, UUM                                       ).aspects(  TC.AER, 2                                                           ),
	He_3    , Helium3               =   He_3    = noblegas      ( 4021, "Anti-Helium-3"         ,   2,   1,     1,     4,  0.0001785 , SET_SHINY            , 255, 255, 140,  15).put(  CONTAINERS_GAS              , FUSION                                            ).aspects(  TC.AER, 3                                                           ),
	Li      , Lithium               =   Li      = alkali        ( 4030, "Anti-Lithium"          ,   3,   4,   453,  1560,  0.534     , SET_ROUGH            , 225, 220, 255, 255).put(  G_DUST_ORES                 , FUSION, UUM                                       ).aspects(  TC.VITREUS, 1, TC.POTENTIA, 2                                       ),
	Li_6    , Lithium6              =   Li_6    = alkali        ( 4031, "Anti-Lithium-6"        ,   3,   3,   453,  1560,  0.534     , SET_ROUGH            , 230, 225, 255, 255).put(  G_DUST_ORES                 , FUSION                                            ).aspects(  TC.VITREUS, 1, TC.POTENTIA, 1, TC.RADIO, 1                          ),
	Be      , Beryllium             =   Be      = alkaline      ( 4040, "Anti-Beryllium"        ,   4,   5,  1560,  2742,  1.85      , SET_METALLIC         , 100, 180, 100, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.LUCRUM, 1                                        ),
	B       , Boron                 =   B       = metalloid     ( 4050, "Anti-Boron"            ,   5,   5,  2349,  4200,  2.34      , SET_DULL             , 250, 250, 250, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 1, TC.VITREUS, 1, TC.ELECTRUM, 1                       ),
	C       , Carbon                =   C       = polyatomic    ( 4060, "Anti-Carbon"           ,   6,   6,  3800,  4300,  2.267     , SET_DULL             ,  20,  20,  20, 255).put(  G_DUST_ORES                 , FUSION, UUM                                       ).aspects(  TC.VITREUS, 1, TC.IGNIS, 1                                          ),
	C_13    , Carbon13              =   C_13    = polyatomic    ( 4061, "Anti-Carbon-13"        ,   6,   7,  3800,  4300,  2.267     , SET_DULL             ,  25,  25,  25, 255).put(  G_DUST_ORES                 , FUSION                                            ).aspects(  TC.VITREUS, 1, TC.IGNIS, 1, TC.RADIO, 1                             ),
	C_14    , Carbon14              =   C_14    = polyatomic    ( 4062, "Anti-Carbon-14"        ,   6,   8,  3800,  4300,  2.267     , SET_DULL             ,  30,  30,  30, 255).put(  G_DUST_ORES                 , FUSION                                            ).aspects(  TC.VITREUS, 1, TC.IGNIS, 1, TC.RADIO, 1                             ),
	N       , Nitrogen              =   N       = diatomic      ( 4070, "Anti-Nitrogen"         ,   7,   7,    63,    77,  0.0012506 , SET_DULL             ,   0, 150, 200,  15).put(  CONTAINERS_GAS              , FUSION, UUM                                       ).aspects(  TC.AER, 1                                                           ),
	O       , Oxygen                =   O       = diatomic      ( 4080, "Anti-Oxygen"           ,   8,   8,    54,    90,  0.001429  , SET_DULL             ,   0, 100, 200,  15).put(  CONTAINERS_GAS              , FUSION, UUM                                       ).aspects(  TC.AER, 1                                                           ),
	F       , Fluorine              =   F       = diatomic      ( 4090, "Anti-Fluorine"         ,   9,   9,    53,    85,  0.001696  , SET_DULL             ,  64, 192,   0, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.PERDITIO, 2                                                      ),
	Ne      , Neon                  =   Ne      = noblegas      ( 4100, "Anti-Neon"             ,  10,  10,    24,    27,  0.0008999 , SET_SHINY            , 250, 180, 180,  15).put(  CONTAINERS_GAS              , FUSION, UUM                                       ).aspects(  TC.AER, 3                                                           ),
	Na      , Sodium                =   Na      = alkali        ( 4110, "Anti-Sodium"           ,  11,  11,   370,  1156,  0.971     , SET_ROUGH            ,   0,   0, 150, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.VITREUS, 2, TC.LUX, 1                                            ), Natrium=Na.addIdenticalNames("Anti-Natrium"),
	Mg      , Magnesium             =   Mg      = alkaline      ( 4120, "Anti-Magnesium"        ,  12,  12,   923,  1363,  1.738     , SET_METALLIC         , 255, 200, 200, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.SANO, 1                                          ),
	Al      , Aluminium             =   Al      = posttrans     ( 4130, "Anti-Aluminium"        ,  13,  13,   933,  2792,  2.698     , SET_METALLIC         , 128, 200, 240, 255).put(  G_INGOT_MACHINE_ORES        , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.VOLATUS, 1                                       ), Aluminum=Al.addIdenticalNames("Anti-Aluminum"),
	Si      , Silicon               =   Si      = metalloid     ( 4140, "Anti-Silicon"          ,  14,  14,  1687,  3538,  2.3296    , SET_METALLIC         ,  60,  60,  80, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.TENEBRAE, 1                                      ),
	P       , Phosphor              =   P       = polyatomic    ( 4150, "Anti-Phosphor"         ,  15,  15,   317,   550,  1.82      , SET_ROUGH            , 255, 255,   0, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.IGNIS, 2, TC.POTENTIA, 1                                         ),
	S       , Sulfur                =   S       = polyatomic    ( 4160, "Anti-Sulfur"           ,  16,  16,   388,   717,  2.067     , SET_ROUGH            , 200, 200,   0, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.IGNIS, 1                                                         ),
	Cl      , Chlorine              =   Cl      = diatomic      ( 4170, "Anti-Chlorine"         ,  17,  18,   171,   239,  0.003214  , SET_DULL             ,   0, 240, 255, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.AQUA, 2, TC.PANNUS, 1                                            ),
	Ar      , Argon                 =   Ar      = noblegas      ( 4180, "Anti-Argon"            ,  18,  22,    83,    87,  0.0017837 , SET_SHINY            ,   0, 255,   0,  15).put(  CONTAINERS_GAS              , FUSION, UUM                                       ).aspects(  TC.AER, 3                                                           ),
	K       , Potassium             =   K       = alkali        ( 4190, "Anti-Potassium"        ,  19,  20,   336,  1032,  0.862     , SET_ROUGH            , 250, 250, 250, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.VITREUS, 1, TC.POTENTIA, 1                                       ), Kalium=K.addIdenticalNames("Anti-Kalium"),
	Ca      , Calcium               =   Ca      = alkaline      ( 4200, "Anti-Calcium"          ,  20,  20,  1115,  1757,  1.54      , SET_METALLIC         , 255, 245, 245, 255).put(  G_CRYSTAL_ORES              , FUSION, UUM                                       ).aspects(  TC.SANO, 1, TC.TUTAMEN, 1                                           ),
	Sc      , Scandium              =   Sc      = transmetal    ( 4210, "Anti-Scandium"         ,  21,  24,  1814,  3109,  2.989     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.GELUM, 1                                         ),
	Ti      , Titanium              =   Ti      = transmetal    ( 4220, "Anti-Titanium"         ,  22,  26,  1941,  3560,  4.54      , SET_METALLIC         , 220, 160, 240, 255).put(  G_INGOT_MACHINE_ORES        , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.TUTAMEN, 1                                       ), Titan=Ti.addIdenticalNames("Anti-Titan"),
	V       , Vanadium              =   V       = transmetal    ( 4230, "Anti-Vanadium"         ,  23,  28,  2183,  3680,  6.11      , SET_METALLIC         ,  50,  50,  50, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.ELECTRUM, 1                                      ),
	Cr      , Chromium              =   Cr      = transmetal    ( 4240, "Anti-Chromium"         ,  24,  28,  2180,  2944,  7.15      , SET_SHINY            , 255, 230, 230, 255).put(  G_INGOT_MACHINE_ORES        , FUSION, UUM                                       ).aspects(  TC.METALLUM, 2, TC.MACHINA, 1                                       ), Chrome=Cr.addIdenticalNames("Anti-Chrome"),
	Mn      , Manganese             =   Mn      = transmetal    ( 4250, "Anti-Manganese"        ,  25,  30,  1519,  2334,  7.44      , SET_DULL             , 250, 250, 250, 255).put(  G_INGOT_ORES                , FUSION, UUM                                       ).aspects(  TC.METALLUM, 3                                                      ),
	Fe      , Iron                  =   Fe      = transmetal    ( 4260, "Anti-Iron"             ,  26,  30,  1811,  3134,  7.874     , SET_METALLIC         , 200, 200, 200, 255).put(  G_INGOT_MACHINE_ORES        , FUSION, UUM                                       ).aspects(  TC.METALLUM, 3                                                      ),
	Co      , Cobalt                =   Co      = transmetal    ( 4270, "Anti-Cobalt"           ,  27,  32,  1768,  3200,  8.86      , SET_METALLIC         ,  80,  80, 250, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.INSTRUMENTUM, 1                                  ),
	Co_60   , Cobalt60              =   Co_60   = transmetal    ( 4278, "Anti-Cobalt-60"        ,  27,  43,  1768,  3200,  8.86      , SET_SHINY            ,  90,  90, 250, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.INSTRUMENTUM, 1, TC.RADIO, 1                     ),
	Ni      , Nickel                =   Ni      = transmetal    ( 4280, "Anti-Nickel"           ,  28,  30,  1728,  3186,  8.912     , SET_METALLIC         , 200, 200, 250, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.IGNIS, 1                                         ),
	Cu      , Copper                =   Cu      = transmetal    ( 4290, "Anti-Copper"           ,  29,  34,  1357,  2835,  8.96      , SET_SHINY            , 255, 100,   0, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.PERMUTATIO, 1                                    ),
	Zn      , Zinc                  =   Zn      = transmetal    ( 4300, "Anti-Zinc"             ,  30,  35,   692,  1180,  7.134     , SET_METALLIC         , 250, 240, 240, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.SANO, 1                                          ),
	Ga      , Gallium               =   Ga      = posttrans     ( 4310, "Anti-Gallium"          ,  31,  39,   302,  2477,  5.907     , SET_DULL             , 220, 220, 255, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.ELECTRUM, 1                                      ),
	Ge      , Germanium             =   Ge      = metalloid     ( 4320, "Anti-Germanium"        ,  32,  40,  1211,  3106,  5.323     , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.ELECTRUM, 1                                      ),
	As      , Arsenic               =   As      = metalloid     ( 4330, "Anti-Arsenic"          ,  33,  42,   887,  1090,  5.776     , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 1, TC.VENEMUM, 2                                       ),
	Se      , Selenium              =   Se      = polyatomic    ( 4340, "Anti-Selenium"         ,  34,  45,   453,   958,  4.809     , SET_DULL             , 256, 256, 256, 255).put(  G_CRYSTAL_ORES              , UUM                                               ).aspects(  TC.VITREUS, 1, TC.SPIRITUS, 2                                       ),
	Br      , Bromine               =   Br      = diatomic      ( 4350, "Anti-Bromine"          ,  35,  45,   265,   332,  3.122     , SET_DULL             , 256, 256, 256, 255).put(  G_CRYSTAL_ORES              , UUM                                               ).aspects(  TC.VITREUS, 1, TC.TERRA, 2                                          ),
	Kr      , Krypton               =   Kr      = noblegas      ( 4360, "Anti-Krypton"          ,  36,  48,   115,   119,  0.003733  , SET_DIAMOND          , 128, 255, 128,  15).put(  CONTAINERS_GAS              , UUM                                               ).aspects(  TC.AER, 3                                                           ),
	Rb      , Rubidium              =   Rb      = alkali        ( 4370, "Anti-Rubidium"         ,  37,  48,   312,   961,  1.532     , SET_SHINY            , 240,  30,  30, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.VITREUS, 1                                       ),
	Sr      , Strontium             =   Sr      = alkaline      ( 4380, "Anti-Strontium"        ,  38,  49,  1050,  1655,  2.64      , SET_METALLIC         , 200, 200, 200, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.STRONTIO, 1                                      ),
	Y       , Yttrium               =   Y       = transmetal    ( 4390, "Anti-Yttrium"          ,  39,  50,  1799,  3609,  4.469     , SET_METALLIC         , 220, 250, 220, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Zr      , Zirconium             =   Zr      = transmetal    ( 4400, "Anti-Zirconium"        ,  40,  51,  2128,  4682,  6.506     , SET_DIAMOND          , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.VITREUS, 1                                       ),
	Nb      , Niobium               =   Nb      = transmetal    ( 4410, "Anti-Niobium"          ,  41,  53,  2750,  5017,  8.57      , SET_METALLIC         , 190, 180, 200, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.IGNIS, 1                                         ),
	Mo      , Molybdenum            =   Mo      = transmetal    ( 4420, "Anti-Molybdenum"       ,  42,  53,  2896,  4912, 10.22      , SET_SHINY            , 180, 180, 220, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.INSTRUMENTUM, 1                                  ),
	Tc      , Technetium            =   Tc      = transmetal    ( 4430, "Anti-Technetium"       ,  43,  55,  2430,  4538, 11.5       , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ), Gregorium=Tc.addIdenticalNames("Anti-Gregorium"),
	Ru      , Ruthenium             =   Ru      = transmetal    ( 4440, "Anti-Ruthenium"        ,  44,  57,  2607,  4423, 12.37      , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Rh      , Rhodium               =   Rh      = transmetal    ( 4450, "Anti-Rhodium"          ,  45,  58,  2237,  3968, 12.41      , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Pd      , Palladium             =   Pd      = transmetal    ( 4460, "Anti-Palladium"        ,  46,  60,  1828,  3236, 12.02      , SET_SHINY            , 128, 128, 128, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Ag      , Silver                =   Ag      = transmetal    ( 4470, "Anti-Silver"           ,  47,  60,  1234,  2435, 10.501     , SET_SHINY            , 220, 220, 255, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.LUCRUM, 1                                        ),
	Cd      , Cadmium               =   Cd      = transmetal    ( 4480, "Anti-Cadmium"          ,  48,  64,   594,  1040,  8.69      , SET_SHINY            ,  50,  50,  60, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 1, TC.POTENTIA, 1, TC.VENEMUM, 1                       ),
	In      , Indium                =   In      = posttrans     ( 4490, "Anti-Indium"           ,  49,  65,   429,  2345,  7.31      , SET_SHINY            ,  64,   0, 128, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Sn      , Tin                   =   Sn      = posttrans     ( 4500, "Anti-Tin"              ,  50,  68,   505,  2875,  7.287     , SET_DULL             , 220, 220, 220, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.VITREUS, 1                                       ),
	Sb      , Antimony              =   Sb      = metalloid     ( 4510, "Anti-Antimony"         ,  51,  70,   903,  1860,  6.685     , SET_SHINY            , 220, 220, 240, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.AQUA, 1                                          ),
	Te      , Tellurium             =   Te      = metalloid     ( 4520, "Anti-Tellurium"        ,  52,  75,   722,  1261,  6.232     , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.ELECTRUM, 1                                      ),
	I       , Iodine                =   I       = diatomic      ( 4530, "Anti-Iodine"           ,  53,  74,   386,   457,  4.93      , SET_DULL             , 255, 240, 240, 255).put(  G_CRYSTAL_ORES              , UUM                                               ).aspects(  TC.VITREUS, 2, TC.AQUA, 1                                           ),
	Xe      , Xenon                 =   Xe      = noblegas      ( 4540, "Anti-Xenon"            ,  54,  77,   161,   165,  0.005887  , SET_DULL             ,   0, 255, 255,  15).put(  CONTAINERS_GAS              , UUM                                               ).aspects(  TC.AER, 3                                                           ),
	Cs      , Caesium               =   Cs      = alkali        ( 4550, "Anti-Caesium"          ,  55,  77,   301,   944,  1.873     , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Ba      , Barium                =   Ba      = alkaline      ( 4560, "Anti-Barium"           ,  56,  81,  1000,  2170,  3.594     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.VINCULUM, 3                                                      ),
	La      , Lanthanum             =   La      = lanthanide    ( 4570, "Anti-Lanthanum"        ,  57,  81,  1193,  3737,  6.145     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Ce      , Cerium                =   Ce      = lanthanide    ( 4580, "Anti-Cerium"           ,  58,  82,  1068,  3716,  6.77      , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Pr      , Praseodymium          =   Pr      = lanthanide    ( 4590, "Anti-Praseodymium"     ,  59,  81,  1208,  3793,  6.773     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Nd      , Neodymium             =   Nd      = lanthanide    ( 4600, "Anti-Neodymium"        ,  60,  84,  1297,  3347,  7.007     , SET_SHINY            , 100, 100, 100, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.MAGNETO, 2                                       ),
	Pm      , Promethium            =   Pm      = lanthanide    ( 4610, "Anti-Promethium"       ,  61,  83,  1315,  3273,  7.26      , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Sm      , Samarium              =   Sm      = lanthanide    ( 4620, "Anti-Samarium"         ,  62,  88,  1345,  2067,  7.52      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Eu      , Europium              =   Eu      = lanthanide    ( 4630, "Anti-Europium"         ,  63,  88,  1099,  1802,  5.243     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Gd      , Gadolinium            =   Gd      = lanthanide    ( 4640, "Anti-Gadolinium"       ,  64,  93,  1585,  3546,  7.895     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Tb      , Terbium               =   Tb      = lanthanide    ( 4650, "Anti-Terbium"          ,  65,  93,  1629,  3503,  8.229     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Dy      , Dysprosium            =   Dy      = lanthanide    ( 4660, "Anti-Dysprosium"       ,  66,  96,  1680,  2840,  8.55      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Ho      , Holmium               =   Ho      = lanthanide    ( 4670, "Anti-Holmium"          ,  67,  97,  1734,  2993,  8.795     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Er      , Erbium                =   Er      = lanthanide    ( 4680, "Anti-Erbium"           ,  68,  99,  1802,  3141,  9.066     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Tm      , Thulium               =   Tm      = lanthanide    ( 4690, "Anti-Thulium"          ,  69,  99,  1818,  2223,  9.321     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Yb      , Ytterbium             =   Yb      = lanthanide    ( 4700, "Anti-Ytterbium"        ,  70, 103,  1097,  1469,  6.965     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Lu      , Lutetium              =   Lu      = lanthanide    ( 4710, "Anti-Lutetium"         ,  71, 103,  1925,  3675,  9.84      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Hf      , Hafnium               =   Hf      = transmetal    ( 4720, "Anti-Hafnium"          ,  72, 106,  2506,  4876, 13.31      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Ta      , Tantalum              =   Ta      = transmetal    ( 4730, "Anti-Tantalum"         ,  73, 107,  3290,  5731, 16.654     , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.VINCULUM, 1                                      ),
	W       , Tungsten              =   W       = transmetal    ( 4740, "Anti-Tungsten"         ,  74, 109,  3695,  5828, 19.25      , SET_METALLIC         ,  50,  50,  50, 255).put(  G_INGOT_MACHINE_ORES        , UUM                                               ).aspects(  TC.METALLUM, 3, TC.TUTAMEN, 1                                       ), Wolframium=W.addIdenticalNames("Anti-Wolframium"), Wolfram=W.addIdenticalNames("Anti-Wolfram"),
	Re      , Rhenium               =   Re      = transmetal    ( 4750, "Anti-Rhenium"          ,  75, 111,  3459,  5869, 21.02      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Os      , Osmium                =   Os      = transmetal    ( 4760, "Anti-Osmium"           ,  76, 114,  3306,  5285, 22.61      , SET_METALLIC         ,  50,  50, 255, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.MACHINA, 1, TC.NEBRISUM, 1                       ),
	Ir      , Iridium               =   Ir      = transmetal    ( 4770, "Anti-Iridium"          ,  77, 115,  2719,  4701, 22.56      , SET_DULL             , 240, 240, 245, 255).put(  G_INGOT_MACHINE_ORES        , UUM                                               ).aspects(  TC.METALLUM, 2, TC.MACHINA, 1                                       ).setRGBaLiquid(255, 128, 200, 255),
	Pt      , Platinum              =   Pt      = transmetal    ( 4780, "Anti-Platinum"         ,  78, 117,  2041,  4098, 21.46      , SET_SHINY            , 255, 255, 200, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.NEBRISUM, 1                                      ),
	Au      , Gold                  =   Au      = transmetal    ( 4790, "Anti-Gold"             ,  79, 117,  1337,  3129, 19.282     , SET_SHINY            , 255, 230,  80, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.LUCRUM, 2                                        ),
	Hg      , Mercury               =   Hg      = transmetal    ( 4800, "Anti-Mercury"          ,  80, 120,   234,   629, 13.5336    , SET_SHINY            , 230, 220, 220, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 1, TC.AQUA, 1, TC.VENEMUM, 1                           ), Quicksilver=Hg.addIdenticalNames("Anti-Quicksilver").addIdenticalNames("Anti-QuickSilver"),
	Tl      , Thallium              =   Tl      = posttrans     ( 4810, "Anti-Thallium"         ,  81, 123,   577,  1746, 11.85      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 3                                                      ),
	Pb      , Lead                  =   Pb      = posttrans     ( 4820, "Anti-Lead"             ,  82, 125,   600,  2022, 11.342     , SET_DULL             , 140, 100, 140, 255).put(  G_INGOT_ORES                , UUM                                               ).aspects(  TC.METALLUM, 2, TC.ORDO, 1                                          ),
	Bi      , Bismuth               =   Bi      = posttrans     ( 4830, "Anti-Bismuth"          ,  83, 125,   544,  1837,  9.807     , SET_METALLIC         , 100, 160, 160, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.MAGNETO, 1                                       ),
	Po      , Polonium              =   Po      = posttrans     ( 4840, "Anti-Polonium"         ,  84, 124,   527,  1235,  9.32      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	At      , Astatine              =   At      = metalloid     ( 4850, "Anti-Astatine"         ,  85, 124,   575,   610,  7.0       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Rn      , Radon                 =   Rn      = noblegas      ( 4860, "Anti-Radon"            ,  86, 134,   202,   211,  0.00973   , SET_DULL             , 255,   0, 255,  15).put(  CONTAINERS_GAS                                                                  ).aspects(  TC.AER, 2, TC.RADIO, 1                                              ),
	Fr      , Francium              =   Fr      = alkali        ( 4870, "Anti-Francium"         ,  87, 134,   300,   950,  1.87      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Ra      , Radium                =   Ra      = alkaline      ( 4880, "Anti-Radium"           ,  88, 136,   973,  2010,  5.5       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Ac      , Actinium              =   Ac      = actinide      ( 4890, "Anti-Actinium"         ,  89, 136,  1323,  3471, 10.07      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Th      , Thorium               =   Th      = actinide      ( 4900, "Anti-Thorium"          ,  90, 140,  2115,  5061, 11.72      , SET_SHINY            ,   0,  30,   0, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Pa      , Protactinium          =   Pa      = actinide      ( 4910, "Anti-Protactinium"     ,  91, 138,  1841,  4300, 15.37      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	U_238   , Uranium               =   U_238   = actinide      ( 4920, "Anti-Uranium"          ,  92, 146,  1405,  4404, 18.95      , SET_METALLIC         ,  50, 240,  50, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ), Uranium238=U_238.addIdenticalNames("Anti-Uranium238"), Uran=U_238.addIdenticalNames("Anti-Uran"),
	U_235   , Uranium235            =   U_235   = actinide      ( 4921, "Anti-Uranium-235"      ,  92, 143,  1405,  4404, 18.95      , SET_SHINY            ,  70, 250,  70, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Np      , Neptunium             =   Np      = actinide      ( 4930, "Anti-Neptunium"        ,  93, 144,   917,  4273, 20.45      , SET_DULL             , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Pu      , Plutonium             =   Pu      = actinide      ( 4940, "Anti-Plutonium"        ,  94, 150,   912,  3501, 19.84      , SET_METALLIC         , 240,  50,  50, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ), Plutonium244=Pu.addIdenticalNames("Anti-Plutonium244"),
	Pu_241  , Plutonium241          =   Pu_241  = actinide      ( 4943, "Anti-Plutonium-241"    ,  94, 147,   912,  3501, 19.84      , SET_SHINY            , 245,  70,  70, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 3                                         ),
	Pu_243  , Plutonium243          =   Pu_243  = actinide      ( 4945, "Anti-Plutonium-243"    ,  94, 149,   912,  3501, 19.84      , SET_SHINY            , 250,  70,  70, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Am      , Americium             =   Am      = actinide      ( 4950, "Anti-Americium"        ,  95, 150,  1449,  2880, 13.69      , SET_METALLIC         , 200, 200, 200, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Am_241  , Americium241          =   Am_241  = actinide      ( 4951, "Anti-Americium-241"    ,  95, 146,  1449,  2880, 13.69      , SET_SHINY            , 210, 210, 210, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 3                                         ),
	Cm      , Curium                =   Cm      = actinide      ( 4960, "Anti-Curium"           ,  96, 153,  1613,  3383, 13.51      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Bk      , Berkelium             =   Bk      = actinide      ( 4970, "Anti-Berkelium"        ,  97, 152,  1259,  2900, 14.79      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Cf      , Californium           =   Cf      = actinide      ( 4980, "Anti-Californium"      ,  98, 153,  1173,  1743, 15.1       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Es      , Einsteinium           =   Es      = actinide      ( 4990, "Anti-Einsteinium"      ,  99, 153,  1133,  1269,  8.84      , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 2, TC.RADIO, 1                                         ),
	Fm      , Fermium               =   Fm      = actinide      ( 5000, "Anti-Fermium"          , 100, 157,  1125, 3000 ,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Md      , Mendelevium           =   Md      = actinide      ( 5010, "Anti-Mendelevium"      , 101, 157,  1100, 3000 ,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	No      , Nobelium              =   No      = actinide      ( 5020, "Anti-Nobelium"         , 102, 157,  1100, 3000 ,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Lr      , Lawrencium            =   Lr      = actinide      ( 5030, "Anti-Lawrencium"       , 103, 159,  1900, 3000 ,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Rf      , Rutherfordium         =   Rf      = transmetal    ( 5040, "Anti-Rutherfordium"    , 104, 161,  2400,  5800, 23.2       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Db      , Dubnium               =   Db      = transmetal    ( 5050, "Anti-Dubnium"          , 105, 163, 1000 , 3000 , 29.3       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Sg      , Seaborgium            =   Sg      = transmetal    ( 5060, "Anti-Seaborgium"       , 106, 165, 1000 , 3000 , 35.0       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Bh      , Bohrium               =   Bh      = transmetal    ( 5070, "Anti-Bohrium"          , 107, 163, 1000 , 3000 , 37.1       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Hs      , Hassium               =   Hs      = transmetal    ( 5080, "Anti-Hassium"          , 108, 169, 1000 , 3000 , 40.7       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Mt      , Meitnerium            =   Mt      = element       ( 5090, "Anti-Meitnerium"       , 109, 167, 1000 , 3000 , 37.4       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Ds      , Darmstadtium          =   Ds      = element       ( 5100, "Anti-Darmstadtium"     , 110, 171, 1000 , 3000 , 34.8       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Rg      , Roentgenium           =   Rg      = element       ( 5110, "Anti-Roentgenium"      , 111, 169, 1000 , 3000 , 28.7       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Cn      , Copernicium           =   Cn      = transmetal    ( 5120, "Anti-Copernicium"      , 112, 173,  150 ,   357, 23.7       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Uut     , Ununtrium             =   Uut     = element       ( 5130, "Anti-Ununtrium"        , 113, 171,   700,  1400, 16.0       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Fl      , Flerovium             =   Fl      = posttrans     ( 5140, "Anti-Flerovium"        , 114, 175,   340,   420, 14.0       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 3                                         ),
	Fl_298  , Flerovium298          =   Fl_298  = posttrans     ( 5148, "Anti-Flerovium-298"    , 114, 184,   340,   420, 14.0       , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Uup     , Ununpentium           =   Uup     = element       ( 5150, "Anti-Ununpentium"      , 115, 174,   700,  1400, 13.5       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Lv      , Livermorium           =   Lv      = element       ( 5160, "Anti-Livermorium"      , 116, 177,   708,  1085, 12.9       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Fa      , Farnsium              =   Fa      = element       ( 5170, "Anti-Farnsium"         , 117, 177,   673,   823,  7.2       , SET_SHINY            , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ), Uus=Fa, Ununseptium=Fa.addIdenticalNames("Anti-Ununseptium"),
	Uuo     , Ununoctium            =   Uuo     = element       ( 5180, "Anti-Ununoctium"       , 118, 176,   258,   263,  5.0       , SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Uue     , Ununennium            =   Uue     = element       ( 5190, "Anti-Ununennium"       , 119, 178,   290,   903,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	Ubn     , Unbinilium            =   Ubn     = element       ( 5200, "Anti-Unbinilium"       , 120, 180,   953,  1973,           0, SET_METALLIC         , 256, 256, 256, 255).put(  G_INGOT_ORES                                                                    ).aspects(  TC.METALLUM, 1, TC.RADIO, 2                                         ),
	
	// The following Data is in no way reliable, but it is there in case someone wants to use it.
	Ubu     , Unbiunium             =   Ubu     = element       ( 5210, "Anti-Unbiunium"        , 121, 182,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubb     , Unbibium              =   Ubb     = element       ( 5220, "Anti-Unbibium"         , 122, 184,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubt     , Unbitrium             =   Ubt     = element       ( 5230, "Anti-Unbitrium"        , 123, 186,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubq     , Unbiquadium           =   Ubq     = element       ( 5240, "Anti-Unbiquadium"      , 124, 188,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubp     , Unbipentium           =   Ubp     = element       ( 5250, "Anti-Unbipentium"      , 125, 190,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubh     , Unbihexium            =   Ubh     = element       ( 5260, "Anti-Unbihexium"       , 126, 192,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubs     , Unbiseptium           =   Ubs     = element       ( 5270, "Anti-Unbiseptium"      , 127, 194,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ubo     , Unbioctium            =   Ubo     = element       ( 5280, "Anti-Unbioctium"       , 128, 196,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ube     , Unbiennium            =   Ube     = element       ( 5290, "Anti-Unbiennium"       , 129, 198,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utn     , Untrinilium           =   Utn     = element       ( 5300, "Anti-Untrinilium"      , 130, 200,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utu     , Untriunium            =   Utu     = element       ( 5310, "Anti-Untriunium"       , 131, 203,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utb     , Untribium             =   Utb     = element       ( 5320, "Anti-Untribium"        , 132, 206,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utt     , Untritrium            =   Utt     = element       ( 5330, "Anti-Untritrium"       , 133, 209,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utq     , Untriquadium          =   Utq     = element       ( 5340, "Anti-Untriquadium"     , 134, 212,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Utp     , Untripentium          =   Utp     = element       ( 5350, "Anti-Untripentium"     , 135, 215,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uth     , Untrihexium           =   Uth     = element       ( 5360, "Anti-Untrihexium"      , 136, 218,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uts     , Untriseptium          =   Uts     = element       ( 5370, "Anti-Untriseptium"     , 137, 221,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uto     , Untrioctium           =   Uto     = element       ( 5380, "Anti-Untrioctium"      , 138, 224,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ute     , Untriennium           =   Ute     = element       ( 5390, "Anti-Untriennium"      , 139, 227,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqn     , Unquadnilium          =   Uqn     = element       ( 5400, "Anti-Unquadnilium"     , 140, 230,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqu     , Unquadunium           =   Uqu     = element       ( 5410, "Anti-Unquadunium"      , 141, 233,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqb     , Unquadbium            =   Uqb     = element       ( 5420, "Anti-Unquadbium"       , 142, 236,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqt     , Unquadtrium           =   Uqt     = element       ( 5430, "Anti-Unquadtrium"      , 143, 239,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqq     , Unquadquadium         =   Uqq     = element       ( 5440, "Anti-Unquadquadium"    , 144, 242,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqp     , Unquadpentium         =   Uqp     = element       ( 5450, "Anti-Unquadpentium"    , 145, 245,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqh     , Unquadhexium          =   Uqh     = element       ( 5460, "Anti-Unquadhexium"     , 146, 248,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqs     , Unquadseptium         =   Uqs     = element       ( 5470, "Anti-Unquadseptium"    , 147, 251,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqo     , Unquadoctium          =   Uqo     = element       ( 5480, "Anti-Unquadoctium"     , 148, 254,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uqe     , Unquadennium          =   Uqe     = element       ( 5490, "Anti-Unquadennium"     , 149, 257,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upn     , Unpentnilium          =   Upn     = element       ( 5500, "Anti-Unpentnilium"     , 150, 260,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upu     , Unpentunium           =   Upu     = element       ( 5510, "Anti-Unpentunium"      , 151, 263,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Vb      , Vibranium             =   Vb      = element       ( 5520, "Anti-Vibranium"        , 152, 266,  4852,  9415,  3.23978365, SET_EMERALD          , 200, 128, 255, 100).put(  G_GEM_ORES_TRANSPARENT                                                          ).aspects(TC.VITREUS, 10, TC.SENSUS, 10), Upb = Vb, Unpentbium = Vb.addIdenticalNames("Anti-Unpentbium").qual(3, 1000.0F, 512, 15),
	Upt     , Unpenttrium           =   Upt     = element       ( 5530, "Anti-Unpenttrium"      , 153, 269,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upq     , Unpentquadium         =   Upq     = element       ( 5540, "Anti-Unpentquadium"    , 154, 272,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upp     , Unpentpentium         =   Upp     = element       ( 5550, "Anti-Unpentpentium"    , 155, 276,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uph     , Unpenthexium          =   Uph     = element       ( 5560, "Anti-Unpenthexium"     , 156, 280,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ups     , Unpentseptium         =   Ups     = element       ( 5570, "Anti-Unpentseptium"    , 157, 284,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upo     , Unpentoctium          =   Upo     = element       ( 1580, "Anti-Unpentoctium"     , 158, 288,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Upe     , Unpentennium          =   Upe     = element       ( 5590, "Anti-Unpentennium"     , 159, 292,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhn     , Unhexnilium           =   Uhn     = element       ( 5600, "Anti-Unhexnilium"      , 160, 296,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhu     , Unhexunium            =   Uhu     = element       ( 5610, "Anti-Unhexunium"       , 161, 300,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhb     , Unhexbium             =   Uhb     = element       ( 5620, "Anti-Unhexbium"        , 162, 304,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uht     , Unhextrium            =   Uht     = element       ( 5630, "Anti-Unhextrium"       , 163, 308,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhq     , Unhexquadium          =   Uhq     = element       ( 5640, "Anti-Unhexquadium"     , 164, 312,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhp     , Unhexpentium          =   Uhp     = element       ( 5650, "Anti-Unhexpentium"     , 165, 316,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhh     , Unhexhexium           =   Uhh     = element       ( 5660, "Anti-Unhexhexium"      , 166, 320,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhs     , Unhexseptium          =   Uhs     = element       ( 5670, "Anti-Unhexseptium"     , 167, 324,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uho     , Unhexoctium           =   Uho     = element       ( 5680, "Anti-Unhexoctium"      , 168, 328,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uhe     , Unhexennium           =   Uhe     = element       ( 5690, "Anti-Unhexennium"      , 169, 332,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Usn     , Unseptnilium          =   Usn     = element       ( 5700, "Anti-Unseptnilium"     , 170, 336,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Usu     , Unseptunium           =   Usu     = element       ( 5710, "Anti-Unseptunium"      , 171, 340,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Usb     , Unseptbium            =   Usb     = element       ( 5720, "Anti-Unseptbium"       , 172, 344,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ust     , Unsepttrium           =   Ust     = element       ( 5730, "Anti-Unsepttrium"      , 173, 348,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Nq      , Naquadah              =   Nq      = element       ( 5740, "Anti-Naquadah"         , 174, 352,   500,  2000, 21.0       , SET_METALLIC         ,  50,  50,  50, 255).put(  G_INGOT_MACHINE_ORES                                                            ).aspects(TC.METALLUM, 3, TC.RADIO, 1, TC.NEBRISUM, 1).setRGBaLiquid(  0, 255,   0, 255), Usq = Nq, Unseptquadium = Nq.addIdenticalNames("Anti-Unseptquadium"),
	Nq_528  , NaquadahEnriched      =   Nq_528  = element       ( 5741, "Anti-Naquadah-Enriched", 174, 354,   500,  2000, 22.0       , SET_METALLIC         ,  60,  60,  60, 255).put(  G_INGOT_ORES                                                                    ).aspects(TC.METALLUM, 3, TC.RADIO, 2, TC.NEBRISUM, 2).setRGBaLiquid( 64, 255,  64, 255).setLocal("Enriched Anti-Naquadah"),
	Nq_522  , Naquadria             =   Nq_522  = element       ( 5742, "Anti-Naquadria"        , 174, 348,   500,  2000, 20.0       , SET_SHINY            ,  30,  30,  30, 255).put(  G_INGOT_ORES                                                                    ).aspects(TC.METALLUM, 4, TC.RADIO, 3, TC.NEBRISUM, 3).setRGBaLiquid(128, 255, 128, 255),
	Usp     , Unseptpentium         =   Usp     = element       ( 5750, "Anti-Unseptpentium"    , 175, 356,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ush     , Unsepthexium          =   Ush     = element       ( 5760, "Anti-Unsepthexium"     , 176, 360,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uss     , Unseptseptium         =   Uss     = element       ( 5770, "Anti-Unseptseptium"    , 177, 364,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uso     , Unseptoctium          =   Uso     = element       ( 5780, "Anti-Unseptoctium"     , 178, 368,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Use     , Unseptennium          =   Use     = element       ( 5790, "Anti-Unseptennium"     , 179, 372,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uon     , Unoctnilium           =   Uon     = element       ( 5800, "Anti-Unoctnilium"      , 180, 376,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uou     , Unoctunium            =   Uou     = element       ( 5810, "Anti-Unoctunium"       , 181, 380,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uob     , Unoctbium             =   Uob     = element       ( 5820, "Anti-Unoctbium"        , 182, 384,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uot     , Unocttrium            =   Uot     = element       ( 5830, "Anti-Unocttrium"       , 183, 388,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uoq     , Unoctquadium          =   Uoq     = element       ( 5840, "Anti-Unoctquadium"     , 184, 392,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uop     , Unoctpentium          =   Uop     = element       ( 5850, "Anti-Unoctpentium"     , 185, 396,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uoh     , Unocthexium           =   Uoh     = element       ( 5860, "Anti-Unocthexium"      , 186, 400,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uos     , Unoctseptium          =   Uos     = element       ( 5870, "Anti-Unoctseptium"     , 187, 405,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uoo     , Unoctoctium           =   Uoo     = element       ( 5880, "Anti-Unoctoctium"      , 188, 410,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uoe     , Unoctennium           =   Uoe     = element       ( 5890, "Anti-Unoctennium"      , 189, 415,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uen     , Unennilium            =   Uen     = element       ( 5900, "Anti-Unennilium"       , 190, 420,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ueu     , Unennunium            =   Ueu     = element       ( 5910, "Anti-Unennunium"       , 191, 425,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ueb     , Unennbium             =   Ueb     = element       ( 5920, "Anti-Unennbium"        , 192, 430,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uet     , Unenntrium            =   Uet     = element       ( 5930, "Anti-Unenntrium"       , 193, 435,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ueq     , Unennquadium          =   Ueq     = element       ( 5940, "Anti-Unennquadium"     , 194, 440,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uep     , Unennpentium          =   Uep     = element       ( 5950, "Anti-Unennpentium"     , 195, 445,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ueh     , Unennhexium           =   Ueh     = element       ( 5960, "Anti-Unennhexium"      , 196, 450,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ues     , Unennseptium          =   Ues     = element       ( 5970, "Anti-Unennseptium"     , 197, 455,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ueo     , Unennoctium           =   Ueo     = element       ( 5980, "Anti-Unennoctium"      , 198, 460,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Uee     , Unennennium           =   Uee     = element       ( 5990, "Anti-Unennennium"      , 199, 465,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnn     , Binilnilium           =   Bnn     = element       ( 6000, "Anti-Binilnilium"      , 200, 470,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnu     , Binilunium            =   Bnu     = element       ( 6010, "Anti-Binilunium"       , 201, 475,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnb     , Binilbium             =   Bnb     = element       ( 6020, "Anti-Binilbium"        , 202, 480,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnt     , Biniltrium            =   Bnt     = element       ( 6030, "Anti-Biniltrium"       , 203, 485,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnq     , Binilquadium          =   Bnq     = element       ( 6040, "Anti-Binilquadium"     , 204, 490,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnp     , Binilpentium          =   Bnp     = element       ( 6050, "Anti-Binilpentium"     , 205, 495,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bnh     , Binilhexium           =   Bnh     = element       ( 6060, "Anti-Binilhexium"      , 206, 500,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bns     , Binilseptium          =   Bns     = element       ( 6070, "Anti-Binilseptium"     , 207, 505,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bno     , Biniloctium           =   Bno     = element       ( 6080, "Anti-Biniloctium"      , 208, 510,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bne     , Binilennium           =   Bne     = element       ( 6090, "Anti-Binilennium"      , 209, 515,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bun     , Biunnilium            =   Bun     = element       ( 6100, "Anti-Biunnilium"       , 210, 520,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Buu     , Biununium             =   Buu     = element       ( 6110, "Anti-Biununium"        , 211, 525,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bub     , Biunbium              =   Bub     = element       ( 6120, "Anti-Biunbium"         , 212, 530,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	But     , Biuntrium             =   But     = element       ( 6130, "Anti-Biuntrium"        , 213, 535,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Buq     , Biunquadium           =   Buq     = element       ( 6140, "Anti-Biunquadium"      , 214, 540,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bup     , Biunpentium           =   Bup     = element       ( 6150, "Anti-Biunpentium"      , 215, 545,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Buh     , Biunhexium            =   Buh     = element       ( 6160, "Anti-Biunhexium"       , 216, 550,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bus     , Biunseptium           =   Bus     = element       ( 6170, "Anti-Biunseptium"      , 217, 555,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Buo     , Biunoctium            =   Buo     = element       ( 6180, "Anti-Biunoctium"       , 218, 560,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bue     , Biunennium            =   Bue     = element       ( 6190, "Anti-Biunennium"       , 219, 565,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbn     , Bibinilium            =   Bbn     = element       ( 6200, "Anti-Bibinilium"       , 220, 570,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbu     , Bibiunium             =   Bbu     = element       ( 6210, "Anti-Bibiunium"        , 221, 575,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ad      , Adamantium            =   Ad      = element       ( 6220, "Anti-Adamantium"       , 222, 580,  5425, 14528, 13.35624762, SET_SHINY            , 255, 255, 255, 255).put(G_INGOT_MACHINE_ORES, SMITHABLE, MELTING, MAGICAL                                 ).aspects(TC.METALLUM, 10, TC.PRAECANTIO, 10).qual(3, 10.0F, 5120, 5).addIdenticalNames("Anti-Adamantine", "Anti-Adamant"), Bbb = Ad, Bibibium = Ad.addIdenticalNames("Anti-Bibibium"),
	Bbt     , Bibitrium             =   Bbt     = element       ( 6230, "Anti-Bibitrium"        , 223, 585,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbq     , Bibiquadium           =   Bbq     = element       ( 6240, "Anti-Bibiquadium"      , 224, 590,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbp     , Bibipentium           =   Bbp     = element       ( 6250, "Anti-Bibipentium"      , 225, 595,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbh     , Bibihexium            =   Bbh     = element       ( 6260, "Anti-Bibihexium"       , 226, 600,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbs     , Bibiseptium           =   Bbs     = element       ( 6270, "Anti-Bibiseptium"      , 227, 605,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbo     , Bibioctium            =   Bbo     = element       ( 6280, "Anti-Bibioctium"       , 228, 610,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bbe     , Bibiennium            =   Bbe     = element       ( 6290, "Anti-Bibiennium"       , 229, 615,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btn     , Bitrinilium           =   Btn     = element       ( 6300, "Anti-Bitrinilium"      , 230, 620,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btu     , Bitriunium            =   Btu     = element       ( 6310, "Anti-Bitriunium"       , 231, 625,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btb     , Bitribium             =   Btb     = element       ( 6320, "Anti-Bitribium"        , 232, 630,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btt     , Bitritrium            =   Btt     = element       ( 6330, "Anti-Bitritrium"       , 233, 635,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btq     , Bitriquadium          =   Btq     = element       ( 6340, "Anti-Bitriquadium"     , 234, 640,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Btp     , Bitripentium          =   Btp     = element       ( 6350, "Anti-Bitripentium"     , 235, 645,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bth     , Bitrihexium           =   Bth     = element       ( 6360, "Anti-Bitrihexium"      , 236, 650,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bts     , Bitriseptium          =   Bts     = element       ( 6370, "Anti-Bitriseptium"     , 237, 655,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bto     , Bitrioctium           =   Bto     = element       ( 6380, "Anti-Bitrioctium"      , 238, 660,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Mcg     , MacGuffium            =   Mcg     = element       ( 6390, "Anti-Mac-Guffium"      , 239, 665,   200,  1000,  3.122     , SET_SHINY            , 200,  50, 150, 255).put(  CONTAINERS                                                                      ).aspects(TC.ALIENIS, 8, TC.PERMUTATIO, 8, TC.SPIRITUS, 8, TC.AURAM, 8, TC.VITIUM, 8, TC.RADIO, 8, TC.MAGNETO, 8, TC.ELECTRUM, 8, TC.NEBRISUM, 8, TC.STRONTIO, 8), Bte = Mcg, Bitriennium = Mcg.addIdenticalNames("Anti-Bitriennium"),
	Bqn     , Biquadnilium          =   Bqn     = element       ( 6400, "Anti-Biquadnilium"     , 240, 670,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqu     , Biquadunium           =   Bqu     = element       ( 6410, "Anti-Biquadunium"      , 241, 675,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqb     , Biquadbium            =   Bqb     = element       ( 6420, "Anti-Biquadbium"       , 242, 680,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqt     , Biquadtrium           =   Bqt     = element       ( 6430, "Anti-Biquadtrium"      , 243, 685,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqq     , Biquadquadium         =   Bqq     = element       ( 6440, "Anti-Biquadquadium"    , 244, 690,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqp     , Biquadpentium         =   Bqp     = element       ( 6450, "Anti-Biquadpentium"    , 245, 695,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqh     , Biquadhexium          =   Bqh     = element       ( 6460, "Anti-Biquadhexium"     , 246, 700,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqs     , Biquadseptium         =   Bqs     = element       ( 6470, "Anti-Biquadseptium"    , 247, 705,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqo     , Biquadoctium          =   Bqo     = element       ( 6480, "Anti-Biquadoctium"     , 248, 710,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bqe     , Biquadennium          =   Bqe     = element       ( 6490, "Anti-Biquadennium"     , 249, 715,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpn     , Bipentnilium          =   Bpn     = element       ( 6500, "Anti-Bipentnilium"     , 250, 720,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpu     , Bipentunium           =   Bpu     = element       ( 6510, "Anti-Bipentunium"      , 251, 725,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpb     , Bipentbium            =   Bpb     = element       ( 6520, "Anti-Bipentbium"       , 252, 730,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpt     , Bipenttrium           =   Bpt     = element       ( 6530, "Anti-Bipenttrium"      , 253, 735,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpq     , Bipentquadium         =   Bpq     = element       ( 6540, "Anti-Bipentquadium"    , 254, 740,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpp     , Bipentpentium         =   Bpp     = element       ( 6550, "Anti-Bipentpentium"    , 255, 745,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bph     , Bipenthexium          =   Bph     = element       ( 6560, "Anti-Bipenthexium"     , 256, 750,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bps     , Bipentseptium         =   Bps     = element       ( 6570, "Anti-Bipentseptium"    , 257, 755,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpo     , Bipentoctium          =   Bpo     = element       ( 6580, "Anti-Bipentoctium"     , 258, 760,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bpe     , Bipentennium          =   Bpe     = element       ( 6590, "Anti-Bipentennium"     , 259, 765,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhn     , Bihexnilium           =   Bhn     = element       ( 6600, "Anti-Bihexnilium"      , 260, 770,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhu     , Bihexunium            =   Bhu     = element       ( 6610, "Anti-Bihexunium"       , 261, 775,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhb     , Bihexbium             =   Bhb     = element       ( 6620, "Anti-Bihexbium"        , 262, 780,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bht     , Bihextrium            =   Bht     = element       ( 6630, "Anti-Bihextrium"       , 263, 785,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhq     , Bihexquadium          =   Bhq     = element       ( 6640, "Anti-Bihexquadium"     , 264, 790,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhp     , Bihexpentium          =   Bhp     = element       ( 6650, "Anti-Bihexpentium"     , 265, 795,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhh     , Bihexhexium           =   Bhh     = element       ( 6660, "Anti-Bihexhexium"      , 266, 800,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhs     , Bihexseptium          =   Bhs     = element       ( 6670, "Anti-Bihexseptium"     , 267, 805,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bho     , Bihexoctium           =   Bho     = element       ( 6680, "Anti-Bihexoctium"      , 268, 810,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bhe     , Bihexennium           =   Bhe     = element       ( 6690, "Anti-Bihexennium"      , 269, 815,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsn     , Biseptnilium          =   Bsn     = element       ( 6700, "Anti-Biseptnilium"     , 270, 820,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsu     , Biseptunium           =   Bsu     = element       ( 6710, "Anti-Biseptunium"      , 271, 825,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsb     , Biseptbium            =   Bsb     = element       ( 6720, "Anti-Biseptbium"       , 272, 830,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bst     , Bisepttrium           =   Bst     = element       ( 6730, "Anti-Bisepttrium"      , 273, 835,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsq     , Biseptquadium         =   Bsq     = element       ( 6740, "Anti-Biseptquadium"    , 274, 840,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsp     , Biseptpentium         =   Bsp     = element       ( 6750, "Anti-Biseptpentium"    , 275, 845,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bsh     , Bisepthexium          =   Bsh     = element       ( 6760, "Anti-Bisepthexium"     , 276, 850,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bss     , Biseptseptium         =   Bss     = element       ( 6770, "Anti-Biseptseptium"    , 277, 855,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bso     , Biseptoctium          =   Bso     = element       ( 6780, "Anti-Biseptoctium"     , 278, 860,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bse     , Biseptennium          =   Bse     = element       ( 6790, "Anti-Biseptennium"     , 279, 865,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bon     , Bioctnilium           =   Bon     = element       ( 6800, "Anti-Bioctnilium"      , 280, 870,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bou     , Bioctunium            =   Bou     = element       ( 6810, "Anti-Bioctunium"       , 281, 875,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bob     , Bioctbium             =   Bob     = element       ( 6820, "Anti-Bioctbium"        , 282, 880,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bot     , Biocttrium            =   Bot     = element       ( 6830, "Anti-Biocttrium"       , 283, 885,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Boq     , Bioctquadium          =   Boq     = element       ( 6840, "Anti-Bioctquadium"     , 284, 890,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bop     , Bioctpentium          =   Bop     = element       ( 6850, "Anti-Bioctpentium"     , 285, 895,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Boh     , Biocthexium           =   Boh     = element       ( 6860, "Anti-Biocthexium"      , 286, 900,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bos     , Bioctseptium          =   Bos     = element       ( 6870, "Anti-Bioctseptium"     , 287, 905,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Boo     , Bioctoctium           =   Boo     = element       ( 6880, "Anti-Bioctoctium"      , 288, 910,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Boe     , Bioctennium           =   Boe     = element       ( 6890, "Anti-Bioctennium"      , 289, 915,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ben     , Biennilium            =   Ben     = element       ( 6900, "Anti-Biennilium"       , 290, 920,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Beu     , Biennunium            =   Beu     = element       ( 6910, "Anti-Biennunium"       , 291, 925,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Beb     , Biennbium             =   Beb     = element       ( 6920, "Anti-Biennbium"        , 292, 930,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bet     , Bienntrium            =   Bet     = element       ( 6930, "Anti-Bienntrium"       , 293, 935,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Beq     , Biennquadium          =   Beq     = element       ( 6940, "Anti-Biennquadium"     , 294, 940,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bep     , Biennpentium          =   Bep     = element       ( 6950, "Anti-Biennpentium"     , 295, 945,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Beh     , Biennhexium           =   Beh     = element       ( 6960, "Anti-Biennhexium"      , 296, 950,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bes     , Biennseptium          =   Bes     = element       ( 6970, "Anti-Biennseptium"     , 297, 955,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Beo     , Biennoctium           =   Beo     = element       ( 6980, "Anti-Biennoctium"      , 298, 960,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Bee     , Biennennium           =   Bee     = element       ( 6990, "Anti-Biennennium"      , 299, 965,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnn     , Trinilnilium          =   Tnn     = element       ( 7000, "Anti-Trinilnilium"     , 300, 970,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnu     , Trinilunium           =   Tnu     = element       ( 7010, "Anti-Trinilunium"      , 301, 975,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnb     , Trinilbium            =   Tnb     = element       ( 7020, "Anti-Trinilbium"       , 302, 980,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnt     , Triniltrium           =   Tnt     = element       ( 7030, "Anti-Triniltrium"      , 303, 985,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnq     , Trinilquadium         =   Tnq     = element       ( 7040, "Anti-Trinilquadium"    , 304, 990,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnp     , Trinilpentium         =   Tnp     = element       ( 7050, "Anti-Trinilpentium"    , 305, 995,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tnh     , Trinilhexium          =   Tnh     = element       ( 7060, "Anti-Trinilhexium"     , 306,1000,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tns     , Trinilseptium         =   Tns     = element       ( 7070, "Anti-Trinilseptium"    , 307,1005,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tno     , Triniloctium          =   Tno     = element       ( 7080, "Anti-Triniloctium"     , 308,1010,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tne     , Trinilennium          =   Tne     = element       ( 7090, "Anti-Trinilennium"     , 309,1015,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tun     , Triunnilium           =   Tun     = element       ( 7100, "Anti-Triunnilium"      , 310,1020,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tuu     , Triununium            =   Tuu     = element       ( 7110, "Anti-Triununium"       , 311,1025,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tub     , Triunbium             =   Tub     = element       ( 7120, "Anti-Triunbium"        , 312,1030,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tut     , Triuntrium            =   Tut     = element       ( 7130, "Anti-Triuntrium"       , 313,1035,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tuq     , Triunquadium          =   Tuq     = element       ( 7140, "Anti-Triunquadium"     , 314,1040,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tup     , Triunpentium          =   Tup     = element       ( 7150, "Anti-Triunpentium"     , 315,1045,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tuh     , Triunhexium           =   Tuh     = element       ( 7160, "Anti-Triunhexium"      , 316,1050,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tus     , Triunseptium          =   Tus     = element       ( 7170, "Anti-Triunseptium"     , 317,1055,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tuo     , Triunoctium           =   Tuo     = element       ( 7180, "Anti-Triunoctium"      , 318,1060,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tue     , Triunennium           =   Tue     = element       ( 7190, "Anti-Triunennium"      , 319,1065,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbn     , Tribinilium           =   Tbn     = element       ( 7200, "Anti-Tribinilium"      , 320,1070,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbu     , Tribiunium            =   Tbu     = element       ( 7210, "Anti-Tribiunium"       , 321,1075,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbb     , Tribibium             =   Tbb     = element       ( 7220, "Anti-Tribibium"        , 322,1080,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbt     , Tribitrium            =   Tbt     = element       ( 7230, "Anti-Tribitrium"       , 323,1085,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbq     , Tribiquadium          =   Tbq     = element       ( 7240, "Anti-Tribiquadium"     , 324,1090,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbp     , Tribipentium          =   Tbp     = element       ( 7250, "Anti-Tribipentium"     , 325,1095,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbh     , Tribihexium           =   Tbh     = element       ( 7260, "Anti-Tribihexium"      , 326,1100,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbs     , Tribiseptium          =   Tbs     = element       ( 7270, "Anti-Tribiseptium"     , 327,1105,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbo     , Tribioctium           =   Tbo     = element       ( 7280, "Anti-Tribioctium"      , 328,1110,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tbe     , Tribiennium           =   Tbe     = element       ( 7290, "Anti-Tribiennium"      , 329,1115,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttn     , Tritrinilium          =   Ttn     = element       ( 7300, "Anti-Tritrinilium"     , 330,1120,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttu     , Tritriunium           =   Ttu     = element       ( 7310, "Anti-Tritriunium"      , 331,1125,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttb     , Tritribium            =   Ttb     = element       ( 7320, "Anti-Tritribium"       , 332,1130,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttt     , Tritritrium           =   Ttt     = element       ( 7330, "Anti-Tritritrium"      , 333,1135,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttq     , Tritriquadium         =   Ttq     = element       ( 7340, "Anti-Tritriquadium"    , 334,1140,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ttp     , Tritripentium         =   Ttp     = element       ( 7350, "Anti-Tritripentium"    , 335,1145,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tth     , Tritrihexium          =   Tth     = element       ( 7360, "Anti-Tritrihexium"     , 336,1150,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tts     , Tritriseptium         =   Tts     = element       ( 7370, "Anti-Tritriseptium"    , 337,1155,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tto     , Tritrioctium          =   Tto     = element       ( 7380, "Anti-Tritrioctium"     , 338,1160,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tte     , Tritriennium          =   Tte     = element       ( 7390, "Anti-Tritriennium"     , 339,1165,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqn     , Triquadnilium         =   Tqn     = element       ( 7400, "Anti-Triquadnilium"    , 340,1170,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqu     , Triquadunium          =   Tqu     = element       ( 7410, "Anti-Triquadunium"     , 341,1175,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqb     , Triquadbium           =   Tqb     = element       ( 7420, "Anti-Triquadbium"      , 342,1180,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqt     , Triquadtrium          =   Tqt     = element       ( 7430, "Anti-Triquadtrium"     , 343,1185,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqq     , Triquadquadium        =   Tqq     = element       ( 7440, "Anti-Triquadquadium"   , 344,1190,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqp     , Triquadpentium        =   Tqp     = element       ( 7450, "Anti-Triquadpentium"   , 345,1195,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqh     , Triquadhexium         =   Tqh     = element       ( 7460, "Anti-Triquadhexium"    , 346,1200,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqs     , Triquadseptium        =   Tqs     = element       ( 7470, "Anti-Triquadseptium"   , 347,1205,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqo     , Triquadoctium         =   Tqo     = element       ( 7480, "Anti-Triquadoctium"    , 348,1210,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tqe     , Triquadennium         =   Tqe     = element       ( 7490, "Anti-Triquadennium"    , 349,1215,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpn     , Tripentnilium         =   Tpn     = element       ( 7500, "Anti-Tripentnilium"    , 350,1220,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpu     , Tripentunium          =   Tpu     = element       ( 7510, "Anti-Tripentunium"     , 351,1225,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpb     , Tripentbium           =   Tpb     = element       ( 7520, "Anti-Tripentbium"      , 352,1230,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpt     , Tripenttrium          =   Tpt     = element       ( 7530, "Anti-Tripenttrium"     , 353,1235,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpq     , Tripentquadium        =   Tpq     = element       ( 7540, "Anti-Tripentquadium"   , 354,1240,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpp     , Tripentpentium        =   Tpp     = element       ( 7550, "Anti-Tripentpentium"   , 355,1245,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tph     , Tripenthexium         =   Tph     = element       ( 7560, "Anti-Tripenthexium"    , 356,1250,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tps     , Tripentseptium        =   Tps     = element       ( 7570, "Anti-Tripentseptium"   , 357,1255,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpo     , Tripentoctium         =   Tpo     = element       ( 7580, "Anti-Tripentoctium"    , 358,1260,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tpe     , Tripentennium         =   Tpe     = element       ( 7590, "Anti-Tripentennium"    , 359,1265,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thn     , Trihexnilium          =   Thn     = element       ( 7600, "Anti-Trihexnilium"     , 360,1270,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thu     , Trihexunium           =   Thu     = element       ( 7610, "Anti-Trihexunium"      , 361,1275,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thb     , Trihexbium            =   Thb     = element       ( 7620, "Anti-Trihexbium"       , 362,1280,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tht     , Trihextrium           =   Tht     = element       ( 7630, "Anti-Trihextrium"      , 363,1285,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thq     , Trihexquadium         =   Thq     = element       ( 7640, "Anti-Trihexquadium"    , 364,1290,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thp     , Trihexpentium         =   Thp     = element       ( 7650, "Anti-Trihexpentium"    , 365,1295,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Thh     , Trihexhexium          =   Thh     = element       ( 7660, "Anti-Trihexhexium"     , 366,1300,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ths     , Trihexseptium         =   Ths     = element       ( 7670, "Anti-Trihexseptium"    , 367,1305,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tho     , Trihexoctium          =   Tho     = element       ( 7680, "Anti-Trihexoctium"     , 368,1310,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	The     , Trihexennium          =   The     = element       ( 7690, "Anti-Trihexennium"     , 369,1315,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tsn     , Triseptnilium         =   Tsn     = element       ( 7700, "Anti-Triseptnilium"    , 370,1320,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tsu     , Triseptunium          =   Tsu     = element       ( 7710, "Anti-Triseptunium"     , 371,1325,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Gt      , Gravitonium           =   Gt      = element       ( 7720, "Anti-Gravitonium"      , 372,1330,   112,  1275, 1768.866761, SET_SHINY            ,   0,  50,   0, 255).put(  CONTAINERS                                                                      ).aspects(TC.TERRA, 10, TC.POTENTIA, 10), Tsb = Gt, Triseptbium = Gt.addIdenticalNames("Anti-Triseptbium"),
	Tst     , Trisepttrium          =   Tst     = element       ( 7730, "Anti-Trisepttrium"     , 373,1335,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tsq     , Triseptquadium        =   Tsq     = element       ( 7740, "Anti-Triseptquadium"   , 374,1340,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tsp     , Triseptpentium        =   Tsp     = element       ( 7750, "Anti-Triseptpentium"   , 375,1345,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tsh     , Trisepthexium         =   Tsh     = element       ( 7760, "Anti-Trisepthexium"    , 376,1350,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tss     , Triseptseptium        =   Tss     = element       ( 7770, "Anti-Triseptseptium"   , 377,1355,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tso     , Triseptoctium         =   Tso     = element       ( 7780, "Anti-Triseptoctium"    , 378,1360,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tse     , Triseptennium         =   Tse     = element       ( 7790, "Anti-Triseptennium"    , 379,1365,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ton     , Trioctnilium          =   Ton     = element       ( 7800, "Anti-Trioctnilium"     , 380,1370,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tou     , Trioctunium           =   Tou     = element       ( 7810, "Anti-Trioctunium"      , 381,1375,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tob     , Trioctbium            =   Tob     = element       ( 7820, "Anti-Trioctbium"       , 382,1380,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tot     , Triocttrium           =   Tot     = element       ( 7830, "Anti-Triocttrium"      , 383,1385,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Toq     , Trioctquadium         =   Toq     = element       ( 7840, "Anti-Trioctquadium"    , 384,1390,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Top     , Trioctpentium         =   Top     = element       ( 7850, "Anti-Trioctpentium"    , 385,1395,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Toh     , Triocthexium          =   Toh     = element       ( 7860, "Anti-Triocthexium"     , 386,1400,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tos     , Trioctseptium         =   Tos     = element       ( 7870, "Anti-Trioctseptium"    , 387,1405,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Too     , Trioctoctium          =   Too     = element       ( 7880, "Anti-Trioctoctium"     , 388,1410,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Toe     , Trioctennium          =   Toe     = element       ( 7890, "Anti-Trioctennium"     , 389,1415,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Ten     , Triennilium           =   Ten     = element       ( 7900, "Anti-Triennilium"      , 390,1420,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Teu     , Triennunium           =   Teu     = element       ( 7910, "Anti-Triennunium"      , 391,1425,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Teb     , Triennbium            =   Teb     = element       ( 7920, "Anti-Triennbium"       , 392,1430,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tet     , Trienntrium           =   Tet     = element       ( 7930, "Anti-Trienntrium"      , 393,1435,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Teq     , Triennquadium         =   Teq     = element       ( 7940, "Anti-Triennquadium"    , 394,1440,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tep     , Triennpentium         =   Tep     = element       ( 7950, "Anti-Triennpentium"    , 395,1445,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Teh     , Triennhexium          =   Teh     = element       ( 7960, "Anti-Triennhexium"     , 396,1450,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tes     , Triennseptium         =   Tes     = element       ( 7970, "Anti-Triennseptium"    , 397,1455,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Teo     , Triennoctium          =   Teo     = element       ( 7980, "Anti-Triennoctium"     , 398,1460,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3),
	Tee     , Triennennium          =   Tee     = element       ( 7990, "Anti-Triennennium"     , 399,1465,  1000,  3000,           0, SET_SHINY            , 256, 256, 256, 255).put(                                                                                  ).aspects(TC.RADIO, 3);
}
