/*
 * Decompiled with CFR 0.152.
 */
package gregapi.compat.industrialcraft;

import gregapi.compat.CompatBase;
import gregapi.compat.industrialcraft.ICompatIC2EUItem;
import gregapi.data.CS;
import gregapi.util.ST;
import gregapi.util.UT;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;

public class CompatIC2EUItem
extends CompatBase
implements ICompatIC2EUItem {
    public CompatIC2EUItem() {
        IElectricItem.class.getCanonicalName();
        ElectricItem.class.getCanonicalName();
    }

    @Override
    public long charge(ItemStack aStack, long aAmount, int aTier, boolean aIgnoreLimit, boolean aDoCharge) {
        if (ElectricItem.manager == null) {
            return 0L;
        }
        int tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack);
        if (tTier < 0 || tTier == aTier || aTier == Integer.MAX_VALUE) {
            if (!aIgnoreLimit && tTier >= 0) {
                aAmount = (int)Math.min(aAmount, CS.V[Math.max(0, Math.min(CS.V.length - 1, tTier))]);
            }
            if (aAmount > 0L) {
                long rAmount = (long)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aAmount, tTier, true, !aDoCharge));
                return rAmount;
            }
        }
        return 0L;
    }

    @Override
    public long decharge(ItemStack aStack, long aAmount, int aTier, boolean aIgnoreLimit, boolean aDoDecharge, boolean aIgnoreDischargability) {
        if (ElectricItem.manager == null) {
            return 0L;
        }
        int tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack);
        if (tTier < 0 || tTier == aTier || aTier == Integer.MAX_VALUE) {
            if (!aIgnoreLimit && tTier >= 0) {
                aAmount = (int)Math.min(aAmount, CS.V[Math.max(0, Math.min(CS.V.length - 1, tTier))]);
            }
            if (aAmount > 0L) {
                long rAmount = (long)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)(aAmount + (long)(aAmount * 4L > (long)aTier ? aTier : 0)), tTier, true, !aIgnoreDischargability, !aDoDecharge));
                return rAmount;
            }
        }
        return 0L;
    }

    @Override
    public long charge(ItemStack aStack, long aAmount, boolean aDoCharge) {
        return aAmount > 0L && ElectricItem.manager != null ? (long)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aAmount, Integer.MAX_VALUE, true, !aDoCharge)) : 0L;
    }

    @Override
    public long decharge(ItemStack aStack, long aAmount, boolean aDoDecharge) {
        return aAmount > 0L && ElectricItem.manager != null ? (long)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)aAmount, Integer.MAX_VALUE, true, false, !aDoDecharge)) : 0L;
    }

    @Override
    public byte tier(ItemStack aStack) {
        return UT.Code.bind4(((IElectricItem)aStack.func_77973_b()).getTier(aStack));
    }

    @Override
    public boolean insidevolt(ItemStack aStack, long aMinVolt, long aMaxVolt) {
        byte tTier = this.tier(aStack);
        return UT.Code.inside(aMinVolt, aMaxVolt, CS.VMIN[tTier]) || UT.Code.inside(aMinVolt, aMaxVolt, CS.VMAX[tTier]);
    }

    @Override
    public boolean provider(ItemStack aStack) {
        return ((IElectricItem)aStack.func_77973_b()).canProvideEnergy(aStack);
    }

    @Override
    public boolean is(ItemStack aStack) {
        return ST.valid(aStack) && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) < Integer.MAX_VALUE;
    }

    @Override
    public boolean is(ItemStack aStack, byte aTier) {
        return ST.valid(aStack) && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) == aTier;
    }

    @Override
    public long stored(ItemStack aStack) {
        return ElectricItem.manager != null ? (long)Math.max(0.0, ElectricItem.manager.discharge(aStack, 9.223372036854776E18, Integer.MAX_VALUE, true, false, true)) : 0L;
    }

    @Override
    public long capacity(ItemStack aStack) {
        return (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
    }
}

