/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentController;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverControllerDisplay
extends AbstractCoverAttachmentController {
    public static final ITexture[][] sTextures = new ITexture[][]{{BlockTextureDefault.get("machines/covers/statusdisplay/bottom/1_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/1_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/2_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/2_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/3_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/3_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/4_off", false), BlockTextureDefault.get("machines/covers/statusdisplay/bottom/4_on", false), null, null}, {BlockTextureDefault.get("machines/covers/statusdisplay/top/1_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/1_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/2_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/2_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/3_off", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/3_on", true), BlockTextureDefault.get("machines/covers/statusdisplay/top/4_off", false), BlockTextureDefault.get("machines/covers/statusdisplay/top/4_on", false), null, null}};
    public static final ITexture[] sTexturesBase = new ITexture[]{BlockTextureDefault.get("machines/covers/statusdisplay/bottom/base"), BlockTextureDefault.get("machines/covers/statusdisplay/top/base")};

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof ITileEntityRunningPossible) && !(aData.mTileEntity instanceof ITileEntitySwitchableOnOff);
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("chisel") && sTexturesBase.length > 1) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] & 0x3FF | ((aData.mVisuals[aSide] >>> 10) + 1) % sTexturesBase.length << 10));
            return 100L;
        }
        return aData.mTileEntity.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide) {
            short rVisuals = (short)(aData.mVisuals[aSide] & 0xFFFFFC00);
            if (aData.mTileEntity instanceof ITileEntityRunningPossible) {
                rVisuals = (short)(rVisuals | CS.B[5]);
                if (((ITileEntityRunningPossible)((Object)aData.mTileEntity)).getStateRunningPossible()) {
                    rVisuals = (short)(rVisuals | CS.B[0]);
                }
            }
            if (aData.mTileEntity instanceof ITileEntityRunningPassively) {
                rVisuals = (short)(rVisuals | CS.B[6]);
                if (((ITileEntityRunningPassively)((Object)aData.mTileEntity)).getStateRunningPassively()) {
                    rVisuals = (short)(rVisuals | CS.B[1]);
                }
            }
            if (aData.mTileEntity instanceof ITileEntityRunningActively) {
                rVisuals = (short)(rVisuals | CS.B[7]);
                if (((ITileEntityRunningActively)((Object)aData.mTileEntity)).getStateRunningActively()) {
                    rVisuals = (short)(rVisuals | CS.B[2]);
                }
            }
            if (aData.mTileEntity instanceof ITileEntitySwitchableOnOff) {
                rVisuals = (short)(rVisuals | CS.B[8]);
                if (((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).getStateOnOff()) {
                    rVisuals = (short)(rVisuals | CS.B[3]);
                }
            }
            aData.visual(aSide, rVisuals);
        }
    }

    @Override
    public boolean onCoverClickedRight(byte aSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aSide == aSideClicked && aData.mTileEntity instanceof ITileEntitySwitchableOnOff) {
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSideClicked, aHitX, aHitY, aHitZ);
            switch ((short)((aData.mVisuals[aSide] >>> 10) % sTexturesBase.length)) {
                case 0: {
                    if (!(tCoords[0] >= CS.PX_N[6]) || !(tCoords[1] >= CS.PX_N[4])) break;
                    if (aData.mTileEntity.isServerSide()) {
                        ((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).setStateOnOff(!((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).getStateOnOff());
                    }
                    return true;
                }
                case 1: {
                    if (!(tCoords[0] >= CS.PX_N[6]) || !(tCoords[1] <= CS.PX_P[4])) break;
                    if (aData.mTileEntity.isServerSide()) {
                        ((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).setStateOnOff(!((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).getStateOnOff());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        short tVisuals = aData.mVisuals[aSide];
        short tStyle = (short)((tVisuals >>> 10) % sTexturesBase.length);
        ITexture[] iTextureArray = new ITexture[6];
        iTextureArray[0] = sTexturesBase[tStyle];
        ITexture iTexture = (tVisuals & CS.B[5]) != 0 ? sTextures[tStyle][(tVisuals & CS.B[0]) != 0 ? 1 : 0] : (iTextureArray[1] = null);
        ITexture iTexture2 = (tVisuals & CS.B[6]) != 0 ? sTextures[tStyle][(tVisuals & CS.B[1]) != 0 ? 3 : 2] : (iTextureArray[2] = null);
        ITexture iTexture3 = (tVisuals & CS.B[7]) != 0 ? sTextures[tStyle][(tVisuals & CS.B[2]) != 0 ? 5 : 4] : (iTextureArray[3] = null);
        ITexture iTexture4 = (tVisuals & CS.B[8]) != 0 ? sTextures[tStyle][(tVisuals & CS.B[3]) != 0 ? 7 : 6] : (iTextureArray[4] = null);
        iTextureArray[5] = (tVisuals & CS.B[9]) != 0 ? sTextures[tStyle][(tVisuals & CS.B[4]) != 0 ? 9 : 8] : null;
        return BlockTextureMulti.get(iTextureArray);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.get("gt.lang.use.chisel.to.switch.design"));
    }

    @Override
    public boolean getStateOnOff(byte aSide, CoverData aData) {
        return ((ITileEntitySwitchableOnOff)((Object)aData.mTileEntity)).getStateOnOff();
    }
}

