/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.ICondition;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AdvancedCrafting1ToY
implements ICraftingRecipeGT {
    public final ICondition mCondition;
    public final OreDictPrefix mInput;
    public final OreDictPrefix mOutput;
    public final boolean mAutoCraftable;
    public final int mOutputCount;
    public final int mEmpty;

    public AdvancedCrafting1ToY(OreDictPrefix aInput, OreDictPrefix aOutput, int aOutputCount, boolean aAutoCraftable) {
        this(aInput, aOutput, aOutputCount, aAutoCraftable, MT.NULL.NOT);
    }

    public AdvancedCrafting1ToY(OreDictPrefix aInput, OreDictPrefix aOutput, int aOutputCount, boolean aAutoCraftable, ICondition aCondition) {
        this.mAutoCraftable = aAutoCraftable;
        this.mCondition = aCondition;
        this.mInput = aInput;
        this.mEmpty = this.mInput.mShapelessManagersSingle.size();
        this.mOutput = aOutput;
        this.mOutputCount = aOutputCount;
        this.mInput.mShapelessManagersSingle.add(this);
        List<IRecipe> tRecipeList = CR.list();
        try {
            for (int i = 0; i < tRecipeList.size(); ++i) {
                OreDictItemData tData;
                IRecipe tRecipe = tRecipeList.get(i);
                if (tRecipe == null) {
                    tRecipeList.remove(i--);
                    continue;
                }
                int tCount = 0;
                if (!(tRecipeList.get(i) instanceof ICraftingRecipeGT)) {
                    Object object;
                    OreDictItemData tData2;
                    Object tInputs;
                    if (tRecipe instanceof ShapedOreRecipe) {
                        tInputs = ((ShapedOreRecipe)tRecipe).getInput();
                        if (tInputs != null) {
                            for (Object tObject : tInputs) {
                                if (tObject == null) continue;
                                if (++tCount > 1) {
                                    tCount = 0;
                                } else if (tObject instanceof ItemStack) {
                                    tData2 = OM.data((ItemStack)tObject);
                                    if (tData2 != null && tData2.mPrefix == this.mInput && tData2.mMaterial != null && this.mCondition.isTrue(tData2.mMaterial.mMaterial)) continue;
                                    tCount = 0;
                                } else if (tObject instanceof List) {
                                    if (((List)tObject).isEmpty()) {
                                        tCount = 0;
                                    } else {
                                        if (!(((List)tObject).get(0) instanceof ItemStack) || (tData2 = OM.data((ItemStack)((List)tObject).get(0))) != null && tData2.mPrefix == this.mInput && tData2.mMaterial != null && this.mCondition.isTrue(tData2.mMaterial.mMaterial)) continue;
                                        tCount = 0;
                                    }
                                } else {
                                    tCount = 0;
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapelessOreRecipe) {
                        tInputs = ((ShapelessOreRecipe)tRecipe).getInput();
                        if (tInputs != null && tInputs.size() == 1) {
                            object = tInputs.iterator();
                            while (object.hasNext()) {
                                OreDictItemData tData3;
                                Object tObject = object.next();
                                if (tObject == null) continue;
                                ++tCount;
                                if (tObject instanceof ItemStack) {
                                    tData3 = OM.data((ItemStack)tObject);
                                    if (tData3 != null && tData3.mPrefix == this.mInput && tData3.mMaterial != null && this.mCondition.isTrue(tData3.mMaterial.mMaterial)) continue;
                                    tCount = 0;
                                } else if (tObject instanceof List) {
                                    if (((List)tObject).isEmpty()) {
                                        tCount = 0;
                                    } else {
                                        if (!(((List)tObject).get(0) instanceof ItemStack) || (tData3 = OM.data((ItemStack)((List)tObject).get(0))) != null && tData3.mPrefix == this.mInput && tData3.mMaterial != null && this.mCondition.isTrue(tData3.mMaterial.mMaterial)) continue;
                                        tCount = 0;
                                    }
                                } else {
                                    tCount = 0;
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapedRecipes) {
                        tInputs = ((ShapedRecipes)tRecipe).field_77574_d;
                        if (tInputs != null) {
                            for (Object tObject : tInputs) {
                                if (tObject == null) continue;
                                if (++tCount > 1) {
                                    tCount = 0;
                                } else {
                                    tData2 = OM.data((ItemStack)tObject);
                                    if (tData2 != null && tData2.mPrefix == this.mInput && tData2.mMaterial != null && this.mCondition.isTrue(tData2.mMaterial.mMaterial)) continue;
                                    tCount = 0;
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapelessRecipes && (tInputs = ((ShapelessRecipes)tRecipe).field_77579_b) != null && tInputs.size() == 1) {
                        object = tInputs.iterator();
                        while (object.hasNext()) {
                            Object tObject = object.next();
                            if (tObject == null) continue;
                            ++tCount;
                            if (tObject instanceof ItemStack) {
                                OreDictItemData tData4 = OM.data((ItemStack)tObject);
                                if (tData4 != null && tData4.mPrefix == this.mInput && tData4.mMaterial != null && this.mCondition.isTrue(tData4.mMaterial.mMaterial)) continue;
                                tCount = 0;
                            } else {
                                tCount = 0;
                            }
                            break;
                        }
                    }
                }
                if (tCount != true || (tData = OM.data(tRecipe.func_77571_b())) == null || tData.mPrefix != this.mOutput) continue;
                tRecipeList.remove(i--);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        ItemStack tStack = null;
        OreDictMaterial rMaterial = null;
        int tInventorySize = aGrid.func_70302_i_();
        int tCounter = 0;
        int tEmpty = 0;
        if (tInventorySize < 1 + this.mEmpty) {
            return false;
        }
        for (int i = 0; i < tInventorySize; ++i) {
            tStack = aGrid.func_70301_a(i);
            if (ST.valid(tStack)) {
                OreDictItemData tData = OM.anydata_(tStack);
                if (tData == null || tData.mPrefix != this.mInput) {
                    return false;
                }
                if (rMaterial == null) {
                    rMaterial = tData.mMaterial.mMaterial;
                } else if (rMaterial != tData.mMaterial.mMaterial) {
                    return false;
                }
                ++tCounter;
                continue;
            }
            if (tCounter == 0) {
                ++tEmpty;
            }
            if (i - tCounter + 1 + this.mEmpty - tEmpty < tInventorySize) continue;
            return false;
        }
        return rMaterial != null && tCounter == 1 && tEmpty % this.mInput.mShapelessManagersSingle.size() == this.mEmpty && this.hasOutputFor(rMaterial);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        int j = aGrid.func_70302_i_();
        for (int i = 0; i < j; ++i) {
            OreDictItemData tData = OM.anydata(aGrid.func_70301_a(i));
            if (tData == null || tData.mMaterial == null || !this.mCondition.isTrue(tData.mMaterial.mMaterial)) continue;
            return this.mOutput.mat(tData.mMaterial.mMaterial, (long)this.mOutputCount);
        }
        return ERROR_OUTPUT.func_77946_l();
    }

    public boolean hasOutputFor(OreDictMaterial aMaterial) {
        return ST.valid(this.mOutput.mat(aMaterial, (long)this.mOutputCount)) && this.mCondition.isTrue(aMaterial);
    }

    @Override
    public boolean isRemovableByGT() {
        return false;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }

    public int func_77570_a() {
        return 1;
    }

    public ItemStack func_77571_b() {
        return ERROR_OUTPUT.func_77946_l();
    }
}

