/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen.dungeon;

import gregapi.block.IBlockPlacable;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.UT;
import gregapi.worldgen.WorldgenOresBedrock;
import gregapi.worldgen.dungeon.DungeonChunkRoomEmpty;
import gregapi.worldgen.dungeon.DungeonData;
import gregapi.worldgen.dungeon.WorldgenDungeonGT;

public class DungeonChunkRoomMiningBedrock
extends DungeonChunkRoomEmpty {
    @Override
    public boolean generate(DungeonData aData) {
        int tZ;
        int tX;
        if (aData.mTags.contains(WorldgenDungeonGT.TAG_MINING_BEDROCK) || !super.generate(aData)) {
            return false;
        }
        aData.mTags.add(WorldgenDungeonGT.TAG_MINING_BEDROCK);
        OreDictMaterial tMaterial = UT.Code.select(MT.Redstone, MT.Redstone, MT.S, MT.Fe2O3, MT.MnO2, MT.Apatite, MT.OREMATS.Molybdenite, MT.OREMATS.Bauxite, MT.OREMATS.Sphalerite, MT.OREMATS.Tetrahedrite, MT.OREMATS.Cassiterite, MT.OREMATS.Garnierite, MT.OREMATS.Galena);
        if (!WorldgenOresBedrock.generateVein(tMaterial, aData.mWorld, aData.mWorld.field_73011_w.field_76574_g, aData.mX, aData.mZ, aData.mRandom)) {
            return false;
        }
        boolean tBrass = aData.next1in2();
        for (int tY = 5 - aData.mY; tY < 0; ++tY) {
            for (int tX2 = 0; tX2 <= 15; ++tX2) {
                for (int tZ2 = 0; tZ2 <= 15; ++tZ2) {
                    if (tX2 == 0) {
                        aData.bricks(tX2, tY, tZ2);
                        continue;
                    }
                    if (tX2 == 15) {
                        aData.bricks(tX2, tY, tZ2);
                        continue;
                    }
                    if (tZ2 == 0) {
                        aData.bricks(tX2, tY, tZ2);
                        continue;
                    }
                    if (tZ2 == 15) {
                        aData.bricks(tX2, tY, tZ2);
                        continue;
                    }
                    if (tZ2 == 7 && tX2 == 2 && aData.mRoomLayout[aData.mRoomX - 1][aData.mRoomZ] != 0) {
                        aData.set(tX2, tY, tZ2, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)5, new Object[0]));
                        continue;
                    }
                    if (tZ2 == 7 && tX2 == 13 && aData.mRoomLayout[aData.mRoomX + 1][aData.mRoomZ] != 0) {
                        aData.set(tX2, tY, tZ2, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)4, new Object[0]));
                        continue;
                    }
                    if (tX2 == 7 && tZ2 == 2 && aData.mRoomLayout[aData.mRoomX][aData.mRoomZ - 1] != 0) {
                        aData.set(tX2, tY, tZ2, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)3, new Object[0]));
                        continue;
                    }
                    if (tX2 == 7 && tZ2 == 13 && aData.mRoomLayout[aData.mRoomX][aData.mRoomZ + 1] != 0) {
                        aData.set(tX2, tY, tZ2, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)2, new Object[0]));
                        continue;
                    }
                    if (tY == -1 && (tX2 == 2 || tX2 == 13 || tZ2 == 2 || tZ2 == 13)) {
                        aData.bricks(tX2, tY, tZ2);
                        continue;
                    }
                    aData.air(tX2, tY, tZ2);
                }
            }
        }
        for (tX = 2; tX <= 13; ++tX) {
            for (tZ = 2; tZ <= 13; ++tZ) {
                if (tX == 2) {
                    if (tZ != 2 && tZ != 13) {
                        aData.set(tX, 1, tZ, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 8);
                        aData.set(tX, 0, tZ, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)5, new Object[0]));
                        continue;
                    }
                    aData.lamp(tX, 0, tZ, -1);
                    continue;
                }
                if (tX == 13) {
                    if (tZ != 2 && tZ != 13) {
                        aData.set(tX, 1, tZ, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 4);
                        aData.set(tX, 0, tZ, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)4, new Object[0]));
                        continue;
                    }
                    aData.lamp(tX, 0, tZ, -1);
                    continue;
                }
                if (tZ == 2) {
                    aData.set(tX, 1, tZ, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 2);
                    aData.set(tX, 0, tZ, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)3, new Object[0]));
                    continue;
                }
                if (tZ == 13) {
                    aData.set(tX, 1, tZ, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 1);
                    aData.set(tX, 0, tZ, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)2, new Object[0]));
                    continue;
                }
                aData.air(tX, 0, tZ);
            }
        }
        if (aData.mRoomLayout[aData.mRoomX + 1][aData.mRoomZ] != 0 && aData.mRoomLayout[aData.mRoomX - 1][aData.mRoomZ] != 0) {
            aData.air(2, 1, 8);
            aData.air(13, 1, 8);
            for (tX = 3; tX <= 12; ++tX) {
                aData.set(tX, 0, 8, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)4, new Object[0]));
                aData.set(tX, 1, 8, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 3);
            }
        } else if (aData.mRoomLayout[aData.mRoomX][aData.mRoomZ + 1] != 0 && aData.mRoomLayout[aData.mRoomX][aData.mRoomZ - 1] != 0) {
            aData.air(8, 1, 2);
            aData.air(8, 1, 13);
            for (int tZ3 = 3; tZ3 <= 12; ++tZ3) {
                aData.set(8, 0, tZ3, tBrass ? 8408L : 8410L, UT.NBT.make("gt.facing", (Object)2, new Object[0]));
                aData.set(8, 1, tZ3, tBrass ? CS.BlocksGT.Bars_Brass : CS.BlocksGT.Bars_Steel, 12);
            }
        }
        for (tX = 5; tX <= 10; ++tX) {
            for (tZ = 5; tZ <= 10; ++tZ) {
                if ((tX == 5 || tX == 10) && (tZ == 5 || tZ == 10)) continue;
                aData.air(tX, 4 - aData.mY, tZ);
            }
        }
        for (tX = 6; tX <= 9; ++tX) {
            for (tZ = 6; tZ <= 9; ++tZ) {
                aData.air(tX, 3 - aData.mY, tZ);
            }
        }
        aData.set(6, 3 - aData.mY, 6, 32104L, UT.NBT.make("gt.facing", (Object)1, "gt.mode", true));
        aData.set(6, 3 - aData.mY, 9, 32713L, UT.NBT.make("gt.facing", (Object)1, "gt.mode", true));
        aData.set(9, 3 - aData.mY, 6, 32713L, UT.NBT.make("gt.facing", (Object)1, "gt.mode", true));
        aData.set(9, 3 - aData.mY, 9, 32712L, UT.NBT.make("gt.facing", (Object)1, "gt.mode", true));
        int[] tStart = new int[]{1, 11};
        int[] tEnd = new int[]{4, 14};
        for (int a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                for (int i = tStart[a]; i <= tEnd[a]; ++i) {
                    for (int j = tStart[b]; j <= tEnd[b]; ++j) {
                        if (!aData.next3in4()) continue;
                        aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i, 5 - aData.mY, j, (long)tMaterial.mID);
                        if (!aData.next2in3()) continue;
                        aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i, 6 - aData.mY, j, (long)tMaterial.mID);
                        if (!aData.next1in2()) continue;
                        aData.set((IBlockPlacable)CS.BlocksGT.blockRaw, i, 7 - aData.mY, j, (long)tMaterial.mID);
                    }
                }
            }
        }
        return true;
    }
}

