/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.machine;

import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import gregtech.items.behaviors.Behavior_Plunger_Fluid;
import gregtech.items.behaviors.Behavior_Plunger_Item;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;

public class GT_Tool_Plunger
extends ToolStats {
    @Override
    public float getBaseDamage() {
        return 1.25f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 0.25f;
    }

    @Override
    public String getCraftingSound() {
        return CS.SFX.IC_TRAMPOLINE;
    }

    @Override
    public String getEntityHitSound() {
        return CS.SFX.IC_TRAMPOLINE;
    }

    @Override
    public String getMiningSound() {
        return CS.SFX.IC_TRAMPOLINE;
    }

    @Override
    public boolean canCollect() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return "plunger".equalsIgnoreCase(aBlock.getHarvestTool((int)aMetaData)) || aBlock.func_149688_o() == Material.field_151566_D;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.PLUNGER : Textures.ItemIcons.VOID;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : CS.UNCOLOURED;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("plunger", CS.SFX.IC_TRAMPOLINE, 100L, !this.canBlock(), CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, new Behavior_Plunger_Item(this.getToolDamagePerDropConversion()));
        aItem.addItemBehavior(aID, new Behavior_Plunger_Fluid(this.getToolDamagePerDropConversion()));
        try {
            Object tObject = UT.Reflection.callConstructor("gregtech.common.items.behaviors.Behaviour_Plunger_Essentia", 0, null, false, this.getToolDamagePerDropConversion());
            if (tObject instanceof IBehavior) {
                aItem.addItemBehavior(aID, (IBehavior)tObject);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] got stuck trying to escape through a Pipe while fighting [KILLER]";
    }
}

