/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.b;

import gregapi.block.BlockBase;
import gregapi.block.metatype.BlockStones;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ICondition;
import gregapi.config.ConfigCategories;
import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.cover.covers.CoverTextureMulti;
import gregapi.cover.covers.CoverTextureSimple;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.item.IItemGT;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialCondition;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.oredict.event.IOreDictListenerEvent;
import gregapi.oredict.event.IOreDictListenerRecyclable;
import gregapi.oredict.event.OreDictListenerEvent_Names;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Loader_OreProcessing
implements Runnable {
    static final long RECIPE_BITS = CR.DEF_NCC | CR.ONLY_IF_HAS_RESULT;

    @Override
    public void run() {
        new OreDictListenerEvent_Names(){

            @Override
            public void addAllListeners() {
                final ITexture[] tStoneTextures = new ITexture[]{BlockTextureCopied.get(Blocks.field_150348_b, 0), BlockTextureCopied.get(Blocks.field_150347_e, 0), BlockTextureCopied.get(Blocks.field_150341_Y, 0), BlockTextureCopied.get(Blocks.field_150417_aV, 0), BlockTextureCopied.get(Blocks.field_150417_aV, 1), BlockTextureCopied.get(Blocks.field_150417_aV, 2), BlockTextureCopied.get(Blocks.field_150417_aV, 3), BlockTextureCopied.get((Block)Blocks.field_150334_T, 1, 0), BlockTextureCopied.get((Block)Blocks.field_150334_T, 3, 0)};
                this.addListener(OP.plate.dat(MT.Stone).toString(), new IOreDictListenerEvent(){

                    @Override
                    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                        CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureMulti(true, false, "dig.stone", tStoneTextures));
                    }
                });
                this.addListener(OP.plate.dat(MT.Netherrack).toString(), new IOreDictListenerEvent(){

                    @Override
                    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                        CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(MT.Netherrack.getTextureSolid(), "dig.stone"));
                    }
                });
                this.addListener(OP.plate.dat(MT.NetherBrick).toString(), new IOreDictListenerEvent(){

                    @Override
                    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                        CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(MT.NetherBrick.getTextureSolid(), "dig.stone"));
                    }
                });
                this.addListener(OP.plate.dat(MT.Endstone).toString(), new IOreDictListenerEvent(){

                    @Override
                    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                        CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(MT.Endstone.getTextureSolid(), "dig.stone"));
                    }
                });
                this.addListener(OP.plate.dat(MT.Obsidian).toString(), new IOreDictListenerEvent(){

                    @Override
                    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                        CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(MT.Obsidian.getTextureSolid(), "dig.stone"));
                    }
                });
                for (BlockBase tBlock : CS.BlocksGT.stones) {
                    BlockStones tStone = (BlockStones)tBlock;
                    final ITexture[] tTextures = new ITexture[16];
                    for (int i = 0; i < tTextures.length; ++i) {
                        tTextures[i] = BlockTextureDefault.get(tStone.mIcons[i]);
                    }
                    this.addListener(OP.plate.dat(tStone.mMaterial).toString(), new IOreDictListenerEvent(){

                        @Override
                        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                            CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureMulti(true, false, "dig.stone", tTextures));
                        }
                    });
                }
            }
        };
        OP.plate.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.casingMachine, OP.blockDust, OP.blockRaw));
        OP.plateDouble.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineDouble, OP.blockPlate, OP.blockSolid, OP.blockIngot, OP.blockDust, OP.blockRaw));
        OP.plateTriple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockPlate, OP.blockSolid, OP.blockIngot, OP.casingMachineDouble, OP.blockDust, OP.blockRaw));
        OP.plateQuadruple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockIngot, OP.blockPlate, OP.blockSolid, OP.casingMachineQuadruple, OP.blockDust, OP.blockRaw));
        OP.plateQuintuple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineQuadruple, OP.blockIngot, OP.blockPlate, OP.blockSolid, OP.blockDust, OP.blockRaw));
        OP.plateDense.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineDense, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.blockDust, OP.blockRaw));
        OP.plateCurved.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachine, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.blockDust, OP.blockRaw));
        OP.plateGem.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockGem, OP.blockPlateGem, OP.blockDust, OP.blockRaw));
        OP.sheetGt.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.casingMachine, OP.blockDust, OP.blockRaw));
        OP.foil.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.foil));
        OP.rawOreChunk.addListener(new OreProcessing_Maceration(OP.crushedTiny, 3L, TD.Atomic.ANTIMATTER.NOT));
        OP.chunk.addListener(new OreProcessing_Maceration(OP.dust, 2L, TD.Atomic.ANTIMATTER.NOT));
        OP.rubble.addListener(new OreProcessing_Maceration(OP.dust, 2L, TD.Atomic.ANTIMATTER.NOT));
        OP.pebbles.addListener(new OreProcessing_Maceration(OP.dust, 3L, TD.Atomic.ANTIMATTER.NOT));
        OP.cluster.addListener(new OreProcessing_Maceration(OP.dust, 3L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushed.addListener(new OreProcessing_Maceration(OP.dust, 1L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushedPurified.addListener(new OreProcessing_Maceration(OP.dust, 1L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushedPurifiedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushedCentrifuged.addListener(new OreProcessing_Maceration(OP.dustTiny, 11L, TD.Atomic.ANTIMATTER.NOT));
        OP.crushedCentrifugedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, TD.Atomic.ANTIMATTER.NOT));
        OP.chemtube.addListener(new OreProcessing_GlassTube(-1L, TD.Atomic.ANTIMATTER.NOT));
        OP.plantGtBerry.addListener(new OreProcessing_PlantSqueezing(-1L, TD.Atomic.ANTIMATTER.NOT));
        OP.plantGtTwig.addListener(new OreProcessing_PlantSqueezing(-1L, TD.Atomic.ANTIMATTER.NOT));
        OP.plantGtFiber.addListener(new OreProcessing_PlantSqueezing(-1L, TD.Atomic.ANTIMATTER.NOT));
        OP.plantGtWart.addListener(new OreProcessing_PlantSqueezing(-1L, TD.Atomic.ANTIMATTER.NOT));
        OP.plantGtBlossom.addListener(new OreProcessing_PlantSqueezing(-1L, TD.Atomic.ANTIMATTER.NOT));
        String tCategory = (Object)((Object)ConfigCategories.Recipes.gregtechrecipes) + ".";
        OP.rotor.addListener(new OreProcessing_CraftFrom(1L, tCategory + "rotor", new String[][]{{"YhY", "TXf", "YdY"}}, OP.ring, OP.plateCurved, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, TD.Processing.SMITHABLE)));
        OP.toolHeadBuzzSaw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "toolHeadBuzzSaw", new String[][]{{"wPh", "P P", "fPx"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.toolHeadBuzzSaw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "toolHeadBuzzSaw", new String[][]{{"wCh", "C C", "fCx"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.gearGt.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XYX", "YfY", "XYX"}}, OP.rockGt, OP.stone, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, TD.Properties.STONE, MT.Stone.NOT, MT.Bedrock.NOT)));
        OP.gearGt.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XYX", "YfY", "XYX"}}, OP.stick, OP.stone, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, TD.Properties.STONE, MT.Stone.NOT, MT.Bedrock.NOT)));
        OP.gearGt.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XYX", "YwY", "XYX"}}, OP.stick, OP.plate, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, TD.Processing.SMITHABLE)));
        OP.gearGtSmall.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"X ", " s"}}, OP.plank, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, MT.Wood.NOT)));
        OP.casingMachine.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plate, OP.stickLong, null, null, null, TD.Atomic.ANTIMATTER.NOT));
        OP.casingMachineDouble.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateDouble, OP.stickLong, null, null, null, TD.Atomic.ANTIMATTER.NOT));
        OP.casingMachineQuadruple.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateQuadruple, OP.stickLong, null, null, null, TD.Atomic.ANTIMATTER.NOT));
        OP.casingMachineDense.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateDense, OP.stickLong, null, null, null, TD.Atomic.ANTIMATTER.NOT));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemFlawless, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemExquisite, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemLegendary, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stick.addListener(new OreProcessing_CraftFrom(2L, tCategory + "stickLong2stick", new String[][]{{"s ", " X"}}, OP.stickLong, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stick.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gem, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stick.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemFlawless, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stick.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemExquisite, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.stick.addListener(new OreProcessing_CraftFrom(8L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemLegendary, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.bolt.addListener(new OreProcessing_CraftFrom(2L, tCategory + "stick2bolt", new String[][]{{"s ", " S"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, MT.Wood.NOT)));
        OP.screw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "bolt2screw", new String[][]{{"fX", "X "}}, OP.bolt, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.ring.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2ring", new String[][]{{"f ", " X"}}, OP.gem, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.round.addListener(new OreProcessing_CraftFrom(1L, tCategory + "chunk2round", new String[][]{{"f ", " X"}}, OP.chunkGt, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.wireFine.addListener(new OreProcessing_CraftFrom(1L, tCategory + "foil2wireFine", new String[][]{{"Xx"}}, OP.foil, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.wireGt01.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plate2wire", new String[][]{{"Px"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "plate2plateTiny", new String[][]{{"s ", " P"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT, MT.Paper.NOT, MT.Wood.NOT)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "plate2plateTiny", new String[][]{{"s ", " C"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemChipped, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemFlawed, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gem, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemFlawless, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(3L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemExquisite, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(7L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemLegendary, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(3L, tCategory + "boule2plateGem", new String[][]{{"s ", " X"}}, OP.bouleGt, null, null, null, null, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.minecartWheels.addListener(new OreProcessing_CraftFrom(1L, tCategory + "minecartWheels", new String[][]{{" h ", "XSX", " w "}}, OP.ring, null, null, null, null, TD.Atomic.ANTIMATTER.NOT));
        OP.arrowGtWood.addListener(new OreProcessing_Shapeless(1L, tCategory + "arrowsWooden", new Object[]{OP.toolHeadArrow, OP.arrowGtWood.dat(MT.Empty)}, TD.Atomic.ANTIMATTER.NOT));
        OP.arrowGtPlastic.addListener(new OreProcessing_Shapeless(1L, tCategory + "arrowsPlastic", new Object[]{OP.toolHeadArrow, OP.arrowGtPlastic.dat(MT.Empty)}, TD.Atomic.ANTIMATTER.NOT));
        OP.cableGt01.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt01, OP.plate.dat(ANY.Rubber)}, TD.Atomic.ANTIMATTER.NOT));
        OP.cableGt02.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt02, OP.plate.dat(ANY.Rubber)}, TD.Atomic.ANTIMATTER.NOT));
        OP.chemtube.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.dustTiny, OP.chemtube.mat(MT.Empty, 1L)}, ICondition.TRUE));
        OP.dustTiny.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.chemtube}, OreDictMaterialCondition.meltmin(293L)));
        OP.toolHeadRawUniversalSpade.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadShovel, "craftingToolFile", "craftingToolSaw"}, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.toolHeadRawUniversalSpade.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadSpade, "craftingToolFile", "craftingToolSaw"}, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.toolHeadConstructionPickaxe.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadRawPickaxe, "craftingToolFile", "craftingToolHardHammer"}, new ICondition.And<OreDictMaterial>(TD.Atomic.ANTIMATTER.NOT, TD.Compounds.COATED.NOT)));
        OP.toolHeadPickaxeGem.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadRawPickaxe.dat(ANY.Iron), OP.gemFlawed, OP.gemFlawed, "craftingToolFile", "craftingToolHardHammer", "craftingToolSaw"}, TD.Atomic.ANTIMATTER.NOT));
        OP.toolHeadPickaxeGem.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadPickaxe.dat(ANY.Iron), OP.gemFlawed, OP.gemFlawed, "craftingToolFile", "craftingToolHardHammer", "craftingToolSaw"}, TD.Atomic.ANTIMATTER.NOT));
        OP.toolHeadPickaxeGem.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadPickaxeGem.dat(MT.Empty), OP.gemFlawed, OP.gemFlawed, "craftingToolFile", "craftingToolHardHammer", "craftingToolSaw"}, TD.Atomic.ANTIMATTER.NOT));
        CR.shaped(OP.bolt.mat(MT.Wood, 2L), RECIPE_BITS, "s ", " S", 'S', IL.Stick);
        OreProcessing_Ore tProcessor = new OreProcessing_Ore();
        for (OreDictPrefix tPrefix : OreDictPrefix.VALUES) {
            if (!tPrefix.contains(TD.Prefix.ORE) || tPrefix.contains(TD.Prefix.IS_CONTAINER) || tPrefix == OP.oreBedrock || tPrefix == OP.orePoor || tPrefix == OP.oreSmall || tPrefix == OP.oreRich || tPrefix == OP.oreNormal) continue;
            tPrefix.addListener(tProcessor);
        }
        OreDictManager.INSTANCE.addListener(new RecyclingProcessing());
    }

    public static class OreProcessing_CraftFrom
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final String[][] mRecipes;
        private final String mCategoryName;
        private final OreDictPrefix mSpecialPrefix1;
        private final OreDictPrefix mSpecialPrefix2;
        private final OreDictPrefix mSpecialPrefix3;
        private final Object mSpecialObject1;
        private final Object mSpecialObject2;
        private final long mOutputAmount;

        public OreProcessing_CraftFrom(long aOutputAmount, String aCategoryName, String[][] aRecipes, OreDictPrefix aSpecialPrefix1, OreDictPrefix aSpecialPrefix2, OreDictPrefix aSpecialPrefix3, Object aSpecialObject1, Object aSpecialObject2, ICondition<OreDictMaterial> aCondition) {
            this.mSpecialPrefix1 = aSpecialPrefix1 == null ? OP.plate : aSpecialPrefix1;
            this.mSpecialPrefix2 = aSpecialPrefix2 == null ? OP.plate : aSpecialPrefix2;
            this.mSpecialPrefix3 = aSpecialPrefix3 == null ? OP.plate : aSpecialPrefix3;
            this.mSpecialObject1 = aSpecialObject1;
            this.mSpecialObject2 = aSpecialObject2;
            this.mOutputAmount = aOutputAmount;
            this.mRecipes = aRecipes;
            this.mCondition = aCondition;
            this.mCategoryName = aCategoryName;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mNotAlreadyRegisteredName && this.mCondition.isTrue(aEvent.mMaterial) && (this.mCategoryName == null || CS.ConfigsGT.RECIPES.get((Object)this.mCategoryName, aEvent.mMaterial.mNameInternal, true))) {
                for (int i = 0; i < this.mRecipes.length; ++i) {
                    if (this.mRecipes[i] == null || this.mRecipes[i].length <= 0) continue;
                    if (this.mRecipes[i].length == 1) {
                        CR.shaped(aEvent.mPrefix.mat(aEvent.mMaterial, this.mOutputAmount, ST.amount(this.mOutputAmount, aEvent.mStack)), RECIPE_BITS, new Object[]{this.mRecipes[i][0], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), this.mSpecialPrefix1 == OP.plateDense && MD.HBM.mLoaded && aEvent.mMaterial == MT.Pb ? this.mSpecialPrefix1.mat(aEvent.mMaterial, 1L) : this.mSpecialPrefix1.dat(aEvent.mMaterial), Character.valueOf('Y'), this.mSpecialPrefix2.dat(aEvent.mMaterial), Character.valueOf('Z'), this.mSpecialPrefix3.dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                        continue;
                    }
                    if (this.mRecipes[i].length == 2) {
                        CR.shaped(aEvent.mPrefix.mat(aEvent.mMaterial, this.mOutputAmount, ST.amount(this.mOutputAmount, aEvent.mStack)), RECIPE_BITS, new Object[]{this.mRecipes[i][0], this.mRecipes[i][1], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), this.mSpecialPrefix1 == OP.plateDense && MD.HBM.mLoaded && aEvent.mMaterial == MT.Pb ? this.mSpecialPrefix1.mat(aEvent.mMaterial, 1L) : this.mSpecialPrefix1.dat(aEvent.mMaterial), Character.valueOf('Y'), this.mSpecialPrefix2.dat(aEvent.mMaterial), Character.valueOf('Z'), this.mSpecialPrefix3.dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                        continue;
                    }
                    CR.shaped(aEvent.mPrefix.mat(aEvent.mMaterial, this.mOutputAmount, ST.amount(this.mOutputAmount, aEvent.mStack)), RECIPE_BITS, new Object[]{this.mRecipes[i][0], this.mRecipes[i][1], this.mRecipes[i][2], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OD.plankWood : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), this.mSpecialPrefix1 == OP.plateDense && MD.HBM.mLoaded && aEvent.mMaterial == MT.Pb ? this.mSpecialPrefix1.mat(aEvent.mMaterial, 1L) : this.mSpecialPrefix1.dat(aEvent.mMaterial), Character.valueOf('Y'), this.mSpecialPrefix2.dat(aEvent.mMaterial), Character.valueOf('Z'), this.mSpecialPrefix3.dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                }
            }
        }
    }

    public static class OreProcessing_Shapeless
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final String mCategoryName;
        private final Object[] mRecipe;
        private final long mOutputAmount;

        public OreProcessing_Shapeless(long aOutputAmount, String aCategoryName, Object[] aRecipe, ICondition<OreDictMaterial> aCondition) {
            this.mOutputAmount = aOutputAmount;
            this.mRecipe = aRecipe;
            this.mCondition = aCondition;
            this.mCategoryName = aCategoryName;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mNotAlreadyRegisteredName && this.mCondition.isTrue(aEvent.mMaterial) && (this.mCategoryName == null || CS.ConfigsGT.RECIPES.get((Object)this.mCategoryName, aEvent.mMaterial.mNameInternal, true))) {
                Object[] tRecipe = new Object[this.mRecipe.length];
                for (int i = 0; i < tRecipe.length; ++i) {
                    tRecipe[i] = this.mRecipe[i] instanceof OreDictPrefix ? ((OreDictPrefix)this.mRecipe[i]).dat(aEvent.mMaterial) : this.mRecipe[i];
                }
                CR.shapeless(ST.amount(this.mOutputAmount, aEvent.mStack), RECIPE_BITS, tRecipe);
            }
        }
    }

    public static class OreProcessing_Decomposition
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final Recipe.RecipeMap mTargetRecipeMap;

        public OreProcessing_Decomposition(Recipe.RecipeMap aTargetRecipeMap, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mTargetRecipeMap = aTargetRecipeMap;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            IOreDictConfigurationComponent tComponents;
            if (this.mCondition.isTrue(aEvent.mMaterial) && (tComponents = aEvent.mMaterial.mComponents) != null && tComponents.getCommonDivider() <= 64L) {
                ArrayListNoNulls<ItemStack> tStackOutputs = new ArrayListNoNulls<ItemStack>();
                ArrayListNoNulls<FluidStack> tFluidOutputs = new ArrayListNoNulls<FluidStack>();
                long tAmount = 0L;
                for (OreDictMaterialStack tMaterial : tComponents.getUndividedComponents()) {
                    tAmount += tMaterial.mAmount;
                    if ((tMaterial.mMaterial.mMeltingPoint > 293L || !tFluidOutputs.add(tMaterial.mMaterial.fluid(293L, tMaterial.mAmount, false))) && !tStackOutputs.add(OM.dust(tMaterial.mMaterial, tMaterial.mAmount))) continue;
                }
                while (tStackOutputs.size() > this.mTargetRecipeMap.mOutputItemsCount) {
                    tStackOutputs.remove(tStackOutputs.size() - 1);
                }
                while (tFluidOutputs.size() > this.mTargetRecipeMap.mOutputFluidCount) {
                    tFluidOutputs.remove(tFluidOutputs.size() - 1);
                }
                if (tStackOutputs.size() > 0 || tFluidOutputs.size() > 0) {
                    this.mTargetRecipeMap.addRecipe(true, ST.array(ST.amount(tComponents.getCommonDivider(), aEvent.mStack)), tStackOutputs.toArray(CS.ZL_IS), CS.NI, CS.ZL_LONG, CS.ZL_FS, tFluidOutputs.toArray(CS.ZL_FS), UT.Code.units(tAmount, 648648000L, 256L, true), tAmount * 16L / 648648000L, 0L);
                }
            }
        }
    }

    public static class OreProcessing_PlantSqueezing
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final long mOutputMaterialAmount;

        public OreProcessing_PlantSqueezing(long aOutputMaterialAmount, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mOutputMaterialAmount = aOutputMaterialAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                FluidStack tFluid = aEvent.mMaterial.fluid(293L, this.mOutputMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mOutputMaterialAmount, false);
                ItemStack tStack = OM.dust(aEvent.mMaterial, this.mOutputMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mOutputMaterialAmount);
                if (FL.zero(tFluid)) {
                    tFluid = null;
                }
                if (tStack != null || tFluid != null) {
                    RM.Squeezer.addRecipe1(true, 16L, UT.Code.units(aEvent.mPrefix.mAmount, 648648000L, 256 + 256 * aEvent.mMaterial.mToolQuality, true), aEvent.mStack, CS.NF, tFluid, new ItemStack[]{tFluid == null ? tStack : null});
                }
            }
        }
    }

    public static class OreProcessing_GlassTube
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final long mMaterialAmount;

        public OreProcessing_GlassTube(long aOutputMaterialAmount, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mMaterialAmount = aOutputMaterialAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial) && aEvent.mMaterial != MT.Empty) {
                ItemStack tStack = OM.dust(aEvent.mMaterial, this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount);
                FluidStack tFluid1 = aEvent.mMaterial.fluid(293L, this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, false);
                FluidStack tFluid2 = aEvent.mMaterial.fluid(293L, this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, true);
                if (FL.zero(tFluid1)) {
                    tFluid1 = aEvent.mMaterial.liquid(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, false);
                    tFluid2 = aEvent.mMaterial.liquid(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, true);
                }
                if (FL.zero(tFluid1)) {
                    tFluid1 = aEvent.mMaterial.gas(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, false);
                    tFluid2 = aEvent.mMaterial.gas(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, true);
                }
                if (FL.zero(tFluid1)) {
                    tFluid1 = aEvent.mMaterial.plasma(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, false);
                    tFluid2 = aEvent.mMaterial.plasma(this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, true);
                }
                if (FL.zero(tFluid1)) {
                    tFluid1 = null;
                    tFluid2 = null;
                }
                if (tStack != null) {
                    RM.Canner.addRecipe2(true, 16L, 16L, tStack, aEvent.mPrefix.mat(MT.Empty, 1L), aEvent.mStack);
                    if (tFluid1 == null || tFluid2 == null || aEvent.mMaterial.mMeltingPoint > 293L) {
                        RM.Canner.addRecipe1(true, 16L, 16L, aEvent.mStack, aEvent.mPrefix.mat(MT.Empty, 1L), tStack);
                    }
                }
                if (tFluid1 != null && tFluid2 != null) {
                    RM.Canner.addRecipe1(true, 16L, 16L, aEvent.mPrefix.mat(MT.Empty, 1L), tFluid2, CS.NF, aEvent.mStack);
                    if (tStack == null || aEvent.mMaterial.mMeltingPoint <= 293L) {
                        RM.Canner.addRecipe1(true, 16L, 16L, aEvent.mStack, CS.NF, tFluid1, aEvent.mPrefix.mat(MT.Empty, 1L));
                    }
                }
            }
        }
    }

    public static class OreProcessing_Maceration
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final OreDictPrefix mTargetPrefix;
        private final long mAmount;

        public OreProcessing_Maceration(OreDictPrefix aTargetPrefix, long aAmount, ICondition<OreDictMaterial> aCondition) {
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
            this.mAmount = aAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                RM.pulverizing(aEvent.mStack, this.mTargetPrefix.mat(aEvent.mMaterial, this.mAmount));
            }
        }
    }

    public static class OreProcessing_Ore
    implements IOreDictListenerEvent {
        private ArrayList<OreDictMaterial> mAlreadyListedOres = new ArrayListNoNulls<OreDictMaterial>(1000);

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mMaterial == MT.Oilsands) {
                RM.Centrifuge.addRecipe1(true, 16L, UT.Code.units(aEvent.mPrefix.mWeight, 648648000L, 64L, true), aEvent.mStack, CS.NF, FL.Oil_Normal.make(UT.Code.units(aEvent.mPrefix.mWeight, 648648000L, 250L, true)), OM.dust(MT.Sand, aEvent.mPrefix.mWeight * 2L), OM.dust(aEvent.mPrefix.byproduct(0)), OM.dust(aEvent.mPrefix.byproduct(1)), OM.dust(aEvent.mPrefix.byproduct(2)), OM.dust(aEvent.mPrefix.byproduct(3)), OM.dust(aEvent.mPrefix.byproduct(4)));
            } else {
                this.registerStandardOreRecipes(aEvent.mPrefix, aEvent.mMaterial, aEvent.mStack, aEvent.mMaterial.mOreProcessingMultiplier * (aEvent.mPrefix.contains(TD.Prefix.DENSE_ORE) ? 2 : 1));
            }
        }

        private boolean registerStandardOreRecipes(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aOreStack, int aMultiplier) {
            if (aOreStack == null || aMaterial == null || IL.PFAA_Sands.equal(aOreStack, true, true)) {
                return false;
            }
            if (CS.COMPAT_IC2 != null && !(aOreStack.func_77973_b() instanceof IItemGT)) {
                CS.COMPAT_IC2.valuable(ST.block(aOreStack), ST.meta_(aOreStack), 2);
            }
            if ((aMaterial = aMaterial.mTargetCrushing.mMaterial) == null) {
                return false;
            }
            aOreStack = ST.amount(1L, aOreStack);
            aMultiplier = UT.Code.bindStack(aMaterial.mOreMultiplier * aMultiplier);
            ItemStack tPrimaryByProductTiny = null;
            ItemStack tSecondaryByProductTiny = null;
            ItemStack tTertiaryByProductTiny = null;
            if (aMaterial == MT.STONES.Gneiss || aMaterial == MT.PetrifiedWood) {
                RM.Crusher.addRecipe1(true, 16L, 64L, aOreStack, OP.rockGt.mat(aMaterial, (long)UT.Code.bindStack(aMaterial.mOreMultiplier * aMultiplier * 4)));
                RM.Hammer.addRecipe1(true, 16L, 64L, aOreStack, OP.rockGt.mat(aMaterial, (long)UT.Code.bindStack(aMaterial.mOreMultiplier * aMultiplier * 3)));
            }
            ArrayListNoNulls<ItemStack> tByProductStacks = new ArrayListNoNulls<ItemStack>();
            for (OreDictMaterial tMat : aMaterial.mByProducts) {
                ItemStack tByProduct = OM.dustOrIngot(tMat, 648648000L);
                if (tByProduct != null) {
                    ((ArrayList)tByProductStacks).add(tByProduct);
                }
                if (tPrimaryByProductTiny == null) {
                    tPrimaryByProductTiny = OM.dustOrIngot(tMat, 0x44BBB40L);
                    continue;
                }
                if (tSecondaryByProductTiny == null) {
                    tSecondaryByProductTiny = OM.dustOrIngot(tMat, 0x44BBB40L);
                    continue;
                }
                if (tTertiaryByProductTiny != null) continue;
                tTertiaryByProductTiny = OM.dustOrIngot(tMat, 0x44BBB40L);
            }
            if (!tByProductStacks.isEmpty() && !this.mAlreadyListedOres.contains(aMaterial)) {
                this.mAlreadyListedOres.add(aMaterial);
                RM.ByProductList.addFakeRecipe(false, ST.array(OP.oreVanillastone.mat(aMaterial, aOreStack, 1L), OP.oreRaw.mat(aMaterial, 1L), OP.rockGt.mat(aMaterial, 1L), OP.crushed.mat(aMaterial, 1L), OP.crushedPurified.mat(aMaterial, 1L), OP.crushedCentrifuged.mat(aMaterial, 1L)), tByProductStacks.toArray(CS.ZL_IS), null, null, null, null, 0L, 0L, 0L);
            }
            if (tPrimaryByProductTiny == null) {
                tPrimaryByProductTiny = OM.dustOrIngot(aMaterial, 0x44BBB40L);
            }
            if (tSecondaryByProductTiny == null) {
                tSecondaryByProductTiny = tPrimaryByProductTiny;
            }
            if (tTertiaryByProductTiny == null) {
                tTertiaryByProductTiny = tSecondaryByProductTiny;
            }
            if (aMaterial.contains(TD.Processing.FURNACE)) {
                boolean tIsFood = aMaterial.mTargetSmelting.mMaterial.contains(TD.Properties.FOOD);
                if (!RM.add_smelting(aOreStack, OM.ingot(aMaterial.mTargetSmelting), false, tIsFood, !tIsFood)) {
                    RM.add_smelting(aOreStack, OM.gem(aMaterial.mTargetSmelting), false, tIsFood, !tIsFood);
                }
            }
            if (aPrefix.contains(TD.Prefix.DUST_ORE)) {
                RM.Sifting.addRecipe1(true, 16L, 256L, new long[]{10000L, 10000L, 1500L, 1000L, 500L}, aOreStack, OP.crushedPurified.mat(aMaterial, (long)aMultiplier), OP.crushedPurified.mat(aMaterial, (long)aMultiplier), ST.amount(aMultiplier, tPrimaryByProductTiny), ST.amount(aMultiplier, tSecondaryByProductTiny), ST.amount(aMultiplier, tTertiaryByProductTiny));
            }
            return true;
        }
    }

    public static class RecyclingProcessing
    implements IOreDictListenerRecyclable {
        @Override
        public void onRecycleableRegistration(IOreDictListenerRecyclable.OreDictRecyclingContainer aEvent) {
            OreDictMaterialStack tMaterial2;
            if (aEvent.mItemData == null || !ST.ingredable(aEvent.mStack)) {
                return;
            }
            ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
            if (aEvent.mItemData.mPrefix == null) {
                for (OreDictMaterialStack tMaterial2 : aEvent.mItemData.getAllMaterialStacks()) {
                    if (tMaterial2.mAmount >= OP.dustDiv72.mAmount) {
                        if (tMaterial2.mMaterial == MT.Paper) {
                            RM.Mortar.addRecipe1(true, 16L, 16L, aEvent.mStack, OM.dust(tMaterial2.mMaterial, tMaterial2.mAmount));
                        }
                        if (aEvent.mItemData.mByProducts.length <= 0 && tMaterial2.mMaterial == MT.Bone) {
                            RM.Mortar.addRecipe1(true, 16L, 16L, aEvent.mStack, OM.dust(tMaterial2.mMaterial, tMaterial2.mAmount));
                        }
                    }
                    if (tMaterial2.mMaterial.mTargetSmelting.mAmount <= 0L || !tMaterial2.mMaterial.contains(TD.Processing.MELTING) || tMaterial2.mMaterial.contains(TD.Processing.BLACKLISTED_SMELTER)) continue;
                    OM.stack(UT.Code.units(tMaterial2.mAmount, 648648000L, tMaterial2.mMaterial.mTargetSmelting.mAmount, false), tMaterial2.mMaterial.mTargetSmelting.mMaterial).addToList(tList);
                }
            } else {
                if (aEvent.mItemData.mPrefix.containsAny(TD.Prefix.ORE_PROCESSING_DIRTY, TD.Prefix.ORE)) {
                    return;
                }
                for (OreDictMaterialStack tMaterial2 : aEvent.mItemData.getAllMaterialStacks()) {
                    if (tMaterial2.mMaterial.mTargetSmelting.mAmount <= 0L || !tMaterial2.mMaterial.contains(TD.Processing.MELTING) || tMaterial2.mMaterial.contains(TD.Processing.BLACKLISTED_SMELTER)) continue;
                    OM.stack(UT.Code.units(tMaterial2.mAmount, 648648000L, tMaterial2.mMaterial.mTargetSmelting.mAmount, false), tMaterial2.mMaterial.mTargetSmelting.mMaterial).addToList(tList);
                }
            }
            if (tList.isEmpty()) {
                return;
            }
            FluidStack tFluid = null;
            tMaterial2 = null;
            for (OreDictMaterialStack iMaterial : tList) {
                if (iMaterial.mMaterial == MT.Aerotheum) {
                    if (iMaterial.mMaterial.mGas == null) continue;
                    if (tFluid == null) {
                        tMaterial2 = iMaterial;
                        tFluid = iMaterial.mMaterial.gas(iMaterial.mAmount, false);
                        continue;
                    }
                    tFluid = null;
                    break;
                }
                if (iMaterial.mMaterial.mLiquid == null) continue;
                if (tFluid == null) {
                    tMaterial2 = iMaterial;
                    tFluid = iMaterial.mMaterial.liquid(iMaterial.mAmount, false);
                    continue;
                }
                tFluid = null;
                break;
            }
            if (tFluid != null && tFluid.amount > 0 && tMaterial2 != null) {
                if (tMaterial2.mMaterial.contains(TD.Processing.FURNACE) || tMaterial2.mMaterial.mTargetSmelting.mMaterial == MT.CaCO3) {
                    RM.Melter.addRecipe1(true, 16L, (long)Math.max(FL.Lava.is(tFluid) ? (double)UT.Code.divup((long)tFluid.amount * (long)CS.EU_PER_LAVA, 16L) : 16.0, OM.weight(aEvent.mItemData.getAllMaterialStacks()) * (double)(Math.max(tMaterial2.mMaterial.mMeltingPoint, (long)tFluid.getFluid().getTemperature()) - 293L) / 1600.0), aEvent.mStack, CS.NF, tFluid, CS.ZL_IS);
                }
                RM.Smelter.addRecipe1(true, 16L, (long)Math.max(FL.Lava.is(tFluid) ? (double)UT.Code.divup((long)tFluid.amount * (long)CS.EU_PER_LAVA, 16L) : 16.0, OM.weight(aEvent.mItemData.getAllMaterialStacks()) * (double)(Math.max(tMaterial2.mMaterial.mMeltingPoint, (long)tFluid.getFluid().getTemperature()) - 293L) / 1600.0), aEvent.mStack, CS.NF, tFluid, CS.ZL_IS);
            }
        }
    }

    public static class OreProcessing_CoversMulti
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        public final OreDictPrefix[] mTargetPrefixes;

        public OreProcessing_CoversMulti(ICondition<OreDictMaterial> aCondition, OreDictPrefix ... aTargetPrefixes) {
            this.mTargetPrefixes = aTargetPrefixes;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial) && ST.block(aEvent.mStack) == CS.NB && CoverRegistry.get(aEvent.mStack) == null) {
                ITexture[] tTextures = new ITexture[this.mTargetPrefixes.length];
                for (int i = 0; i < tTextures.length; ++i) {
                    tTextures[i] = BlockTextureDefault.get(aEvent.mMaterial, this.mTargetPrefixes[i]);
                }
                CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureMulti(aEvent.mMaterial != MT.Paper, false, tTextures));
            }
        }
    }

    public static class OreProcessing_CoversSimple
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        public final OreDictPrefix mTargetPrefix;

        public OreProcessing_CoversSimple(ICondition<OreDictMaterial> aCondition, OreDictPrefix aTargetPrefix) {
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(BlockTextureDefault.get(aEvent.mMaterial, this.mTargetPrefix)));
            }
        }
    }
}

