/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase11AttachmentSmall;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import openblocks.common.LiquidXpUtils;
import openmods.utils.EnchantmentUtils;

public class MultiTileEntityFluidNozzle
extends TileEntityBase11AttachmentSmall {
    public boolean mAcidProof = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/nozzle/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityTapAccessible) {
                ItemStack aStack = aPlayer.func_71045_bC();
                if (CS.ItemsGT.VOIDING_ITEMS.contains(aStack, false)) {
                    UT.Sounds.send("random.fizz", 1.0f, 2.0f, this, false);
                    CS.GarbageGT.trash(((ITileEntityTapAccessible)tDelegator.mTileEntity).nozzleDrain(tDelegator.mSideOfTileEntity, Integer.MAX_VALUE, true));
                    return true;
                }
                FluidStack aFluid = ((ITileEntityTapAccessible)tDelegator.mTileEntity).nozzleDrain(tDelegator.mSideOfTileEntity, Integer.MAX_VALUE, false);
                if (FL.gas(aFluid, false) && aFluid.amount > 0 && (this.mAcidProof || !FL.acid(aFluid))) {
                    if (aStack == null) {
                        if (FL.XP.is(aFluid)) {
                            if (MD.OB.mLoaded) {
                                try {
                                    int tXP = Math.min(LiquidXpUtils.liquidToXpRatio((int)aFluid.amount), UT.Code.roundUp((float)EnchantmentUtils.getExperienceForLevel((int)(aPlayer.field_71068_ca + 1)) - ((float)EnchantmentUtils.getExperienceForLevel((int)aPlayer.field_71068_ca) + aPlayer.field_71106_cc * (float)aPlayer.func_71050_bK())));
                                    int tDrain = LiquidXpUtils.xpToLiquidRatio((int)tXP);
                                    if (tDrain > 0 && tXP > 0) {
                                        ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tDrain, true);
                                        this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace(CS.ERR);
                                }
                                return true;
                            }
                            int tXP = Math.min(50, aFluid.amount / 20);
                            if (tXP > 0) {
                                ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tXP * 20, true);
                                this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                            }
                            return true;
                        }
                        if (FL.Mob.is(aFluid)) {
                            int tXP = Math.min(50, aFluid.amount * 3 / 200);
                            if (tXP > 0) {
                                ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tXP * 200 / 3, true);
                                this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                            }
                            return true;
                        }
                        return true;
                    }
                    FluidStack tNewFluid = aFluid.copy();
                    ItemStack tStack = FL.fill(tNewFluid, ST.amount(1L, aStack), true, true, true, true);
                    if (aFluid.amount > tNewFluid.amount && ((ITileEntityTapAccessible)tDelegator.mTileEntity).nozzleDrain(tDelegator.mSideOfTileEntity, aFluid.amount - tNewFluid.amount, true) != null) {
                        UT.Sounds.send("random.fizz", 1.0f, 2.0f, this, false);
                        --aStack.field_77994_a;
                        ST.give((Entity)aPlayer, tStack, true);
                        return true;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 2;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[1], CS.PX_N[6], CS.PX_N[9], CS.PX_N[14]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[14], CS.PX_N[6], CS.PX_N[9], CS.PX_N[1]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[1], CS.PX_P[3], CS.PX_P[6], CS.PX_N[14], CS.PX_N[9], CS.PX_N[6]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[14], CS.PX_P[3], CS.PX_P[6], CS.PX_N[1], CS.PX_N[9], CS.PX_N[6]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[0], CS.PX_N[7], CS.PX_N[10], CS.PX_N[10]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[10], CS.PX_N[7], CS.PX_N[10], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[4], CS.PX_P[7], CS.PX_N[10], CS.PX_N[10], CS.PX_N[7]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[10], CS.PX_P[4], CS.PX_P[7], CS.PX_N[0], CS.PX_N[10], CS.PX_N[7]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 1 && aSide == this.mFacing && !aShouldSideBeRendered[aSide] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
            }
            default: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
            }
            case 5: 
        }
        return this.box(CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
                break;
            }
            default: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
                break;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
            }
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.nozzle";
    }
}

