/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.util.ST;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenRocks
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenRocks(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_DESERT.contains(tName) && !CS.BIOMES_MESA.contains(tName) && !CS.BIOMES_TAIGA.contains(tName) && !CS.BIOMES_SWAMP.contains(tName) && !CS.BIOMES_SAVANNA.contains(tName) && !CS.BIOMES_PLAINS.contains(tName) && !CS.BIOMES_WOODS.contains(tName) && !CS.BIOMES_MOUNTAINS.contains(tName) && !CS.BIOMES_WASTELANDS.contains(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        if (aContact.func_149688_o() != Material.field_151577_b && aContact.func_149688_o() != Material.field_151578_c && aContact.func_149688_o() != Material.field_151595_p) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        if (WD.easyRep(aWorld, aX, aY + 1, aZ)) {
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY + 1, aZ, (byte)6, (short)32757, aRandom.nextInt(this.mAmount) == 0 ? ST.save("gt.value", aRandom.nextInt(12) == 0 ? (aRandom.nextInt(4) == 0 ? OP.oreRaw : OP.rockGt).mat(MT.MeteoricIron, 1L) : ST.make(Items.field_151145_ak, 1L, 0L)) : null, false, true);
        }
        return false;
    }
}

